/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.AmfMessageDeserializer;
import flex.messaging.io.amf.AmfMessageSerializer;
import flex.messaging.io.amf.AmfTrace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;
import org.owasp.webscarab.util.swing.JTreeTable;
import org.owasp.webscarab.util.swing.treetable.DefaultTreeTableModel;

public class AMFPanel
extends JPanel
implements ByteArrayEditor,
ActionListener {
    private ActionMessage message;
    private ActionContext messageContext;
    private SerializationContext serialContext;
    private byte[] messageBytes;
    private JTabbedPane tabs;
    private JTreeTable treeTable;
    private JTextPane stringsArea;
    private JTextPane hexArea;
    private JButton exportButton;
    private JFileChooser fc;
    public static boolean DEBUG = true;
    private static final String NL = System.getProperty("line.separator", "\n");

    public AMFPanel() {
        super(new GridLayout(1, 1));
        this.setName("AMF");
        this.tabs = new JTabbedPane();
        this.tabs.setTabLayoutPolicy(1);
    }

    public String[] getContentTypes() {
        return new String[]{"application/x-amf"};
    }

    public boolean isModified() {
        return true;
    }

    public void setEditable(boolean editable) {
    }

    public void setBytes(String contentType, byte[] messageBytes) {
        this.messageBytes = (byte[])messageBytes.clone();
        this.parseAMFMessage();
        this.addTreeTable();
        this.updateStringsArea();
        this.updateHexArea();
        this.add(this.tabs);
    }

    public byte[] getBytes() {
        this.encodeAMFMessage();
        return (byte[])this.messageBytes.clone();
    }

    private void parseAMFMessage() {
        try {
            this.serialContext = SerializationContext.getSerializationContext();
            this.serialContext.instantiateTypes = false;
            AmfTrace trace = null;
            if (DEBUG) {
                trace = new AmfTrace();
            }
            AmfMessageDeserializer amfder = new AmfMessageDeserializer();
            amfder.initialize(this.serialContext, (InputStream)new ByteArrayInputStream(this.messageBytes), trace);
            this.message = new ActionMessage();
            this.messageContext = new ActionContext();
            amfder.readMessage(this.message, this.messageContext);
            if (DEBUG) {
                System.err.println(trace);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void encodeAMFMessage() {
        try {
            AmfTrace trace = null;
            if (DEBUG) {
                trace = new AmfTrace();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AmfMessageSerializer amfser = new AmfMessageSerializer();
            amfser.initialize(this.serialContext, (OutputStream)baos, trace);
            amfser.writeMessage(this.message);
            this.messageBytes = baos.toByteArray();
            if (DEBUG) {
                System.out.println(AMFPanel.dump("", this.messageBytes, 0, this.messageBytes.length));
                System.err.println(trace);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static byte[] encodeAMFMessage(ActionMessage message) {
        byte[] messageBytes = null;
        try {
            AmfTrace trace = null;
            if (DEBUG) {
                trace = new AmfTrace();
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AmfMessageSerializer amfser = new AmfMessageSerializer();
            SerializationContext context = SerializationContext.getSerializationContext();
            context.instantiateTypes = false;
            amfser.initialize(context, (OutputStream)baos, trace);
            amfser.writeMessage(message);
            messageBytes = baos.toByteArray();
            if (DEBUG) {
                System.out.println(AMFPanel.dump("", messageBytes, 0, messageBytes.length));
                System.err.println(trace);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return messageBytes;
    }

    private void addTreeTable() {
        AMFTreeTableModel dataTreeTableModel = this.generateModel();
        this.treeTable = new JTreeTable(dataTreeTableModel);
        this.tabs.addTab("AMF", new JScrollPane(this.treeTable));
        this.tabs.setMnemonicAt(0, 49);
    }

    private String strings(byte[] data) {
        StringBuffer sb = new StringBuffer();
        boolean foundString = false;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < data.length; ++i) {
            char ch = (char)(data[i] & 0xFF);
            if (ch >= ' ' && ch < '\u007f') {
                baos.write(ch);
                foundString = true;
                continue;
            }
            if (!foundString) continue;
            byte[] tmp = baos.toByteArray();
            sb.append(new String(tmp)).append('\n');
            baos.reset();
            foundString = false;
        }
        return sb.toString();
    }

    void updateStringsArea() {
        if (this.stringsArea == null) {
            this.stringsArea = new JTextPane();
            this.stringsArea.setFont(new Font("Monospaced", 0, 12));
            this.stringsArea.setEditable(false);
            this.stringsArea.setText(this.strings(this.messageBytes));
            this.tabs.addTab("Strings", new JScrollPane(this.stringsArea));
            this.tabs.setMnemonicAt(1, 50);
        } else {
            this.stringsArea.setText(this.strings(this.messageBytes));
        }
    }

    void updateHexArea() {
        if (this.hexArea == null) {
            this.fc = new JFileChooser();
            this.exportButton = new JButton("Export");
            this.exportButton.addActionListener(this);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.exportButton);
            this.hexArea = new JTextPane();
            this.hexArea.setFont(new Font("Monospaced", 0, 12));
            this.hexArea.setEditable(false);
            this.hexArea.setText(AMFPanel.dump("", this.messageBytes, 0, this.messageBytes.length));
            JPanel hexPanel = new JPanel(new BorderLayout());
            hexPanel.add((Component)buttonPanel, "Last");
            hexPanel.add((Component)new JScrollPane(this.hexArea), "Center");
            this.tabs.addTab("HEX", hexPanel);
            this.tabs.setMnemonicAt(2, 51);
        } else {
            this.hexArea.setText(AMFPanel.dump("", this.messageBytes, 0, this.messageBytes.length));
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            int returnVal;
            if (e.getSource() == this.exportButton && (returnVal = this.fc.showSaveDialog(this)) == 0) {
                File file = this.fc.getSelectedFile();
                if (DEBUG) {
                    System.out.print("Exporting data to file " + file.getCanonicalPath() + "...");
                }
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(this.messageBytes);
                fos.close();
                if (DEBUG) {
                    System.out.println("done");
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public AMFTreeTableModel generateModel() {
        AMFTreeTableNode rootNode = new AMFTreeTableNode(new AMFData("Message", "", ""));
        AMFTreeTableNode headersNode = new AMFTreeTableNode(new AMFData("Headers", "", ""));
        rootNode.add(headersNode);
        for (int i = 0; i < this.message.getHeaderCount(); ++i) {
            if (DEBUG) {
                System.out.println("Reading header: " + i);
            }
            AMFTreeTableNode headerNode = new AMFTreeTableNode(new AMFData("[" + i + "]", "Header Part", ""));
            headersNode.add(headerNode);
            this.addObject(headerNode, this.message.getHeader(i));
        }
        AMFTreeTableNode bodiesNode = new AMFTreeTableNode(new AMFData("Bodies", "", ""));
        rootNode.add(bodiesNode);
        for (int i = 0; i < this.message.getBodyCount(); ++i) {
            if (DEBUG) {
                System.out.println("Reading body: " + i);
            }
            AMFTreeTableNode bodyNode = new AMFTreeTableNode(new AMFData("[" + i + "]", "Body Part", ""));
            bodiesNode.add(bodyNode);
            this.addObject(bodyNode, this.message.getBody(i));
        }
        return new AMFTreeTableModel(rootNode);
    }

    private boolean isComplex(Object object) {
        return object instanceof Object[] || object instanceof HashMap || object instanceof List || object != null && object.getClass().getPackage().toString().contains("flex.messaging.messages");
    }

    private void addObject(AMFTreeTableNode node, Object object) {
        try {
            if (object instanceof Object[]) {
                AMFTreeTableNode objectsNode = new AMFTreeTableNode(new AMFData("", "Array", ""));
                node.add(objectsNode);
                Object[] array = (Object[])object;
                for (int i = 0; i < array.length; ++i) {
                    this.addObject(objectsNode, array[i]);
                }
            } else if (object instanceof HashMap) {
                AMFTreeTableNode hashNode = new AMFTreeTableNode(new AMFData("", "HashMap", ""));
                node.add(hashNode);
                HashMap map = (HashMap)object;
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    AMFTreeTableNode dataNode = new AMFTreeTableNode(new AMFData(key, map, true, this.message));
                    hashNode.add(dataNode);
                }
            } else {
                Method[] methods = object.getClass().getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method m = methods[i];
                    String name = m.getName();
                    Class<?>[] paramTypes = m.getParameterTypes();
                    if (!name.startsWith("get") || name.equals("getClass") || paramTypes.length != 0) continue;
                    Object val = m.invoke(object, null);
                    if (this.isComplex(val)) {
                        this.addObject(node, val);
                        continue;
                    }
                    String getter = name.substring(3);
                    AMFData data = new AMFData(getter, object, true, this.message);
                    AMFTreeTableNode objectNode = new AMFTreeTableNode(data);
                    node.add(objectNode);
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static boolean isprint(int c) {
        return !(c >= 0 && c <= 33 || c > 126 && c <= 256);
    }

    static String dump(String desc, byte[] data, int off, int len) {
        char c;
        int j;
        int o;
        int i;
        String hex = "0123456789abcdef";
        StringBuffer sb = new StringBuffer();
        if (desc.length() != 0) {
            sb.append(desc + NL);
        }
        int n = len / 16;
        for (i = 0; i < n; ++i) {
            o = i * 16;
            sb.append("0123456789abcdef".charAt(o >>> 12 & 0xF));
            sb.append("0123456789abcdef".charAt(o >>> 8 & 0xF));
            sb.append("0123456789abcdef".charAt(o >>> 4 & 0xF));
            sb.append("0123456789abcdef".charAt(o & 0xF));
            sb.append(": ");
            for (j = 0; j < 16; ++j) {
                o = data[off + i * 16 + j] & 0xFF;
                sb.append("0123456789abcdef".charAt(o >>> 4 & 0xF));
                sb.append("0123456789abcdef".charAt(o & 0xF));
                sb.append(" ");
            }
            sb.append("  ");
            for (j = 0; j < 16; ++j) {
                c = (char)(data[off + i * 16 + j] & 0xFF);
                sb.append(AMFPanel.isprint(c) ? c : (char)'.');
            }
            sb.append(NL);
        }
        n = len % 16;
        if (n != 0) {
            o = i * 16;
            sb.append("0123456789abcdef".charAt(o >>> 12 & 0xF));
            sb.append("0123456789abcdef".charAt(o >>> 8 & 0xF));
            sb.append("0123456789abcdef".charAt(o >>> 4 & 0xF));
            sb.append("0123456789abcdef".charAt(o & 0xF));
            sb.append(": ");
            for (j = 0; j < n; ++j) {
                o = data[off + i * 16 + j] & 0xFF;
                sb.append("0123456789abcdef".charAt(o >>> 4 & 0xF));
                sb.append("0123456789abcdef".charAt(o & 0xF));
                sb.append(" ");
            }
            for (j = n; j < 16; ++j) {
                sb.append("   ");
            }
            sb.append("  ");
            for (j = 0; j < n; ++j) {
                c = (char)(data[off + i * 16 + j] & 0xFF);
                sb.append(AMFPanel.isprint(c) ? c : (char)'.');
            }
            sb.append(NL);
        }
        return sb.toString();
    }

    private static byte[] readfile(String filename) {
        byte[] tmp = null;
        try {
            RandomAccessFile raf = new RandomAccessFile(filename, "r");
            tmp = new byte[(int)raf.length()];
            raf.readFully(tmp);
            raf.close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return tmp;
    }

    public static void main(String[] args) {
        try {
            byte[] messageBytes = AMFPanel.readfile("c:\\temp\\temp\\amf-passwd-res.bin");
            JFrame mainFrame = new JFrame("AMF Panel");
            mainFrame.setDefaultCloseOperation(3);
            AMFPanel amfPanel = new AMFPanel();
            amfPanel.setBytes("", messageBytes);
            mainFrame.getContentPane().add(amfPanel);
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            mainFrame.setSize(screenSize.width * 2 / 3, screenSize.height * 2 / 3);
            mainFrame.setLocationRelativeTo(null);
            mainFrame.pack();
            mainFrame.setVisible(true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static class AMFTreeTableModel
    extends DefaultTreeTableModel {
        private static String[] columnNames = new String[]{"Field", "Type", "Value"};

        public AMFTreeTableModel(TreeNode node) {
            super(node);
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            return columnNames[column];
        }

        public Class getColumnClass(int column) {
            return super.getColumnClass(column);
        }

        public Object getValueAt(Object node, int column) {
            AMFTreeTableNode n = (AMFTreeTableNode)node;
            return n.getValueAt(column);
        }

        public boolean isCellEditable(Object node, int column) {
            if (column == 0) {
                return true;
            }
            AMFTreeTableNode n = (AMFTreeTableNode)node;
            return n.isEditable(column);
        }

        public void setValueAt(Object value, Object node, int column) {
            AMFTreeTableNode n = (AMFTreeTableNode)node;
            n.setValueAt(value, column);
        }
    }

    private static class AMFTreeTableNode
    extends DefaultMutableTreeNode {
        public AMFTreeTableNode(AMFData data) {
            super(data);
        }

        public boolean isEditable(int column) {
            return column == 2;
        }

        public void setValueAt(Object value, int column) {
            if (DEBUG) {
                System.out.println("Setting value at column " + column + " to " + value + " (an instance of " + value.getClass() + ")");
            }
            if (this.getUserObject() instanceof AMFData) {
                AMFData data = (AMFData)this.getUserObject();
                switch (column) {
                    case 2: {
                        data.setValue(value.toString());
                    }
                }
            }
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int column) {
            if (this.getUserObject() instanceof AMFData) {
                AMFData data = (AMFData)this.getUserObject();
                switch (column) {
                    case 0: {
                        return data.getField();
                    }
                    case 1: {
                        return data.getType();
                    }
                    case 2: {
                        return data.getValue();
                    }
                }
            }
            throw new RuntimeException("Unknown user object: " + this.getUserObject());
        }
    }

    private static class AMFData {
        private String field;
        private String type;
        private Class typeClass;
        private String value;
        private Object object;
        private boolean isEditable;
        private ActionMessage message;

        private static String OBJ_TYPE(Object o) {
            if (o == null) {
                return "Null";
            }
            String s = o.getClass().getName();
            StringTokenizer token = new StringTokenizer(s, ".");
            while (token.hasMoreElements()) {
                s = (String)token.nextElement();
            }
            return s;
        }

        private static String OBJ_VALUE(Object o) {
            if (o == null) {
                return "";
            }
            return o.toString();
        }

        private static Class OBJ_CLASS(Object o) {
            if (o == null) {
                return null;
            }
            return o.getClass();
        }

        public AMFData(String field, String type, String value) {
            this.field = field;
            this.type = type;
            this.typeClass = null;
            this.value = value;
            this.object = null;
            this.isEditable = false;
        }

        public AMFData(String field, Object object, boolean isEditable, ActionMessage message) {
            try {
                Object value;
                this.field = field;
                if (object instanceof HashMap) {
                    value = ((HashMap)object).get(field);
                } else {
                    Method m = object.getClass().getMethod("get" + field, null);
                    value = m.invoke(object, null);
                }
                this.type = AMFData.OBJ_TYPE(value);
                this.typeClass = AMFData.OBJ_CLASS(value);
                this.value = AMFData.OBJ_VALUE(value);
                this.object = object;
                this.isEditable = isEditable;
                this.message = message;
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        public String getField() {
            return this.field;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            if (!this.isEditable) {
                return;
            }
            if (DEBUG) {
                System.out.println("Setting " + value);
            }
            try {
                if (this.object instanceof HashMap) {
                    ((HashMap)this.object).put(this.field, value);
                } else if (this.type.equals("Long")) {
                    Method m = this.object.getClass().getMethod("set" + this.field, Long.TYPE);
                    m.invoke(this.object, new Long(value));
                } else {
                    Method m = this.object.getClass().getMethod("set" + this.field, this.typeClass);
                    m.invoke(this.object, value);
                }
                this.value = value;
                AMFPanel.encodeAMFMessage(this.message);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        public String toString() {
            return this.field;
        }
    }
}

