/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Script;
import org.owasp.webscarab.plugin.ScriptListener;
import org.owasp.webscarab.plugin.ScriptManager;
import org.owasp.webscarab.util.swing.JTreeTable;
import org.owasp.webscarab.util.swing.treetable.AbstractTreeTableModel;

public class ScriptManagerFrame
extends JFrame
implements ScriptListener {
    private static final long serialVersionUID = -6841423959579700341L;
    private ScriptManager _manager;
    private JTreeTable _hookTree;
    private HookScriptTreeModel _treeModel;
    private JButton addButton;
    private JTextArea descriptionTextArea;
    private JScrollPane hookScrollPane;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JButton newButton;
    private JButton removeButton;
    private JButton saveAsButton;
    private JButton saveButton;
    private JTextArea scriptTextArea;
    private JTextField scriptTextField;
    private JToolBar scriptToolBar;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ScriptManagerFrame(ScriptManager manager) {
        this._manager = manager;
        this._treeModel = new HookScriptTreeModel();
        this.initComponents();
        this._hookTree = new JTreeTable(this._treeModel);
        this.hookScrollPane.getViewport().add(this._hookTree);
        this._hookTree.setModel(this._treeModel);
        final JTree hookTree = this._hookTree.getTree();
        hookTree.getSelectionModel().setSelectionMode(1);
        hookTree.setRootVisible(false);
        hookTree.setShowsRootHandles(true);
        hookTree.setCellRenderer(new HookTreeRenderer());
        hookTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath selection = hookTree.getSelectionPath();
                if (selection != null) {
                    Object o = selection.getLastPathComponent();
                    if (o instanceof Hook) {
                        ScriptManagerFrame.this.showHook((Hook)o);
                        ScriptManagerFrame.this.showScript(null);
                    } else if (o instanceof Script) {
                        ScriptManagerFrame.this.showHook((Hook)selection.getParentPath().getLastPathComponent());
                        ScriptManagerFrame.this.showScript((Script)o);
                    }
                } else {
                    ScriptManagerFrame.this.showHook(null);
                    ScriptManagerFrame.this.showScript(null);
                }
            }
        });
        this._hookTree.getColumnModel().getColumn(1).setMaxWidth(50);
        this._manager.addScriptListener(this);
    }

    private void showHook(Hook hook) {
        if (hook != null) {
            this.descriptionTextArea.setText(hook.getDescription());
            this.descriptionTextArea.setCaretPosition(0);
            this.addButton.setEnabled(true);
        } else {
            this.descriptionTextArea.setText("");
            this.addButton.setEnabled(false);
        }
    }

    private void showScript(Script script) {
        if (script == null) {
            this.scriptTextField.setText("");
            this.scriptTextArea.setText("");
            this.removeButton.setEnabled(false);
        } else {
            this.scriptTextField.setText(script.getFile().getAbsolutePath());
            this.scriptTextArea.setText(script.getScript());
            this.scriptTextArea.setCaretPosition(0);
            this.removeButton.setEnabled(true);
        }
        this.saveButton.setEnabled(false);
    }

    public void hooksChanged() {
        this._treeModel.fireStructureChanged();
    }

    public void hookStarted(String plugin, Hook hook) {
    }

    public void scriptStarted(String plugin, Hook hook, Script script) {
    }

    public void scriptChanged(final String plugin, final Hook hook, final Script script) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScriptManagerFrame.this._treeModel.firePathChanged(new TreePath(new Object[]{ScriptManagerFrame.this._treeModel.getRoot(), plugin, hook, script}));
            }
        });
    }

    public void scriptEnded(String plugin, Hook hook, Script script) {
    }

    public void hookEnded(String plugin, Hook hook) {
    }

    public void scriptError(final String plugin, final Hook hook, final Script script, final Throwable error) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JOptionPane.showMessageDialog(null, new String[]{"Error running script : ", plugin + hook.getName(), script.getFile().getName(), error.getMessage()}, "Error", 0);
            }
        });
    }

    public void scriptAdded(String plugin, Hook hook, Script script) {
        this._treeModel.fireTreeStructureChanged(new TreePath(new Object[]{this._treeModel.getRoot(), plugin, hook}));
    }

    public void scriptRemoved(String plugin, Hook hook, Script script) {
        this._treeModel.fireTreeStructureChanged(new TreePath(new Object[]{this._treeModel.getRoot(), plugin, hook}));
    }

    private void initComponents() {
        this.scriptToolBar = new JToolBar();
        this.newButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.saveButton = new JButton();
        this.saveAsButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.hookScrollPane = new JScrollPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.scriptTextField = new JTextField();
        this.jScrollPane3 = new JScrollPane();
        this.scriptTextArea = new JTextArea();
        this.setTitle("Scripted Events");
        this.scriptToolBar.setFloatable(false);
        this.newButton.setText("New");
        this.newButton.setEnabled(false);
        this.scriptToolBar.add(this.newButton);
        this.addButton.setText("Add");
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptManagerFrame.this.addButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.addButton);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptManagerFrame.this.removeButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.removeButton);
        this.saveButton.setText("Save");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptManagerFrame.this.saveButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.saveButton);
        this.saveAsButton.setText("Save As");
        this.saveAsButton.setEnabled(false);
        this.scriptToolBar.add(this.saveAsButton);
        this.getContentPane().add((Component)this.scriptToolBar, "North");
        this.jSplitPane1.setResizeWeight(0.3);
        this.hookScrollPane.setMinimumSize(new Dimension(200, 100));
        this.hookScrollPane.setVerifyInputWhenFocusTarget(false);
        this.jSplitPane1.setLeftComponent(this.hookScrollPane);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(0.3);
        this.jPanel2.setLayout(new BorderLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(300, 48));
        this.descriptionTextArea.setBackground(new Color(204, 204, 204));
        this.descriptionTextArea.setEditable(false);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setBorder(null);
        this.descriptionTextArea.setMinimumSize(new Dimension(200, 45));
        this.descriptionTextArea.setPreferredSize(new Dimension(400, 45));
        this.jScrollPane1.setViewportView(this.descriptionTextArea);
        this.jPanel2.add((Component)this.jScrollPane1, "Center");
        this.jLabel3.setText("Hook description : ");
        this.jPanel2.add((Component)this.jLabel3, "North");
        this.jSplitPane2.setLeftComponent(this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setText("Script : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.scriptTextField.setBackground(new Color(204, 204, 204));
        this.scriptTextField.setEditable(false);
        this.scriptTextField.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel3.add((Component)this.scriptTextField, gridBagConstraints);
        this.jScrollPane3.setPreferredSize(new Dimension(200, 200));
        this.scriptTextArea.setBackground(new Color(204, 204, 204));
        this.scriptTextArea.setEditable(false);
        this.jScrollPane3.setViewportView(this.scriptTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jSplitPane2.setRightComponent(this.jPanel3);
        this.jSplitPane1.setRightComponent(this.jSplitPane2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 600) / 2, (screenSize.height - 400) / 2, 600, 400);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        TreePath path = this._hookTree.getTree().getSelectionPath();
        if (path.getPathCount() == 4) {
            String plugin = (String)path.getPathComponent(1);
            Hook hook = (Hook)path.getPathComponent(2);
            Script script = (Script)path.getPathComponent(3);
            this._manager.removeScript(plugin, hook, script);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        TreePath path = this._hookTree.getTree().getSelectionPath();
        String plugin = null;
        Hook hook = null;
        if (path.getPathCount() < 3) {
            return;
        }
        plugin = (String)path.getPathComponent(1);
        hook = (Hook)path.getPathComponent(2);
        JFileChooser jfc = new JFileChooser(Preferences.getPreference("ScriptManager.DefaultDirectory"));
        jfc.setDialogTitle("Load script");
        int returnVal = jfc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = jfc.getSelectedFile();
            try {
                Script script = new Script(file);
                this._manager.addScript(plugin, hook, script);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, new String[]{"Error loading Script : ", e.getMessage()}, "Error", 0);
            }
        }
        Preferences.setPreference("ScriptManager.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
    }

    private class HookTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1889788178767738909L;

        private HookTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof Hook && comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                Hook hook = (Hook)value;
                if (hook != null) {
                    label.setText(hook.getName());
                }
            } else if (value instanceof Script && comp instanceof JLabel) {
                JLabel label = (JLabel)comp;
                Script script = (Script)value;
                if (script != null) {
                    label.setText(script.getFile().getName());
                }
            }
            return comp;
        }
    }

    private class HookScriptTreeModel
    extends AbstractTreeTableModel {
        Object _root = new String("RooT");

        private HookScriptTreeModel() {
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return super.getColumnClass(column);
            }
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ScriptManagerFrame.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int i) {
            if (i == 1) {
                return "Enabled";
            }
            return "";
        }

        public Object getValueAt(Object node, int column) {
            if (column == 0) {
                return node;
            }
            if (node instanceof Script) {
                Script script = (Script)node;
                return new Boolean(script.isEnabled());
            }
            return null;
        }

        public Object getChild(Object parent, int index) {
            if (parent == this._root) {
                return ScriptManagerFrame.this._manager.getPlugin(index);
            }
            if (parent instanceof String) {
                return ScriptManagerFrame.this._manager.getHook((String)parent, index);
            }
            if (parent instanceof Hook) {
                return ((Hook)parent).getScript(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent == this._root) {
                return ScriptManagerFrame.this._manager.getPluginCount();
            }
            if (parent instanceof String) {
                return ScriptManagerFrame.this._manager.getHookCount((String)parent);
            }
            if (parent instanceof Hook) {
                return ((Hook)parent).getScriptCount();
            }
            return 0;
        }

        public Object getRoot() {
            return this._root;
        }

        public boolean isLeaf(Object node) {
            return node instanceof Script;
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public void fireStructureChanged() {
            super.fireStructureChanged();
        }

        public void fireTreeStructureChanged(TreePath path) {
            super.fireTreeStructureChanged(path);
        }

        public void firePathChanged(TreePath path) {
            super.firePathChanged(path);
        }

        public void setValueAt(Object aValue, Object node, int column) {
            if (column == 1 && node instanceof Script) {
                ((Script)node).setEnabled(aValue == Boolean.TRUE);
            } else {
                super.setValueAt(aValue, node, column);
            }
        }

        public boolean isCellEditable(Object node, int column) {
            if (node instanceof Script && column == 1) {
                return true;
            }
            return super.isCellEditable(node, column);
        }
    }
}

