/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.ui.swing.MessagePanel;
import org.owasp.webscarab.ui.swing.editors.TextPanel;

public class ResponsePanel
extends JPanel {
    private static final long serialVersionUID = 4667896968499809048L;
    private boolean[] _upToDate;
    private boolean _editable = false;
    private boolean _modified = false;
    private int _selected = 0;
    private Response _response = null;
    private MessagePanel _messagePanel;
    private TextPanel _textPanel;
    private static int _preferred = -1;
    private JTabbedPane displayTabbedPane;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel messagePanelPlaceHolder;
    private JTextField messageTextField;
    private JPanel parsedPanel;
    private JTextField statusTextField;
    private JTextField versionTextField;

    public ResponsePanel() {
        this.initComponents();
        this._messagePanel = new MessagePanel();
        this.parsedPanel.remove(this.messagePanelPlaceHolder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.parsedPanel.add((Component)this._messagePanel, gridBagConstraints);
        this._textPanel = new TextPanel();
        this.displayTabbedPane.add("Raw", this._textPanel);
        this.setEditable(false);
        this._upToDate = new boolean[this.displayTabbedPane.getTabCount()];
        this.invalidatePanels();
        this.updateComponents(this._editable);
        this.displayTabbedPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ResponsePanel.this.updateResponse(ResponsePanel.this._selected);
                ResponsePanel.this._selected = ResponsePanel.this.displayTabbedPane.getSelectedIndex();
                _preferred = ResponsePanel.this._selected;
                if (ResponsePanel.this._selected >= 0) {
                    ResponsePanel.this.updatePanel(ResponsePanel.this._selected);
                }
            }
        });
        if (_preferred > -1 && _preferred < this.displayTabbedPane.getTabCount()) {
            this.displayTabbedPane.setSelectedIndex(_preferred);
        }
    }

    private void invalidatePanels() {
        for (int i = 0; i < this._upToDate.length; ++i) {
            this._upToDate[i] = false;
        }
    }

    private void updateResponse(int panel) {
        if (!this._editable || panel < 0) {
            return;
        }
        if (this.displayTabbedPane.getTitleAt(panel).equals("Parsed")) {
            if (this._messagePanel.isModified()) {
                this._response = (Response)this._messagePanel.getMessage();
                this._modified = true;
                this.invalidatePanels();
            }
            if (this._response == null) {
                this._response = new Response();
            }
            this._response.setStatus(this.statusTextField.getText());
            this._response.setMessage(this.messageTextField.getText());
            this._response.setVersion(this.versionTextField.getText());
        } else if (this.displayTabbedPane.getTitleAt(panel).equals("Raw") && this._textPanel.isModified()) {
            try {
                Response r = new Response();
                r.parse(new String(this._textPanel.getBytes()));
                this._response = r;
            }
            catch (Exception e) {
                System.err.println("Error parsing the rawTextArea, abandoning changes : " + e);
            }
            this._modified = true;
            this.invalidatePanels();
        }
        this._upToDate[panel] = true;
    }

    public boolean isModified() {
        return this._modified;
    }

    private void updatePanel(int panel) {
        if (!this._upToDate[panel]) {
            if (this.displayTabbedPane.getTitleAt(panel).equals("Parsed")) {
                this._messagePanel.setMessage(this._response);
                if (this._response != null) {
                    this.statusTextField.setText(this._response.getStatus());
                    this.messageTextField.setText(this._response.getMessage());
                    this.versionTextField.setText(this._response.getVersion());
                } else {
                    this.statusTextField.setText("");
                    this.messageTextField.setText("");
                    this.versionTextField.setText("");
                }
            } else if (this.displayTabbedPane.getTitleAt(panel).equals("Raw")) {
                if (this._response != null) {
                    this._textPanel.setText(null, this._response.toString("\n"));
                } else {
                    this._textPanel.setText(null, "");
                }
            }
            this._upToDate[panel] = true;
        }
    }

    public void updateComponents(boolean editable) {
        Color color = editable ? new Color(255, 255, 255) : new Color(204, 204, 204);
        this.statusTextField.setEditable(editable);
        this.messageTextField.setEditable(editable);
        this.versionTextField.setEditable(editable);
        this.statusTextField.setBackground(color);
        this.messageTextField.setBackground(color);
        this.versionTextField.setBackground(color);
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._textPanel.setEditable(editable);
        this._messagePanel.setEditable(editable);
    }

    public void setResponse(Response response) {
        this._modified = false;
        this._response = response != null ? new Response(response) : null;
        this.invalidatePanels();
        if (SwingUtilities.isEventDispatchThread()) {
            this.updatePanel(this.displayTabbedPane.getSelectedIndex());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ResponsePanel.this.updatePanel(ResponsePanel.this.displayTabbedPane.getSelectedIndex());
                }
            });
        }
    }

    public Response getResponse() {
        if (this._editable) {
            int panel = this.displayTabbedPane.getSelectedIndex();
            this.updateResponse(panel);
        }
        return this._response;
    }

    public void selectPanel(String title) {
        for (int i = 0; i < this.displayTabbedPane.getTabCount(); ++i) {
            String tab = this.displayTabbedPane.getTitleAt(i);
            int selected = this.displayTabbedPane.getSelectedIndex();
            if (tab == null || !tab.equalsIgnoreCase(title) || i == selected) continue;
            this.displayTabbedPane.setSelectedIndex(i);
            return;
        }
    }

    private void initComponents() {
        this.displayTabbedPane = new JTabbedPane();
        this.parsedPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.statusTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.messageTextField = new JTextField();
        this.messagePanelPlaceHolder = new JPanel();
        this.jLabel5 = new JLabel();
        this.versionTextField = new JTextField();
        this.setLayout(new BorderLayout());
        this.parsedPanel.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.statusTextField);
        this.jLabel3.setText("Status");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.anchor = 17;
        this.parsedPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.statusTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.parsedPanel.add((Component)this.statusTextField, gridBagConstraints);
        this.jLabel4.setLabelFor(this.messageTextField);
        this.jLabel4.setText("Message");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.anchor = 17;
        this.parsedPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.messageTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        this.parsedPanel.add((Component)this.messageTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.parsedPanel.add((Component)this.messagePanelPlaceHolder, gridBagConstraints);
        this.jLabel5.setLabelFor(this.messageTextField);
        this.jLabel5.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        gridBagConstraints.anchor = 17;
        this.parsedPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.versionTextField.setBackground(new Color(204, 204, 204));
        this.versionTextField.setEditable(false);
        this.versionTextField.setMinimumSize(new Dimension(65, 19));
        this.versionTextField.setPreferredSize(new Dimension(65, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 13;
        this.parsedPanel.add((Component)this.versionTextField, gridBagConstraints);
        this.displayTabbedPane.addTab("Parsed", this.parsedPanel);
        this.add((Component)this.displayTabbedPane, "Center");
    }

    public static void main(String[] args) {
        final JFrame top = new JFrame("Response Panel");
        top.getContentPane().setLayout(new BorderLayout());
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        final ResponsePanel rp = new ResponsePanel();
        rp.setEditable(false);
        top.getContentPane().add(rp);
        top.setBounds(100, 100, 800, 600);
        top.setVisible(true);
        if (args.length == 0) {
            JButton button = new JButton("NEXT");
            final BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            top.getContentPane().add((Component)button, "South");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ResponsePanel.loadResponse(top, rp, br);
                }
            });
            ResponsePanel.loadResponse(top, rp, br);
        } else if (args.length == 1) {
            ResponsePanel.loadResponse(top, rp, args[0]);
        }
    }

    private static void loadResponse(JFrame top, ResponsePanel rp, String file) {
        Response response = new Response();
        try {
            FileInputStream fis = new FileInputStream(file);
            response.read(fis);
            response.flushContentStream();
            fis.close();
        }
        catch (IOException ioe) {
            System.err.println(file + ": IOException: " + ioe.getMessage());
        }
        rp.setResponse(response);
        top.setTitle(file);
    }

    private static void loadResponse(JFrame top, ResponsePanel rp, BufferedReader br) {
        try {
            String file = br.readLine();
            if (file == null) {
                System.exit(0);
            }
            ResponsePanel.loadResponse(top, rp, file);
        }
        catch (IOException ioe) {
            System.err.println("IOException: " + ioe.getMessage());
        }
    }
}

