/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.ui.swing.MessagePanel;
import org.owasp.webscarab.ui.swing.editors.TextPanel;
import org.owasp.webscarab.util.RequestConverter;

public class RequestPanel
extends JPanel {
    private static final long serialVersionUID = -5571563143330632769L;
    private boolean[] _upToDate;
    private boolean _editable = false;
    private boolean _modified = false;
    private int _selected = 0;
    private Request _request = null;
    private MessagePanel _messagePanel;
    private TextPanel _textPanel;
    private static int _preferred = -1;
    private boolean _reverting = false;
    private JMenuItem convertGetMenuItem;
    private JMenuItem convertMultipartMenuItem;
    private JMenuItem convertPostMenuItem;
    private JTabbedPane displayTabbedPane;
    private JButton editButton;
    private JPopupMenu editOptionsPopupMenu;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel messagePanelPlaceHolder;
    private JTextField methodTextField;
    private JPanel parsedPanel;
    private JTextField urlTextField;
    private JTextField versionTextField;

    public RequestPanel() {
        this.initComponents();
        this.displayTabbedPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                block5: {
                    try {
                        RequestPanel.this.updateRequest(RequestPanel.this._selected);
                        RequestPanel.this._selected = RequestPanel.this.displayTabbedPane.getSelectedIndex();
                        _preferred = RequestPanel.this._selected;
                        if (RequestPanel.this._selected >= 0) {
                            RequestPanel.this.updatePanel(RequestPanel.this._selected);
                        }
                    }
                    catch (MalformedURLException mue) {
                        if (!RequestPanel.this._reverting) {
                            JOptionPane.showMessageDialog(RequestPanel.this, new String[]{"The URL requested is malformed", mue.getMessage()}, "Malformed URL", 0);
                            RequestPanel.this._reverting = true;
                            RequestPanel.this.displayTabbedPane.setSelectedIndex(RequestPanel.this._selected);
                            RequestPanel.this._reverting = false;
                        }
                    }
                    catch (ParseException pe) {
                        if (RequestPanel.this._reverting) break block5;
                        JOptionPane.showMessageDialog(RequestPanel.this, new String[]{"Error parsing request", pe.getMessage()}, "Malformed Request", 0);
                        RequestPanel.this._reverting = true;
                        RequestPanel.this.displayTabbedPane.setSelectedIndex(RequestPanel.this._selected);
                        RequestPanel.this._reverting = false;
                    }
                }
            }
        });
        this._messagePanel = new MessagePanel();
        this.parsedPanel.remove(this.messagePanelPlaceHolder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.parsedPanel.add((Component)this._messagePanel, gridBagConstraints);
        this._textPanel = new TextPanel();
        this.displayTabbedPane.add("Raw", this._textPanel);
        this._upToDate = new boolean[this.displayTabbedPane.getTabCount()];
        this.invalidatePanels();
        this.updateComponents(this._editable);
        if (_preferred > -1 && _preferred < this.displayTabbedPane.getTabCount()) {
            this.displayTabbedPane.setSelectedIndex(_preferred);
        }
    }

    private void invalidatePanels() {
        for (int i = 0; i < this._upToDate.length; ++i) {
            this._upToDate[i] = false;
        }
    }

    private void updateRequest(int panel) throws MalformedURLException, ParseException {
        if (!this._editable || panel < 0) {
            return;
        }
        if (this.displayTabbedPane.getTitleAt(panel).equals("Parsed")) {
            if (this._messagePanel.isModified()) {
                this._request = (Request)this._messagePanel.getMessage();
                this._modified = true;
            }
            if (this._request == null) {
                this._request = new Request();
            }
            this._request.setMethod(this.methodTextField.getText());
            String url = this.urlTextField.getText();
            if (!"".equals(url)) {
                this._request.setURL(new HttpUrl(url));
            }
            this._request.setVersion(this.versionTextField.getText());
            this._modified = true;
        } else if (this.displayTabbedPane.getTitleAt(panel).equals("Raw") && this._textPanel.isModified()) {
            Request r = new Request();
            String text = this._textPanel.getText();
            if (!"".equals(text)) {
                r.parse(this._textPanel.getText());
            }
            this._request = r;
            this._modified = true;
        }
        if (this._modified) {
            this.invalidatePanels();
        }
        this._upToDate[panel] = true;
    }

    public boolean isModified() {
        return this._modified;
    }

    private void updatePanel(int panel) {
        if (!this._upToDate[panel]) {
            if (this.displayTabbedPane.getTitleAt(panel).equals("Parsed")) {
                this._messagePanel.setMessage(this._request);
                if (this._request != null) {
                    this.methodTextField.setText(this._request.getMethod());
                    if (this._request.getURL() != null) {
                        this.urlTextField.setText(this._request.getURL().toString());
                    } else {
                        this.urlTextField.setText("");
                    }
                    this.versionTextField.setText(this._request.getVersion());
                } else {
                    this.methodTextField.setText("");
                    this.urlTextField.setText("");
                    this.versionTextField.setText("");
                }
            } else if (this.displayTabbedPane.getTitleAt(panel).equals("Raw")) {
                if (this._request != null && this._request.getMethod() != null && this._request.getURL() != null && this._request.getVersion() != null) {
                    this._textPanel.setText(null, this._request.toString("\n"));
                } else {
                    this._textPanel.setText(null, "");
                }
            }
            this._upToDate[panel] = true;
        }
    }

    private void updateComponents(boolean editable) {
        Color color = editable ? new Color(255, 255, 255) : new Color(204, 204, 204);
        this.methodTextField.setEditable(editable);
        this.urlTextField.setEditable(editable);
        this.versionTextField.setEditable(editable);
        this.methodTextField.setBackground(color);
        this.urlTextField.setBackground(color);
        this.versionTextField.setBackground(color);
        this.editButton.setVisible(editable);
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._textPanel.setEditable(editable);
        this.updateComponents(editable);
        this._messagePanel.setEditable(editable);
    }

    public void setRequest(Request request) {
        this._modified = false;
        this._request = request != null ? new Request(request) : null;
        this.invalidatePanels();
        if (SwingUtilities.isEventDispatchThread()) {
            this.updatePanel(this.displayTabbedPane.getSelectedIndex());
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    RequestPanel.this.updatePanel(RequestPanel.this.displayTabbedPane.getSelectedIndex());
                }
            });
        }
    }

    public Request getRequest() throws MalformedURLException, ParseException {
        if (this._editable) {
            int panel = this.displayTabbedPane.getSelectedIndex();
            this.updateRequest(panel);
        }
        return this._request;
    }

    public void selectPanel(String title) {
        for (int i = 0; i < this.displayTabbedPane.getTabCount(); ++i) {
            String tab = this.displayTabbedPane.getTitleAt(i);
            int selected = this.displayTabbedPane.getSelectedIndex();
            if (tab == null || !tab.equalsIgnoreCase(title) || i == selected) continue;
            this.displayTabbedPane.setSelectedIndex(i);
            return;
        }
    }

    private void initComponents() {
        this.editOptionsPopupMenu = new JPopupMenu();
        this.convertGetMenuItem = new JMenuItem();
        this.convertPostMenuItem = new JMenuItem();
        this.convertMultipartMenuItem = new JMenuItem();
        this.displayTabbedPane = new JTabbedPane();
        this.parsedPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.methodTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.urlTextField = new JTextField();
        this.messagePanelPlaceHolder = new JPanel();
        this.jLabel5 = new JLabel();
        this.versionTextField = new JTextField();
        this.editButton = new JButton();
        this.convertGetMenuItem.setText("Convert POST to GET");
        this.convertGetMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RequestPanel.this.convertGetMenuItemActionPerformed(evt);
            }
        });
        this.editOptionsPopupMenu.add(this.convertGetMenuItem);
        this.convertPostMenuItem.setText("Convert GET to POST");
        this.convertPostMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RequestPanel.this.convertPostMenuItemActionPerformed(evt);
            }
        });
        this.editOptionsPopupMenu.add(this.convertPostMenuItem);
        this.convertMultipartMenuItem.setText("Convert POST to Multipart");
        this.convertMultipartMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RequestPanel.this.convertMultipartMenuItemActionPerformed(evt);
            }
        });
        this.editOptionsPopupMenu.add(this.convertMultipartMenuItem);
        this.setLayout(new BorderLayout());
        this.parsedPanel.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.methodTextField);
        this.jLabel3.setText("Method");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.parsedPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.methodTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parsedPanel.add((Component)this.methodTextField, gridBagConstraints);
        this.jLabel4.setLabelFor(this.urlTextField);
        this.jLabel4.setText("URL");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.parsedPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.urlTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parsedPanel.add((Component)this.urlTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.parsedPanel.add((Component)this.messagePanelPlaceHolder, gridBagConstraints);
        this.jLabel5.setLabelFor(this.urlTextField);
        this.jLabel5.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.parsedPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.versionTextField.setBackground(new Color(204, 204, 204));
        this.versionTextField.setEditable(false);
        this.versionTextField.setText("HTTP/1.0");
        this.versionTextField.setMinimumSize(new Dimension(65, 19));
        this.versionTextField.setPreferredSize(new Dimension(65, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.parsedPanel.add((Component)this.versionTextField, gridBagConstraints);
        this.editButton.setText("Transform");
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RequestPanel.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        this.parsedPanel.add((Component)this.editButton, gridBagConstraints);
        this.displayTabbedPane.addTab("Parsed", this.parsedPanel);
        this.add((Component)this.displayTabbedPane, "Center");
    }

    private void convertGetMenuItemActionPerformed(ActionEvent evt) {
        try {
            Request req = this.getRequest();
            if (req == null) {
                return;
            }
            Request get = RequestConverter.convertPostToGet(req);
            this.setRequest(get);
            this._modified = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error", 0);
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.convertGetMenuItem.setEnabled(false);
        this.convertPostMenuItem.setEnabled(false);
        this.convertMultipartMenuItem.setEnabled(false);
        try {
            Request req = this.getRequest();
            if ("GET".equals(req.getMethod())) {
                this.convertPostMenuItem.setEnabled(true);
                this.convertMultipartMenuItem.setEnabled(true);
            } else if ("POST".equals(req.getMethod()) && "application/x-www-form-urlencoded".equals(req.getHeader("Content-Type"))) {
                this.convertGetMenuItem.setEnabled(true);
                this.convertMultipartMenuItem.setEnabled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editOptionsPopupMenu.setVisible(true);
        this.editOptionsPopupMenu.show(this.editButton, 0, this.editButton.getHeight());
    }

    private void convertPostMenuItemActionPerformed(ActionEvent evt) {
        try {
            Request req = this.getRequest();
            if (req == null) {
                return;
            }
            Request post = RequestConverter.convertGetToPost(req);
            this.setRequest(post);
            this._modified = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error", 0);
        }
    }

    private void convertMultipartMenuItemActionPerformed(ActionEvent evt) {
        try {
            Request req = this.getRequest();
            if (req == null) {
                return;
            }
            Request post = RequestConverter.convertPostToMultipart(req);
            this.setRequest(post);
            this._modified = true;
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Error", 0);
        }
    }

    public static void main(String[] args) {
        final RequestPanel panel = new RequestPanel();
        JFrame top = new JFrame(panel.getName());
        top.getContentPane().setLayout(new BorderLayout());
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        JButton button = new JButton("GET");
        top.getContentPane().add(panel);
        top.getContentPane().add((Component)button, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    System.out.println(panel.getRequest());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        top.pack();
        top.setVisible(true);
        Request request = new Request();
        try {
            FileInputStream fis = new FileInputStream("l2/conversations/1-request");
            request.read(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        panel.setEditable(true);
        panel.setRequest(request);
    }
}

