/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.owasp.webscarab.model.Message;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.ui.swing.ContentPanel;
import org.owasp.webscarab.ui.swing.HeaderPanel;

public class MessagePanel
extends JPanel {
    private static final long serialVersionUID = -295413596776666722L;
    private ContentPanel _cp;
    private HeaderPanel _hp;
    private Message _message = null;
    private boolean _editable = false;
    private JSplitPane messageSplitPane;

    public MessagePanel() {
        this.initComponents();
        this.setName("Message");
        this._hp = new HeaderPanel();
        this.messageSplitPane.setTopComponent(this._hp);
        this._cp = new ContentPanel();
        this.messageSplitPane.setBottomComponent(this._cp);
        String dividerLocation = Preferences.getPreference("MessagePanel.dividerLocation");
        if (dividerLocation != null) {
            try {
                this.messageSplitPane.setDividerLocation(Integer.parseInt(dividerLocation));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.messageSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("dividerLocation")) {
                    Preferences.setPreference("MessagePanel.dividerLocation", e.getNewValue().toString());
                }
            }
        });
        this.setEditable(false);
        this.setMessage(null);
    }

    public MessagePanel(int orientation) {
        this();
        this.messageSplitPane.setOrientation(orientation);
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._hp.setEditable(editable);
        this._cp.setEditable(editable);
    }

    public void setMessage(Message message) {
        this._message = message;
        if (message != null) {
            this._hp.setHeaders(this._message.getHeaders());
            byte[] content = message.getContent();
            this._cp.setContentType(message.getHeader("Content-Type"));
            this._cp.setContent(content);
        } else {
            this._hp.setHeaders(null);
            this._cp.setContentType(null);
            this._cp.setContent(null);
        }
        this.revalidate();
    }

    public Message getMessage() {
        if (this._editable) {
            if (this._hp.isModified() && this._message != null) {
                this._message.setHeaders(this._hp.getHeaders());
            }
            if (this._cp.isModified()) {
                this._message.setContent(this._cp.getContent());
                if (this._message.getHeader("Content-Length") != null) {
                    this._message.setHeader(new NamedValue("Content-Length", Integer.toString(this._message.getContent().length)));
                }
            }
        }
        return this._message;
    }

    public boolean isModified() {
        return this._editable && (this._hp.isModified() || this._cp.isModified());
    }

    private void initComponents() {
        this.messageSplitPane = new JSplitPane();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 200));
        this.messageSplitPane.setOrientation(0);
        this.messageSplitPane.setResizeWeight(0.3);
        this.messageSplitPane.setContinuousLayout(true);
        this.messageSplitPane.setDoubleBuffered(true);
        this.messageSplitPane.setOneTouchExpandable(true);
        this.add((Component)this.messageSplitPane, "Center");
    }
}

