/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.ui.swing.ColumnWidthTracker;

public class HeaderPanel
extends JPanel {
    private static final long serialVersionUID = 1597589394015618679L;
    private static final NamedValue[] NO_HEADERS = new NamedValue[0];
    private static final ColumnWidthTracker _cwt = ColumnWidthTracker.getTracker("Header");
    private boolean _editable = false;
    private boolean _modified = false;
    private HeaderTableModel _htm;
    private List _headers = new ArrayList();
    private JPanel buttonPanel;
    private JButton deleteButton;
    private JTable headerTable;
    private JButton insertButton;
    private JScrollPane jScrollPane1;

    public HeaderPanel() {
        this._htm = new HeaderTableModel();
        this.initComponents();
        this.headerTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        _cwt.addTable(this.headerTable);
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        if (editable) {
            this.add((Component)this.buttonPanel, "East");
            this.headerTable.setBackground(new Color(255, 255, 255));
        } else {
            this.remove(this.buttonPanel);
            this.headerTable.setBackground(new Color(204, 204, 204));
        }
    }

    public boolean isEditable() {
        return this._editable;
    }

    public boolean isModified() {
        if (this.headerTable.isEditing()) {
            this.headerTable.getCellEditor().stopCellEditing();
        }
        return this._modified;
    }

    public void setHeaders(NamedValue[] headers) {
        this._headers.clear();
        if (headers != null && headers.length > 0) {
            for (int i = 0; i < headers.length; ++i) {
                this._headers.add(headers[i]);
            }
        }
        this._modified = false;
        this._htm.fireTableDataChanged();
    }

    public NamedValue[] getHeaders() {
        this._modified = false;
        return this._headers.toArray(NO_HEADERS);
    }

    public void insertRow(int row) {
        this._headers.add(row, new NamedValue("Header", "value"));
        this._modified = true;
        this._htm.fireTableRowsInserted(row, row);
    }

    public void removeRow(int row) {
        this._headers.remove(row);
        this._modified = true;
        this._htm.fireTableRowsDeleted(row, row);
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.insertButton = new JButton();
        this.deleteButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.headerTable = new JTable();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.insertButton.setText("Insert");
        this.insertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeaderPanel.this.insertButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        this.buttonPanel.add((Component)this.insertButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HeaderPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.buttonPanel.add((Component)this.deleteButton, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(200, 50));
        this.jScrollPane1.setPreferredSize(new Dimension(453, 103));
        this.headerTable.setModel(this._htm);
        this.headerTable.setAutoResizeMode(0);
        this.headerTable.setCellSelectionEnabled(true);
        this.jScrollPane1.setViewportView(this.headerTable);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.headerTable.getSelectedRow();
        if (rowIndex > -1) {
            this.removeRow(rowIndex);
        }
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        int rowIndex = this.headerTable.getSelectedRow();
        if (rowIndex > -1) {
            this.insertRow(rowIndex);
        } else {
            this.insertRow(this._htm.getRowCount());
        }
    }

    private class HeaderTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4130873664468397110L;
        private String[] _names = new String[]{"Header", "Value"};

        private HeaderTableModel() {
        }

        public String getColumnName(int column) {
            return this._names[column];
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return HeaderPanel.this._headers.size();
        }

        public Object getValueAt(int row, int column) {
            if (row > HeaderPanel.this._headers.size() - 1) {
                return "ERROR";
            }
            NamedValue nv = (NamedValue)HeaderPanel.this._headers.get(row);
            if (column == 0) {
                return nv.getName();
            }
            return nv.getValue();
        }

        public void setValueAt(Object aValue, int row, int col) {
            if (HeaderPanel.this._editable && aValue instanceof String) {
                NamedValue nv = (NamedValue)HeaderPanel.this._headers.get(row);
                if (col == 0) {
                    HeaderPanel.this._headers.set(row, new NamedValue((String)aValue, nv.getValue()));
                } else {
                    HeaderPanel.this._headers.set(row, new NamedValue(nv.getName(), (String)aValue));
                }
                HeaderPanel.this._modified = true;
                this.fireTableCellUpdated(row, col);
            }
        }

        public boolean isCellEditable(int row, int column) {
            return HeaderPanel.this._editable;
        }
    }
}

