/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.owasp.webscarab.model.ConversationEvent;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationListener;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.ExtensibleTableModel;

public class ConversationTableModel
extends ExtensibleTableModel {
    private static final long serialVersionUID = 5188752872581098199L;
    protected ConversationModel _model = null;
    private Listener _listener = new Listener();
    protected Logger _logger = Logger.getLogger(this.getClass().getName());
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;

    public ConversationTableModel(ConversationModel model) {
        this._model = model;
        this.addStandardColumns();
        this._model.addConversationListener(this._listener);
    }

    private void addStandardColumns() {
        ColumnDataModel cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ConversationTableModel.this._model == null) {
                    return null;
                }
                return ConversationTableModel.this._model.getConversationDate((ConversationID)key);
            }

            public String getColumnName() {
                return "Date";
            }

            public Class getColumnClass() {
                return class$java$util$Date == null ? (class$java$util$Date = ConversationTableModel.class$("java.util.Date")) : class$java$util$Date;
            }
        };
        this.addColumn(cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ConversationTableModel.this._model == null) {
                    return null;
                }
                return ConversationTableModel.this._model.getRequestMethod((ConversationID)key);
            }

            public String getColumnName() {
                return "Method";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = ConversationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this.addColumn(cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ConversationTableModel.this._model == null) {
                    return null;
                }
                HttpUrl url = ConversationTableModel.this._model.getRequestUrl((ConversationID)key);
                return url.getScheme() + "://" + url.getHost() + ":" + url.getPort();
            }

            public String getColumnName() {
                return "Host";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = ConversationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this.addColumn(cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ConversationTableModel.this._model == null) {
                    return null;
                }
                HttpUrl url = ConversationTableModel.this._model.getRequestUrl((ConversationID)key);
                return url.getPath();
            }

            public String getColumnName() {
                return "Path";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = ConversationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this.addColumn(cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ConversationTableModel.this._model == null) {
                    return null;
                }
                HttpUrl url = ConversationTableModel.this._model.getRequestUrl((ConversationID)key);
                return url.getParameters();
            }

            public String getColumnName() {
                return "Parameters";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = ConversationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this.addColumn(cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ConversationTableModel.this._model == null) {
                    return null;
                }
                return ConversationTableModel.this._model.getResponseStatus((ConversationID)key);
            }

            public String getColumnName() {
                return "Status";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = ConversationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this.addColumn(cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ConversationTableModel.this._model == null) {
                    return null;
                }
                return ConversationTableModel.this._model.getConversationOrigin((ConversationID)key);
            }

            public String getColumnName() {
                return "Origin";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = ConversationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        };
        this.addColumn(cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ConversationTableModel.this._model == null) {
                    return null;
                }
                return ConversationTableModel.this._model.getConversationProperty((ConversationID)key, "TAG");
            }

            public String getColumnName() {
                return "Tag";
            }

            public Class getColumnClass() {
                return class$java$lang$String == null ? (class$java$lang$String = ConversationTableModel.class$("java.lang.String")) : class$java$lang$String;
            }

            public boolean isEditable(Object key) {
                return true;
            }

            public void setValue(Object aValue, Object key) {
                String value = aValue == null ? null : aValue.toString();
                ConversationTableModel.this._model.setConversationProperty((ConversationID)key, "TAG", value);
            }
        };
        this.addColumn(cdm);
    }

    public Object getKeyAt(int row) {
        return this._model.getConversationAt(row);
    }

    public int indexOfKey(Object key) {
        return this._model.getIndexOfConversation((ConversationID)key);
    }

    public int getRowCount() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getConversationCount();
    }

    public int getColumnCount() {
        return super.getColumnCount() + 1;
    }

    public Object getValueAt(int row, int column) {
        Object key = this.getKeyAt(row);
        if (column == 0) {
            return key;
        }
        return super.getValueAt(key, column - 1);
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "ID";
        }
        return super.getColumnName(column - 1);
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return ConversationID.class;
        }
        return super.getColumnClass(column - 1);
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        return super.isCellEditable(row, column - 1);
    }

    public void setValueAt(Object value, int row, int column) {
        if (column == 0) {
            return;
        }
        super.setValueAt(value, row, column - 1);
    }

    protected void addedConversation(ConversationEvent evt) {
        ConversationID id = evt.getConversationID();
        int row = this.indexOfKey(id);
        this.fireTableRowsInserted(row, row);
    }

    protected void removedConversation(ConversationEvent evt) {
        this.fireTableDataChanged();
    }

    protected void changedConversations() {
        this.fireTableDataChanged();
    }

    private class Listener
    implements ConversationListener {
        private Listener() {
        }

        public void conversationAdded(final ConversationEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                ConversationTableModel.this.addedConversation(evt);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConversationTableModel.this.addedConversation(evt);
                        }
                    });
                }
                catch (Exception e) {
                    ConversationTableModel.this._logger.warning("Exception processing " + evt + ": " + e);
                }
            }
        }

        public void conversationChanged(ConversationEvent evt) {
        }

        public void conversationRemoved(final ConversationEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                ConversationTableModel.this.removedConversation(evt);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConversationTableModel.this.removedConversation(evt);
                        }
                    });
                }
                catch (Exception e) {
                    ConversationTableModel.this._logger.warning("Exception processing " + evt + ": " + e);
                }
            }
        }

        public void conversationsChanged() {
            if (SwingUtilities.isEventDispatchThread()) {
                ConversationTableModel.this.changedConversations();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConversationTableModel.this.changedConversations();
                        }
                    });
                }
                catch (Exception e) {
                    ConversationTableModel.this._logger.warning("Exception: " + e);
                }
            }
        }
    }
}

