/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;
import org.owasp.webscarab.model.ConversationEvent;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationListener;
import org.owasp.webscarab.model.ConversationModel;

public class ConversationListModel
extends AbstractListModel {
    private static final long serialVersionUID = 5429247298419259534L;
    private ConversationModel _model = null;
    private Listener _listener = new Listener();
    private int _size = 0;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public ConversationListModel(ConversationModel model) {
        this._model = model;
        this._model.addConversationListener(this._listener);
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public Object getElementAt(int index) {
        return this.getConversationAt(index);
    }

    public int getIndexOfConversation(ConversationID id) {
        return this._model.getIndexOfConversation(id);
    }

    public int getConversationCount() {
        return this._model.getConversationCount();
    }

    public ConversationID getConversationAt(int index) {
        return this._model.getConversationAt(index);
    }

    public int getSize() {
        if (this._model == null) {
            return 0;
        }
        this._size = this.getConversationCount();
        return this._size;
    }

    protected void addedConversation(ConversationEvent evt) {
        ConversationID id = evt.getConversationID();
        int row = this.getIndexOfConversation(id);
        if (row > -1) {
            this.fireIntervalAdded(this, row, row);
        }
    }

    protected void changedConversation(ConversationEvent evt) {
        ConversationID id = evt.getConversationID();
        int row = this.getIndexOfConversation(id);
        if (row > -1) {
            this.fireContentsChanged(this, row, row);
        }
    }

    protected void removedConversation(ConversationEvent evt) {
        ConversationID id = evt.getConversationID();
        int row = this.getIndexOfConversation(id);
        if (row > -1) {
            this.fireIntervalRemoved(this, row, row);
        }
    }

    protected void conversationsChanged() {
        if (this._size > 0) {
            this.fireIntervalRemoved(this, 0, this._size);
        }
        this.fireIntervalAdded(this, 0, this.getSize());
    }

    private class Listener
    implements ConversationListener {
        private Listener() {
        }

        public void conversationAdded(final ConversationEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                ConversationListModel.this.addedConversation(evt);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConversationListModel.this.addedConversation(evt);
                        }
                    });
                }
                catch (Exception e) {
                    ConversationListModel.this._logger.warning("Exception! " + e);
                }
            }
        }

        public void conversationChanged(final ConversationEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                ConversationListModel.this.changedConversation(evt);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConversationListModel.this.changedConversation(evt);
                        }
                    });
                }
                catch (Exception e) {
                    ConversationListModel.this._logger.warning("Exception! " + e + " : " + e.getStackTrace()[0]);
                }
            }
        }

        public void conversationRemoved(final ConversationEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                ConversationListModel.this.removedConversation(evt);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConversationListModel.this.removedConversation(evt);
                        }
                    });
                }
                catch (Exception e) {
                    ConversationListModel.this._logger.warning("Exception! " + e);
                }
            }
        }

        public void conversationsChanged() {
            if (SwingUtilities.isEventDispatchThread()) {
                ConversationListModel.this.conversationsChanged();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ConversationListModel.this.conversationsChanged();
                        }
                    });
                }
                catch (Exception e) {
                    ConversationListModel.this._logger.warning("Exception! " + e + " : " + e.getStackTrace()[0]);
                    e.printStackTrace();
                }
            }
        }
    }
}

