/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;
import org.owasp.webscarab.ui.swing.editors.EditorFactory;

public class ContentPanel
extends JPanel {
    private static final long serialVersionUID = -8219184959231369179L;
    private String _contentType = null;
    private boolean _editable = false;
    private boolean _modified = false;
    private byte[] _data = null;
    private ByteArrayEditor[] _editors = null;
    private int _selected = -1;
    private boolean[] _upToDate = new boolean[]{false};
    private static List _preferred = new ArrayList();
    private boolean _creatingPanels = false;
    private JTabbedPane viewTabbedPane;

    public ContentPanel() {
        this.initComponents();
        this.viewTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ContentPanel.this._creatingPanels) {
                    return;
                }
                ContentPanel.this.updateData(ContentPanel.this._selected);
                ContentPanel.this._selected = ContentPanel.this.viewTabbedPane.getSelectedIndex();
                if (ContentPanel.this._selected > -1) {
                    ContentPanel.this.updatePanel(ContentPanel.this._selected);
                    String name = ContentPanel.this._editors[ContentPanel.this._selected].getName();
                    _preferred.remove(name);
                    _preferred.add(name);
                }
            }
        });
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        if (this._editors != null) {
            for (int i = 0; i < this._editors.length; ++i) {
                this._editors[i].setEditable(editable);
            }
        }
    }

    public void setContentType(String contentType) {
        if (this._contentType == null || !this._contentType.equals(contentType)) {
            this._contentType = contentType;
            this.createPanels(this._contentType);
        }
    }

    private void createPanels(final String contentType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ContentPanel.this.createPanels(contentType);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this._creatingPanels = true;
            this.viewTabbedPane.removeAll();
            this._editors = EditorFactory.getEditors(contentType);
            for (int i = 0; i < this._editors.length; ++i) {
                this._editors[i].setEditable(this._editable);
                this.viewTabbedPane.add((Component)((Object)this._editors[i]));
            }
            int preferred = -1;
            block3: for (int i = 0; i < _preferred.size(); ++i) {
                for (int e = 0; e < this._editors.length; ++e) {
                    if (!this._editors[e].getName().equals(_preferred.get(i))) continue;
                    preferred = e;
                    continue block3;
                }
            }
            this.invalidateEditors();
            this.revalidate();
            if (preferred > -1) {
                this.viewTabbedPane.setSelectedIndex(preferred);
            }
            this._creatingPanels = false;
        }
    }

    private void invalidateEditors() {
        this._upToDate = new boolean[this._editors.length];
        for (int i = 0; i < this._upToDate.length; ++i) {
            this._upToDate[i] = false;
        }
    }

    public void setContent(byte[] content) {
        this._modified = false;
        if (content == null) {
            this._data = null;
        } else {
            this._data = new byte[content.length];
            System.arraycopy(content, 0, this._data, 0, content.length);
        }
        if (this._editors == null || this._editors.length == 0) {
            return;
        }
        this.invalidateEditors();
        this._selected = this.viewTabbedPane.getSelectedIndex();
        if (this._selected < 0) {
            this._selected = 0;
            this.viewTabbedPane.setSelectedIndex(this._selected);
        }
        this.updatePanel(this._selected);
    }

    public boolean isModified() {
        if (!this._editable) {
            return false;
        }
        int selected = this.viewTabbedPane.getSelectedIndex();
        if (selected < 0) {
            return false;
        }
        return this._modified || this._editors[selected].isModified();
    }

    public byte[] getContent() {
        if (this.isModified()) {
            int selected = this.viewTabbedPane.getSelectedIndex();
            this._data = this._editors[selected].getBytes();
            this._modified = false;
        }
        return this._data;
    }

    private void updatePanel(int panel) {
        if (panel < 0 || this._upToDate.length == 0) {
            return;
        }
        if (panel >= this._upToDate.length) {
            panel = 0;
        }
        if (!this._upToDate[panel]) {
            this._editors[panel].setBytes(this._contentType, this._data);
            this._upToDate[panel] = true;
        }
    }

    private void updateData(int panel) {
        ByteArrayEditor ed;
        if (this._editable && panel >= 0 && (ed = (ByteArrayEditor)((Object)this.viewTabbedPane.getComponentAt(panel))).isModified()) {
            this._modified = true;
            this._data = ed.getBytes();
            this.invalidateEditors();
            this._upToDate[panel] = true;
        }
    }

    private void initComponents() {
        this.viewTabbedPane = new JTabbedPane();
        this.setLayout(new GridBagLayout());
        this.viewTabbedPane.setPreferredSize(new Dimension(300, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.viewTabbedPane, gridBagConstraints);
    }

    public static void main(String[] args) {
        Response response = new Response();
        try {
            String filename = "/home/rogan/workspace/webscarab/test/data/index-resp";
            if (args.length == 1) {
                filename = args[0];
            }
            FileInputStream fis = new FileInputStream(filename);
            response.read(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        JFrame top = new JFrame("Content Pane");
        top.getContentPane().setLayout(new BorderLayout());
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        JButton button = new JButton("GET");
        final ContentPanel cp = new ContentPanel();
        top.getContentPane().add(cp);
        top.getContentPane().add((Component)button, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                System.out.println(new String(cp.getContent()));
            }
        });
        top.pack();
        top.setVisible(true);
        try {
            cp.setContentType(response.getHeader("Content-Type"));
            cp.setEditable(false);
            cp.setContent(response.getContent());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

