/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.spider;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.FilteredUrlModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.plugin.AbstractPluginModel;
import org.owasp.webscarab.plugin.spider.Link;

public class SpiderModel
extends AbstractPluginModel {
    private FrameworkModel _model;
    private SpiderUrlModel _urlModel;
    private List _linkQueue = new LinkedList();
    private String _allowedDomains = null;
    private String _forbiddenPaths = null;
    private boolean _recursive = false;
    private boolean _cookieSync = false;
    private NamedValue[] _extraHeaders = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public SpiderModel(FrameworkModel model) {
        this._model = model;
        this._urlModel = new SpiderUrlModel(this._model.getUrlModel());
        this.parseProperties();
    }

    public UrlModel getUrlModel() {
        return this._urlModel;
    }

    public boolean isUnseen(HttpUrl url) {
        return this._model.getUrlProperty(url, "METHODS") == null;
    }

    public boolean isForbidden(HttpUrl url) {
        if (this._forbiddenPaths != null && !this._forbiddenPaths.equals("")) {
            try {
                return url.toString().matches(this.getForbiddenPaths());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void addUnseenLink(HttpUrl url, HttpUrl referer) {
        String first;
        if (url == null) {
            return;
        }
        if (this.isUnseen(url) && ((first = this._model.getUrlProperty(url, "REFERER")) == null || first.equals(""))) {
            this._model.setUrlProperty(url, "REFERER", referer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueLink(Link link) {
        try {
            this._model.readLock().acquire();
            this._linkQueue.add(link);
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted waiting for the read lock! " + ie.getMessage());
        }
        finally {
            this._model.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Link dequeueLink() {
        Link link = null;
        try {
            this._model.readLock().acquire();
            if (this._linkQueue.size() > 0) {
                link = (Link)this._linkQueue.remove(0);
            }
            if (this._linkQueue.size() == 0) {
                this.setStatus("Idle");
            } else {
                this.setStatus(this._linkQueue.size() + " links remaining");
            }
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted waiting for the read lock! " + ie.getMessage());
        }
        finally {
            this._model.readLock().release();
        }
        return link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLinkQueue() {
        try {
            this._model.readLock().acquire();
            this._linkQueue.clear();
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted waiting for the read lock! " + ie.getMessage());
        }
        finally {
            this._model.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuedLinkCount() {
        try {
            this._model.readLock().acquire();
            int n = this._linkQueue.size();
            return n;
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted waiting for the read lock! " + ie.getMessage());
        }
        finally {
            this._model.readLock().release();
        }
        return 0;
    }

    public Cookie[] getCookiesForUrl(HttpUrl url) {
        return this._model.getCookiesForUrl(url);
    }

    public void addCookie(Cookie cookie) {
        this._model.addCookie(cookie);
    }

    public void parseProperties() {
        String prop = "Spider.domains";
        String value = Preferences.getPreference(prop, ".*localhost.*");
        this.setAllowedDomains(value);
        prop = "Spider.excludePaths";
        value = Preferences.getPreference(prop, "");
        this.setForbiddenPaths(value);
        prop = "Spider.synchroniseCookies";
        value = Preferences.getPreference(prop, "true");
        this.setCookieSync(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
        prop = "Spider.recursive";
        value = Preferences.getPreference(prop, "false");
        this.setRecursive(value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    public String getReferer(HttpUrl url) {
        return this._model.getUrlProperty(url, "REFERER");
    }

    public void setExtraHeaders(NamedValue[] headers) {
        this._extraHeaders = headers;
    }

    public NamedValue[] getExtraHeaders() {
        return this._extraHeaders;
    }

    public void setRecursive(boolean bool) {
        this._recursive = bool;
        String prop = "Spider.recursive";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean getRecursive() {
        return this._recursive;
    }

    public void setCookieSync(boolean enabled) {
        this._cookieSync = enabled;
        String prop = "Spider.synchroniseCookies";
        Preferences.setPreference(prop, Boolean.toString(enabled));
    }

    public boolean getCookieSync() {
        return this._cookieSync;
    }

    public void setAllowedDomains(String regex) {
        this._allowedDomains = regex;
        String prop = "Spider.domains";
        Preferences.setPreference(prop, regex);
    }

    public String getAllowedDomains() {
        return this._allowedDomains;
    }

    public void setForbiddenPaths(String regex) {
        this._forbiddenPaths = regex;
        String prop = "Spider.excludePaths";
        Preferences.setPreference(prop, regex);
        this._urlModel.reset();
    }

    public String getForbiddenPaths() {
        return this._forbiddenPaths;
    }

    public void setAuthRequired(HttpUrl url) {
        this._model.setUrlProperty(url, "AUTHREQUIRED", Boolean.toString(true));
    }

    private class SpiderUrlModel
    extends FilteredUrlModel {
        public SpiderUrlModel(UrlModel model) {
            super(model);
        }

        public boolean shouldFilter(HttpUrl url) {
            return !SpiderModel.this.isUnseen(url) || SpiderModel.this.isForbidden(url);
        }
    }
}

