/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.spider;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.Tag;
import org.htmlparser.filters.HasAttributeFilter;
import org.htmlparser.filters.OrFilter;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.owasp.webscarab.httpclient.ConversationHandler;
import org.owasp.webscarab.httpclient.FetcherQueue;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.parser.Parser;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.spider.Link;
import org.owasp.webscarab.plugin.spider.SpiderModel;

public class Spider
implements Plugin,
ConversationHandler {
    private SpiderModel _model = null;
    private Framework _framework = null;
    private FetcherQueue _fetcherQueue = null;
    private int _threads = 4;
    private Thread _runThread = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public Spider(Framework framework) {
        this._framework = framework;
        this._model = new SpiderModel(this._framework.getModel());
        this._fetcherQueue = new FetcherQueue("Spider", this, 4, 0);
    }

    public SpiderModel getModel() {
        return this._model;
    }

    public String getPluginName() {
        return new String("Spider");
    }

    public void run() {
        this._model.setStatus("Started");
        this._model.setStopping(false);
        this._runThread = Thread.currentThread();
        this._model.setRunning(true);
        while (!this._model.isStopping()) {
            if (!this.queueRequests()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            Thread.yield();
        }
        this._fetcherQueue.clearRequestQueue();
        this._model.setRunning(false);
        this._runThread = null;
        this._model.setStatus("Stopped");
    }

    private boolean queueRequests() {
        if (this._model.getQueuedLinkCount() == 0) {
            return false;
        }
        if (this._fetcherQueue.getRequestsQueued() > this._threads) {
            return false;
        }
        while (this._model.getQueuedLinkCount() > 0 && this._fetcherQueue.getRequestsQueued() <= this._threads) {
            Cookie[] cookies;
            Link link = this._model.dequeueLink();
            if (link == null) {
                this._logger.warning("Got a null link from the link queue");
                return false;
            }
            Request request = this.newGetRequest(link);
            if (this._model.getCookieSync() && (cookies = this._model.getCookiesForUrl(request.getURL())).length > 0) {
                StringBuffer buff = new StringBuffer();
                buff.append(cookies[0].getName()).append("=").append(cookies[0].getValue());
                for (int i = 1; i < cookies.length; ++i) {
                    buff.append("; ").append(cookies[i].getName()).append("=").append(cookies[i].getValue());
                }
                request.setHeader("Cookie", buff.toString());
            }
            this._fetcherQueue.submit(request);
        }
        return true;
    }

    public void responseReceived(Response response) {
        Request request = response.getRequest();
        if (request == null) {
            this._logger.warning("Got a null request from the response!");
            return;
        }
        if (response.getStatus().startsWith("401")) {
            this._logger.info("Invalid credentials or authentication required for " + request.getURL());
            this._model.setAuthRequired(request.getURL());
            return;
        }
        this._framework.addConversation(request, response, "Spider");
        if (this._model.getCookieSync()) {
            NamedValue[] headers = response.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                if (!headers[i].getName().equalsIgnoreCase("Set-Cookie") && !headers[i].getName().equalsIgnoreCase("Set-Cookie2")) continue;
                Cookie cookie = new Cookie(new Date(), request.getURL(), headers[i].getValue());
                this._model.addCookie(cookie);
            }
        }
    }

    public void requestError(Request request, IOException ioe) {
        this._logger.info("Requested " + request.getURL() + " got IOException " + ioe.getMessage());
    }

    public boolean isBusy() {
        if (!this._model.isRunning()) {
            return false;
        }
        return this._model.getQueuedLinkCount() > 0;
    }

    private boolean allowedURL(HttpUrl url) {
        return this.isAllowedDomain(url) && !this._model.isForbidden(url);
    }

    private boolean isAllowedDomain(HttpUrl url) {
        String allowedDomains = this._model.getAllowedDomains();
        try {
            return allowedDomains != null && !allowedDomains.equals("") && url.getHost().matches(allowedDomains);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void requestLinksUnder(HttpUrl url) {
        LinkedList links = new LinkedList();
        this.queueLinksUnder(url, links, 50);
        while (links.size() > 0) {
            this._model.queueLink((Link)links.remove(0));
        }
    }

    private void queueLinksUnder(HttpUrl url, List links, int max) {
        if (this._model.isUnseen(url)) {
            if (!this._model.isForbidden(url) && !url.toString().matches(this._framework.getDropPattern())) {
                String referer = this._model.getReferer(url);
                links.add(new Link(url, referer));
            } else {
                this._logger.warning("Skipping forbidden path " + url);
            }
        }
        if (links.size() == max) {
            return;
        }
        UrlModel urlModel = this._model.getUrlModel();
        int count = urlModel.getChildCount(url);
        for (int i = 0; i < count; ++i) {
            HttpUrl child = urlModel.getChildAt(url, i);
            this.queueLinksUnder(child, links, max);
            if (links.size() != max) continue;
            return;
        }
    }

    public void requestLinks(HttpUrl[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            String referer = this._model.getReferer(urls[i]);
            Link link = new Link(urls[i], referer);
            this._model.queueLink(link);
        }
    }

    public void clearQueue() {
        this._model.clearLinkQueue();
    }

    private Request newGetRequest(Link link) {
        NamedValue[] headers;
        HttpUrl url = link.getURL();
        String referer = link.getReferer();
        Request req = new Request();
        req.setMethod("GET");
        req.setURL(url);
        req.setVersion("HTTP/1.0");
        if (referer != null) {
            req.setHeader("Referer", referer);
        }
        req.setHeader("Host", url.getHost() + ":" + url.getPort());
        if (req.getVersion().equals("HTTP/1.0")) {
            req.setHeader("Connection", "Keep-Alive");
        }
        if ((headers = this._model.getExtraHeaders()) != null && headers.length > 0) {
            for (int i = 0; i < headers.length; ++i) {
                if (headers[i] == null) continue;
                req.addHeader(headers[i]);
            }
        }
        return req;
    }

    public void setExtraHeaders(NamedValue[] headers) {
        this._model.setExtraHeaders(headers);
    }

    public NamedValue[] getExtraHeaders() {
        return this._model.getExtraHeaders();
    }

    public void flush() throws StoreException {
    }

    public boolean stop() {
        if (this.isBusy()) {
            return false;
        }
        this._model.setStopping(true);
        try {
            this._runThread.join(5000L);
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted stopping " + this.getPluginName());
        }
        return !this._model.isRunning();
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
        HttpUrl base = request.getURL();
        if (response.getStatus().equals("302")) {
            String location = response.getHeader("Location");
            if (location != null) {
                try {
                    HttpUrl url = new HttpUrl(base, location);
                    this._model.addUnseenLink(url, base);
                }
                catch (MalformedURLException mue) {
                    this._logger.warning("Badly formed Location header : " + location);
                }
            } else {
                this._logger.warning("302 received, but no Location header!");
            }
            return;
        }
        Object parsed = Parser.parse(base, response);
        if (parsed != null && parsed instanceof NodeList) {
            NodeList nodelist = (NodeList)parsed;
            this.processHtml(base, nodelist);
        }
    }

    private void processHtml(HttpUrl base, NodeList nodelist) {
        NodeFilter filter = new HasAttributeFilter("href");
        filter = new OrFilter(filter, new HasAttributeFilter("src"));
        filter = new OrFilter(filter, new HasAttributeFilter("onclick"));
        filter = new OrFilter(filter, new HasAttributeFilter("onblur"));
        try {
            NodeList links = nodelist.extractAllNodesThatMatch(filter);
            SimpleNodeIterator ni = links.elements();
            while (ni.hasMoreNodes()) {
                String href;
                Node node = ni.nextNode();
                if (!(node instanceof Tag)) continue;
                boolean got = false;
                Tag tag = (Tag)node;
                String src = tag.getAttribute("src");
                if (src != null) {
                    this.processLink(base, src);
                    got = true;
                }
                if ((href = tag.getAttribute("href")) != null) {
                    this.processLink(base, href);
                    got = true;
                }
                if (got) continue;
            }
        }
        catch (ParserException pe) {
            this._logger.warning("ParserException : " + pe);
        }
    }

    private void processLink(HttpUrl base, String link) {
        if (link.startsWith("http://") || link.startsWith("https://")) {
            try {
                HttpUrl url = new HttpUrl(link);
                this._model.addUnseenLink(url, base);
            }
            catch (MalformedURLException mue) {
                this._logger.warning("Malformed link : " + link);
            }
        } else if (!link.toLowerCase().startsWith("mailto:")) {
            if (link.toLowerCase().startsWith("javascript:")) {
                this.processScript(base, link.substring(10));
            } else if (link.matches("^[a-zA-Z]+://.*")) {
                this._logger.info("Encountered an unhandled url scheme " + link);
            } else {
                this._logger.fine("Creating a new relative URL with " + base + " and " + link + " '");
                try {
                    HttpUrl url = new HttpUrl(base, link);
                    this._model.addUnseenLink(url, base);
                }
                catch (MalformedURLException mue) {
                    this._logger.warning("Bad relative URL (" + base.toString() + ") : " + link);
                }
            }
        }
    }

    private void processScript(HttpUrl base, String script) {
        if (script.startsWith("window.open(")) {
            this._logger.info("Script opens a window : " + script);
        } else if (script.startsWith("location.href")) {
            this._logger.info("Script sets location : " + script);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    public void setSession(String type, Object store, String session) throws StoreException {
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }
}

