/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.sessionid;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.webscarab.httpclient.ConversationHandler;
import org.owasp.webscarab.httpclient.FetcherQueue;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.sessionid.Calculator;
import org.owasp.webscarab.plugin.sessionid.FileSystemStore;
import org.owasp.webscarab.plugin.sessionid.SessionID;
import org.owasp.webscarab.plugin.sessionid.SessionIDModel;

public class SessionIDAnalysis
implements Plugin,
ConversationHandler {
    private SessionIDModel _model;
    private FetcherQueue _fetcherQueue;
    private int _threads = 4;
    private String _name = null;
    private String _regex = null;
    private int _count = 0;
    private Request _request = null;
    private Response _response = null;
    private Thread _runThread = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public SessionIDAnalysis(Framework framework) {
        this._model = new SessionIDModel(framework.getModel());
        this._fetcherQueue = new FetcherQueue("SessionID", this, this._threads, 100);
    }

    public SessionIDModel getModel() {
        return this._model;
    }

    public void setSession(String type, Object store, String session) throws StoreException {
        if (!type.equals("FileSystem") || !(store instanceof File)) {
            throw new StoreException("Store type '" + type + "' is not supported in " + this.getClass().getName());
        }
        this._model.setStore(new FileSystemStore((File)store));
    }

    public String getPluginName() {
        return new String("Session ID Analysis");
    }

    public void run() {
        this._model.setStatus("Started");
        this._model.setRunning(true);
        this._runThread = Thread.currentThread();
        this._model.setStopping(false);
        while (!this._model.isStopping()) {
            while (this._request != null && this._count > 0 && this._fetcherQueue.getRequestsQueued() < this._threads) {
                this._fetcherQueue.submit(this._request);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._request = null;
        this._fetcherQueue.clearRequestQueue();
        this._model.setRunning(false);
        this._model.setStatus("Stopped");
    }

    public void requestError(Request request, IOException ioe) {
        this._logger.info("Requested " + request.getURL() + " got IOException " + ioe.getMessage());
    }

    public void responseReceived(Response response) {
        if (this._count == 0) {
            return;
        }
        --this._count;
        Map ids = this.getIDsFromResponse(response, this._name, this._regex);
        Iterator it = ids.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            SessionID id = (SessionID)ids.get(key);
            this._model.addSessionID(key, id);
        }
    }

    public Map getIDsFromResponse(Response response, String name, String regex) {
        TreeMap<String, SessionID> ids;
        block10: {
            NamedValue[] headers;
            Date date;
            HttpUrl url;
            block9: {
                String type;
                Pattern pattern;
                Matcher matcher;
                ids = new TreeMap<String, SessionID>();
                Request request = response.getRequest();
                if (request == null) {
                    System.out.println("Request was null?");
                    return ids;
                }
                url = request.getURL();
                date = new Date();
                headers = response.getHeaders();
                if (name == null || name.equals("") || regex == null) break block9;
                String location = response.getHeader("Location");
                if (location != null && (matcher = (pattern = Pattern.compile(regex)).matcher(location)).matches() && matcher.groupCount() > 0) {
                    for (int j = 1; j <= matcher.groupCount(); ++j) {
                        SessionID id = new SessionID(date, matcher.group(j));
                        ids.put(name + " " + j, id);
                    }
                }
                if ((type = response.getHeader("Content-Type")) == null || !type.startsWith("text/")) break block10;
                String charset = "UTF-8";
                String body = null;
                try {
                    body = new String(response.getContent(), charset);
                }
                catch (UnsupportedEncodingException uee) {
                    body = new String(response.getContent());
                }
                Pattern pattern2 = Pattern.compile(regex, 40);
                Matcher matcher2 = pattern2.matcher(body);
                if (!matcher2.matches() || matcher2.groupCount() <= 0) break block10;
                for (int j = 1; j <= matcher2.groupCount(); ++j) {
                    SessionID id = new SessionID(date, matcher2.group(j));
                    ids.put(name + " " + j, id);
                }
                break block10;
            }
            Pattern pattern = Pattern.compile("(.*)");
            if (regex != null && !regex.equals("")) {
                pattern = Pattern.compile(regex);
            }
            for (int i = 0; i < headers.length; ++i) {
                if (!headers[i].getName().equalsIgnoreCase("Set-Cookie") && !headers[i].getName().equalsIgnoreCase("Set-Cookie2")) continue;
                Cookie cookie = new Cookie(date, url, headers[i].getValue());
                Matcher matcher = pattern.matcher(cookie.getValue());
                name = cookie.getKey();
                if (!matcher.matches()) continue;
                SessionID id = new SessionID(date, matcher.group(0));
                ids.put(name, id);
                if (matcher.groupCount() <= 0) continue;
                for (int j = 1; j <= matcher.groupCount(); ++j) {
                    if (matcher.group(j).equals(matcher.group(0))) continue;
                    id = new SessionID(date, matcher.group(j));
                    ids.put(name + " " + j, id);
                }
            }
        }
        return ids;
    }

    public void fetch(Request request, String name, String regex, int count) {
        Pattern.compile(regex);
        this._request = request;
        this._name = name;
        this._regex = regex;
        this._count = count;
    }

    public void setRequest(Request request) {
        this._request = request;
    }

    public void fetchResponse() throws IOException {
        this._response = HTTPClientFactory.getInstance().fetchResponse(this._request);
    }

    public Response getResponse() {
        return this._response;
    }

    public void setCalculator(String key, Calculator calc) {
        this._model.setCalculator(key, calc);
    }

    public boolean stop() {
        this._model.setStopping(true);
        try {
            this._runThread.join(5000L);
        }
        catch (InterruptedException ie) {
            this._logger.warning("Interrupted!");
        }
        return !this._model.isRunning();
    }

    public void flush() throws StoreException {
        this._model.flush();
    }

    public boolean isBusy() {
        return this._count > 0;
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public boolean isModified() {
        return this._model.isModified();
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
        String[] setCookie;
        HttpUrl url = request.getURL();
        String cookie = request.getHeader("Cookie");
        if (cookie != null) {
            this._model.addRequestCookie(id, cookie);
        }
        if ((setCookie = response.getHeaders("Set-Cookie")) != null) {
            for (int i = 0; i < setCookie.length; ++i) {
                Cookie c = new Cookie(new Date(), setCookie[i]);
                this._model.addResponseCookie(id, url, c);
            }
        }
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }

    public void clearSessionIDs(String key) {
        this._model.clearSessionIDs(key);
    }

    public void exportIDSToCSV(String key, File file) throws IOException {
        int count = this._model.getSessionIDCount(key);
        if (count == 0) {
            return;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            SessionID id = this._model.getSessionIDAt(key, i);
            buff.append(id.getDate().getTime());
            buff.append(",").append(this._model.getSessionIDValue(key, id));
            buff.append(",").append(id.getValue()).append("\n");
            bw.write(buff.toString().toCharArray());
            buff.delete(0, buff.length());
        }
        bw.close();
    }
}

