/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.search;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.util.logging.Logger;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.FrameworkModelWrapper;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.search.SearchModel;

public class Search
implements Plugin {
    private Framework _framework;
    private FrameworkModel _frameworkModel;
    private FrameworkModelWrapper _wrapper;
    private Interpreter _interpreter = new Interpreter();
    private SearchModel _model;
    private Thread _runThread;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public Search(Framework framework) {
        this._framework = framework;
        this._frameworkModel = this._framework.getModel();
        this._wrapper = new FrameworkModelWrapper(this._frameworkModel);
        this._model = new SearchModel(this._frameworkModel);
        this.loadSearches();
    }

    public SearchModel getModel() {
        return this._model;
    }

    private void loadSearches() {
        String description;
        String base = "Search.";
        int i = 0;
        do {
            description = Preferences.getPreference(base + i + ".description");
            String expression = Preferences.getPreference(base + i + ".expression");
            if (description != null && expression != null) {
                this._model.addSearch(description, expression);
            }
            ++i;
        } while (description != null);
    }

    private void saveSearches() {
        String base = "Search.";
        String[] searches = this._model.getSearches();
        for (int i = 0; i < searches.length; ++i) {
            String expression = this._model.getSearchExpression(searches[i]);
            Preferences.setPreference(base + i + ".description", searches[i]);
            Preferences.setPreference(base + i + ".expression", expression);
        }
        Preferences.remove(base + searches.length + ".description");
        Preferences.remove(base + searches.length + ".expression");
    }

    public void addSearch(String description, String expression) {
        this._model.addSearch(description, expression);
        this.saveSearches();
    }

    public void removeSearch(String description) {
        this._model.removeSearch(description);
        ConversationModel cmodel = this._frameworkModel.getConversationModel();
        int count = cmodel.getConversationCount();
        for (int i = 0; i < count; ++i) {
            ConversationID id = cmodel.getConversationAt(i);
            this._model.setSearchMatch(id, description, false);
        }
        this.saveSearches();
    }

    public void setFilter(String description) {
        this._model.setFilter(description);
    }

    public void reload(String description) {
        ConversationID id = null;
        try {
            String expr = this._model.getSearchExpression(description);
            ConversationModel cmodel = this._frameworkModel.getConversationModel();
            int count = cmodel.getConversationCount();
            for (int i = 0; i < count; ++i) {
                id = cmodel.getConversationAt(i);
                Request request = cmodel.getRequest(id);
                Response response = cmodel.getResponse(id);
                String origin = cmodel.getConversationOrigin(id);
                boolean matches = this.matches(id, request, response, origin, expr);
                this._model.setSearchMatch(id, description, matches);
            }
        }
        catch (Exception e) {
            this._logger.warning("Evaluation error for conversation " + id + " : " + e.getMessage());
        }
    }

    private boolean matches(ConversationID id, Request request, Response response, String origin, String expression) throws EvalError {
        this._interpreter.set("model", this._wrapper);
        this._interpreter.set("id", id);
        this._interpreter.set("request", request);
        this._interpreter.set("response", response);
        this._interpreter.set("origin", origin);
        Object result = this._interpreter.eval(expression);
        if (result != null && result instanceof Boolean) {
            boolean b = (Boolean)result;
            return b;
        }
        this._logger.info("Got a " + result);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyse(ConversationID id, Request request, Response response, String origin) {
        try {
            this._model.readLock().acquire();
            Interpreter interpreter = this._interpreter;
            synchronized (interpreter) {
                String[] searches = this._model.getSearches();
                for (int i = 0; i < searches.length; ++i) {
                    try {
                        String expression = this._model.getSearchExpression(searches[i]);
                        boolean matches = this.matches(id, request, response, origin, expression);
                        if (!matches) continue;
                        this._model.setSearchMatch(id, searches[i], true);
                        continue;
                    }
                    catch (TargetError te) {
                        this._logger.warning("Evaluation error for conversation " + id + " : " + te.getMessage());
                    }
                }
            }
            this._model.readLock().release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void flush() throws StoreException {
    }

    public String getPluginName() {
        return "Search";
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public boolean isBusy() {
        return this._model.isBusy();
    }

    public boolean isModified() {
        return this._model.isModified();
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    public void run() {
        this._runThread = Thread.currentThread();
        this._model.setStopping(false);
        this._model.setRunning(true);
        this._model.setStatus("Idle");
        try {
            Thread.sleep(Long.MAX_VALUE);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._model.setRunning(false);
        this._model.setStatus("Stopped");
    }

    public void setSession(String type, Object store, String session) throws StoreException {
    }

    public boolean stop() {
        this._runThread.interrupt();
        return true;
    }
}

