/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.scripted.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.scripted.Scripted;
import org.owasp.webscarab.plugin.scripted.ScriptedUI;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.DocumentOutputStream;

public class ScriptedPanel
extends JPanel
implements ScriptedUI,
SwingPluginUI {
    private static final long serialVersionUID = -5126009853771604406L;
    private static ColumnDataModel[] NO_COLUMNS = new ColumnDataModel[0];
    private static Action[] NO_ACTIONS = new Action[0];
    private Scripted _scripted = null;
    private PrintStream _printStream;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JButton loadButton;
    private JButton newButton;
    private JTextArea outputTextArea;
    private JButton saveAsButton;
    private JButton saveButton;
    private JTextField scriptLanguageTextField;
    private JTextPane scriptTextPane;
    private JToolBar scriptToolBar;
    private JButton startButton;
    private JButton stopButton;

    public ScriptedPanel(Scripted scripted) {
        this.initComponents();
        this._scripted = scripted;
        DocumentOutputStream dos = new DocumentOutputStream(10240);
        this._printStream = new PrintStream(dos);
        this.outputTextArea.setDocument(dos.getDocument());
        this._scripted.setUI(this);
        this._scripted.setOut(this._printStream);
        this._scripted.setErr(this._printStream);
        this.saveButton.setEnabled(this._scripted.getScriptFile() != null);
        this.scriptLanguageTextField.setText(this._scripted.getScriptLanguage());
        this.scriptTextPane.setText(this._scripted.getScript());
        this.setEnabled(this._scripted.isRunning());
    }

    private void initComponents() {
        this.scriptToolBar = new JToolBar();
        this.newButton = new JButton();
        this.loadButton = new JButton();
        this.saveButton = new JButton();
        this.saveAsButton = new JButton();
        this.startButton = new JButton();
        this.stopButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.scriptLanguageTextField = new JTextField();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.scriptTextPane = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.outputTextArea = new JTextArea();
        this.setLayout(new BorderLayout());
        this.newButton.setText("New");
        this.newButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptedPanel.this.newButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.newButton);
        this.loadButton.setText("Load");
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptedPanel.this.loadButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.loadButton);
        this.saveButton.setText("Save");
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptedPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.saveButton);
        this.saveAsButton.setText("Save As");
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptedPanel.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.saveAsButton);
        this.scriptToolBar.addSeparator();
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptedPanel.this.startButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.startButton);
        this.stopButton.setText("Stop");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ScriptedPanel.this.stopButtonActionPerformed(evt);
            }
        });
        this.scriptToolBar.add(this.stopButton);
        this.add((Component)this.scriptToolBar, "North");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Language : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.scriptLanguageTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.7);
        this.jScrollPane1.setMinimumSize(new Dimension(400, 100));
        this.jScrollPane1.setPreferredSize(new Dimension(400, 100));
        this.scriptTextPane.setFont(new Font("Monospaced", 0, 14));
        this.scriptTextPane.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane1.setViewportView(this.scriptTextPane);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jScrollPane2.setMinimumSize(new Dimension(400, 64));
        this.jScrollPane2.setPreferredSize(new Dimension(400, 64));
        this.outputTextArea.setBackground(new Color(204, 204, 204));
        this.outputTextArea.setEditable(false);
        this.outputTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane2.setViewportView(this.outputTextArea);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jSplitPane1, gridBagConstraints);
        this.add((Component)this.jPanel1, "Center");
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        this._scripted.setScript(this.scriptLanguageTextField.getText(), this.scriptTextPane.getText());
        try {
            this._scripted.saveScript(this._scripted.getScriptFile());
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, new String[]{"Error saving script: ", ioe.getMessage()}, "Error", 0);
            this._logger.warning("Error saving script: " + ioe.getMessage());
        }
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        this._scripted.setScript(this.scriptLanguageTextField.getText(), this.scriptTextPane.getText());
        JFileChooser jfc = new JFileChooser(Preferences.getPreference("Scripted.DefaultDirectory"));
        jfc.setDialogTitle("Save as");
        int returnVal = jfc.showSaveDialog(this);
        if (returnVal == 0) {
            File script = jfc.getSelectedFile();
            try {
                this._scripted.saveScript(script);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, new String[]{"Error saving script: ", ioe.getMessage()}, "Error", 0);
            }
        }
        Preferences.setPreference("Scripted.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(Preferences.getPreference("Scripted.DefaultDirectory"));
        jfc.setDialogTitle("Load script");
        int returnVal = jfc.showOpenDialog(this);
        if (returnVal == 0) {
            File script = jfc.getSelectedFile();
            try {
                this._scripted.loadScript(script);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(null, new String[]{"Error loading script: ", ioe.getMessage()}, "Error", 0);
            }
        }
        Preferences.setPreference("Scripted.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
    }

    private void newButtonActionPerformed(ActionEvent evt) {
        try {
            this._scripted.loadScript(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this._scripted.stopScript();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        this._scripted.setScript(this.scriptLanguageTextField.getText(), this.scriptTextPane.getText());
        this._scripted.runScript();
    }

    public Action[] getConversationActions() {
        return NO_ACTIONS;
    }

    public ColumnDataModel[] getConversationColumns() {
        return NO_COLUMNS;
    }

    public Action[] getUrlActions() {
        return NO_ACTIONS;
    }

    public ColumnDataModel[] getUrlColumns() {
        return NO_COLUMNS;
    }

    public PrintStream getErrorStream() {
        return this._printStream;
    }

    public PrintStream getOutputStream() {
        return this._printStream;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return this._scripted.getPluginName();
    }

    public void scriptError(final String reason, final Throwable error) {
        if (SwingUtilities.isEventDispatchThread()) {
            String message = error.getMessage();
            try {
                int eStart = message.indexOf(":");
                int eEnd = message.indexOf("BSF info:");
                String info = message.substring(eEnd + 18);
                String ex = message.substring(eStart + 2, eEnd - 1);
                message = ex + "\n" + info;
            }
            catch (Exception e) {
                // empty catch block
            }
            JTextArea ta = new JTextArea(message);
            ta.setEditable(false);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(true);
            ta.setBackground(new Color(204, 204, 204));
            JScrollPane sp = new JScrollPane(ta);
            sp.setPreferredSize(new Dimension(600, 300));
            sp.setHorizontalScrollBarPolicy(31);
            JOptionPane.showMessageDialog(this, sp, "Script execution error", 0);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ScriptedPanel.this.scriptError(reason, error);
                }
            });
        }
    }

    public void scriptStarted() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScriptedPanel.this.startButton.setEnabled(false);
                ScriptedPanel.this.stopButton.setEnabled(true);
                ScriptedPanel.this.scriptTextPane.setEnabled(false);
            }
        });
    }

    public void scriptStopped() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ScriptedPanel.this.startButton.setEnabled(true);
                ScriptedPanel.this.stopButton.setEnabled(false);
                ScriptedPanel.this.scriptTextPane.setEnabled(true);
            }
        });
    }

    public void scriptFileChanged(File file) {
        this.saveButton.setEnabled(file != null);
    }

    public void scriptChanged(String script) {
        if (!this.scriptTextPane.getText().equals(script)) {
            this.scriptTextPane.setText(script);
            this.scriptTextPane.setCaretPosition(0);
        }
    }

    public void scriptLanguageChanged(String language) {
        this.scriptLanguageTextField.setText(language);
    }
}

