/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.manualrequest;

import java.io.IOException;
import java.util.Date;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.manualrequest.ManualRequestModel;
import org.owasp.webscarab.plugin.manualrequest.ManualRequestUI;

public class ManualRequest
implements Plugin {
    private ManualRequestUI _ui = null;
    private Request _request = null;
    private Response _response = null;
    private Date _responseDate = null;
    private Framework _framework;
    private ManualRequestModel _model;

    public ManualRequest(Framework framework) {
        this._framework = framework;
        this._model = new ManualRequestModel(this._framework.getModel());
    }

    public String getPluginName() {
        return new String("Manual Request");
    }

    public ManualRequestModel getModel() {
        return this._model;
    }

    public void setUI(ManualRequestUI ui) {
        this._ui = ui;
        if (this._ui != null) {
            this._ui.setEnabled(this._model.isRunning());
        }
    }

    public void setRequest(Request request) {
        this._request = request;
        if (this._ui != null) {
            this._ui.responseChanged(null);
            this._ui.requestChanged(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fetchResponse() throws IOException {
        if (this._request != null) {
            try {
                this._model.setBusy(true);
                this._model.setStatus("Started, Fetching response");
                this._response = HTTPClientFactory.getInstance().fetchResponse(this._request);
                if (this._response != null) {
                    this._responseDate = new Date();
                    this._framework.addConversation(this._request, this._response, "Manual Request");
                    if (this._ui != null) {
                        this._ui.responseChanged(this._response);
                    }
                }
            }
            finally {
                this._model.setStatus("Started, Idle");
                this._model.setBusy(false);
            }
        }
    }

    public void addRequestCookies() {
        Cookie[] cookies;
        if (this._request != null && (cookies = this._model.getCookiesForUrl(this._request.getURL())).length > 0) {
            StringBuffer buff = new StringBuffer();
            buff.append(cookies[0].getName()).append("=").append(cookies[0].getValue());
            for (int i = 1; i < cookies.length; ++i) {
                buff.append("; ").append(cookies[i].getName()).append("=").append(cookies[i].getValue());
            }
            this._request.setHeader(new NamedValue("Cookie", buff.toString()));
            if (this._ui != null) {
                this._ui.requestChanged(this._request);
            }
        }
    }

    public void updateCookies() {
        if (this._response != null) {
            NamedValue[] headers = this._response.getHeaders();
            for (int i = 0; i < headers.length; ++i) {
                if (!headers[i].getName().equalsIgnoreCase("Set-Cookie") && !headers[i].getName().equalsIgnoreCase("Set-Cookie2")) continue;
                Cookie cookie = new Cookie(this._responseDate, this._request.getURL(), headers[i].getValue());
                this._model.addCookie(cookie);
            }
        }
    }

    public void run() {
        this._model.setRunning(true);
        if (this._ui != null) {
            this._ui.setEnabled(this._model.isRunning());
        }
        this._model.setStatus("Started, Idle");
    }

    public boolean stop() {
        this._model.setStopping(true);
        this._model.setRunning(false);
        this._model.setStopping(false);
        if (this._ui != null) {
            this._ui.setEnabled(this._model.isRunning());
        }
        this._model.setStatus("Stopped");
        return !this._model.isRunning();
    }

    public void flush() throws StoreException {
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    public boolean isBusy() {
        return this._model.isBusy();
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public boolean isModified() {
        return false;
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
    }

    public void setSession(String type, Object store, String session) throws StoreException {
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }
}

