/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fuzz;

import java.util.ArrayList;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.util.Encoding;

public class Parameter {
    public static final Parameter[] NO_PARAMS = new Parameter[0];
    public static final String LOCATION_PATH = "Path";
    public static final String LOCATION_FRAGMENT = "Fragment";
    public static final String LOCATION_QUERY = "Query";
    public static final String LOCATION_COOKIE = "Cookie";
    public static final String LOCATION_BODY = "Body";
    private String _location;
    private String _name;
    private String _type;
    private Object _value;

    public static String[] getParameterLocations() {
        return new String[]{LOCATION_PATH, LOCATION_FRAGMENT, LOCATION_QUERY, LOCATION_COOKIE, LOCATION_BODY};
    }

    public Parameter(String location, String name, String type, Object value) {
        this._location = location;
        this._name = name;
        this._type = type;
        if (value == null) {
            throw new NullPointerException("Value may not be null");
        }
        this._value = value;
    }

    public String getLocation() {
        return this._location;
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }

    public String toString() {
        return this._location + ":" + this._name + "(" + this._type + ") = " + this._value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)obj;
        return this._location.equals(that._location) && this._name.equals(that._name) && this._type.equals(that._type) && this._value.equals(that._value);
    }

    public static Parameter[] getParameters(Request request) {
        int i;
        NamedValue[] values;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        String method = request.getMethod();
        HttpUrl url = request.getURL();
        String query = url.getQuery();
        String fragments = url.getFragment();
        if (url.getParameters() != null) {
            url = url.getParentUrl();
        }
        String contentType = request.getHeader("Content-Type");
        if (fragments != null) {
            values = NamedValue.splitNamedValues(fragments, "&", "=");
            for (i = 0; i < values.length; ++i) {
                parameters.add(new Parameter(LOCATION_FRAGMENT, values[i].getName(), "STRING", Encoding.urlDecode(values[i].getValue())));
            }
        }
        if (query != null) {
            values = NamedValue.splitNamedValues(query, "&", "=");
            for (i = 0; i < values.length; ++i) {
                parameters.add(new Parameter(LOCATION_QUERY, values[i].getName(), "STRING", Encoding.urlDecode(values[i].getValue())));
            }
        }
        NamedValue[] headers = request.getHeaders();
        for (i = 0; i < headers.length; ++i) {
            if (!headers[i].getName().equals(LOCATION_COOKIE)) continue;
            NamedValue[] cookies = NamedValue.splitNamedValues(headers[i].getValue(), "; *", "=");
            for (int j = 0; j < cookies.length; ++j) {
                parameters.add(new Parameter(LOCATION_COOKIE, cookies[j].getName(), "STRING", cookies[j].getValue()));
            }
        }
        if (method.equals("POST") && contentType != null) {
            Parameter[] body = Parameter.getParamsFromContent(contentType, request.getContent());
            for (int i2 = 0; i2 < body.length; ++i2) {
                parameters.add(body[i2]);
            }
        }
        return parameters.toArray(NO_PARAMS);
    }

    public static Parameter[] getParamsFromContent(String contentType, byte[] content) {
        if (contentType.equals("application/x-www-form-urlencoded")) {
            String body = new String(content);
            NamedValue[] nv = NamedValue.splitNamedValues(body, "&", "=");
            Parameter[] params = new Parameter[nv.length];
            for (int i = 0; i < nv.length; ++i) {
                params[i] = new Parameter(LOCATION_BODY, nv[i].getName(), "STRING", Encoding.urlDecode(nv[i].getValue()));
            }
            return params;
        }
        return new Parameter[0];
    }
}

