/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fragments.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.plugin.fragments.FragmentListener;
import org.owasp.webscarab.plugin.fragments.Fragments;
import org.owasp.webscarab.plugin.fragments.FragmentsModel;
import org.owasp.webscarab.plugin.fragments.swing.FragmentsFrame;
import org.owasp.webscarab.ui.swing.ColumnWidthTracker;
import org.owasp.webscarab.ui.swing.ConversationTableModel;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.ListComboBoxModel;
import org.owasp.webscarab.util.swing.MultiLineCellRenderer;

public class FragmentsPanel
extends JPanel
implements SwingPluginUI {
    private static final long serialVersionUID = 383270526566796972L;
    private FragmentsModel _model = null;
    private String _type = null;
    private Action[] _conversationActions;
    private Action[] _urlActions;
    private Map _conversationColumns = new HashMap();
    private Map _urlColumns = new HashMap();
    private DefaultListModel _typeListModel = new DefaultListModel();
    private FragmentListModel _flm = new FragmentListModel();
    private Listener _listener = new Listener();
    private static final ColumnDataModel[] CDM = new ColumnDataModel[0];
    private JTable conversationTable;
    private JList fragmentList;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JComboBox typeComboBox;
    static /* synthetic */ Class class$java$lang$Boolean;

    public FragmentsPanel(Fragments fragments) {
        this.initComponents();
        this._model = fragments.getModel();
        this.fragmentList.setCellRenderer(new FragmentRenderer());
        this.fragmentList.setModel(this._flm);
        this.fragmentList.setSelectionMode(0);
        this._typeListModel.addElement("COMMENTS");
        this._typeListModel.addElement("SCRIPTS");
        this.typeComboBox.setModel(new ListComboBoxModel(this._typeListModel));
        this.typeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FragmentsPanel.this._type = (String)FragmentsPanel.this.typeComboBox.getSelectedItem();
                FragmentsPanel.this._flm.setFilter(null, FragmentsPanel.this._type);
            }
        });
        this.fragmentList.addListSelectionListener(new FragmentsListListener());
        this.conversationTable.setModel(new ConversationTableModel(this._model.getConversationModel()));
        ColumnWidthTracker.getTracker("ConversationTable").addTable(this.conversationTable);
        this.createActions();
        this._model.addModelListener(this._listener);
    }

    private void createActions() {
        this._conversationActions = new Action[]{new FragmentsAction("CONVERSATION", "SCRIPTS"), new FragmentsAction("CONVERSATION", "COMMENTS")};
        this._urlActions = new Action[]{new FragmentsAction("URL", "SCRIPTS"), new FragmentsAction("URL", "COMMENTS")};
        ColumnDataModel cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (FragmentsPanel.this._model == null) {
                    return null;
                }
                String[] value = FragmentsPanel.this._model.getConversationFragmentKeys((ConversationID)key, "COMMENTS");
                return value != null && value.length > 0;
            }

            public String getColumnName() {
                return "Comments";
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = FragmentsPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        };
        this._conversationColumns.put("COMMENTS", cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (FragmentsPanel.this._model == null) {
                    return null;
                }
                String[] value = FragmentsPanel.this._model.getConversationFragmentKeys((ConversationID)key, "SCRIPTS");
                return value != null && value.length > 0;
            }

            public String getColumnName() {
                return "Scripts";
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = FragmentsPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        };
        this._conversationColumns.put("SCRIPTS", cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (FragmentsPanel.this._model == null) {
                    return null;
                }
                String[] keys = FragmentsPanel.this._model.getUrlFragmentKeys((HttpUrl)key, "COMMENTS");
                return keys != null && keys.length > 0;
            }

            public String getColumnName() {
                return "Comments";
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = FragmentsPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        };
        this._urlColumns.put("COMMENTS", cdm);
        cdm = new ColumnDataModel(){

            public Object getValue(Object key) {
                if (FragmentsPanel.this._model == null) {
                    return null;
                }
                String[] keys = FragmentsPanel.this._model.getUrlFragmentKeys((HttpUrl)key, "SCRIPTS");
                return keys != null && keys.length > 0;
            }

            public String getColumnName() {
                return "Scripts";
            }

            public Class getColumnClass() {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = FragmentsPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        };
        this._urlColumns.put("SCRIPTS", cdm);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.fragmentList = new JList();
        this.typeComboBox = new JComboBox();
        this.jScrollPane2 = new JScrollPane();
        this.conversationTable = new JTable();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(602, 570));
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.65);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setMinimumSize(new Dimension(400, 300));
        this.jPanel1.setPreferredSize(new Dimension(400, 300));
        this.jScrollPane1.setViewportView(this.fragmentList);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.typeComboBox, "North");
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jScrollPane2.setPreferredSize(new Dimension(200, 200));
        this.conversationTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.conversationTable.setAutoResizeMode(0);
        this.jScrollPane2.setViewportView(this.conversationTable);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    public Action[] getConversationActions() {
        return this._conversationActions;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return "Fragments";
    }

    public Action[] getUrlActions() {
        return this._urlActions;
    }

    public ColumnDataModel[] getConversationColumns() {
        return this._conversationColumns.values().toArray(CDM);
    }

    public ColumnDataModel[] getUrlColumns() {
        return this._urlColumns.values().toArray(CDM);
    }

    private class FragmentsListListener
    implements ListSelectionListener {
        private FragmentsListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (FragmentsPanel.this._type == null) {
                return;
            }
            int selected = FragmentsPanel.this.fragmentList.getSelectedIndex();
            String key = null;
            if (selected > -1) {
                key = (String)FragmentsPanel.this._flm.getElementAt(selected);
            }
            FragmentsPanel.this._model.setSelectedFragment(FragmentsPanel.this._type, key);
        }
    }

    private class FragmentRenderer
    extends MultiLineCellRenderer {
        private static final long serialVersionUID = -6061481472856144741L;

        private FragmentRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                value = FragmentsPanel.this._model.getFragment((String)value);
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private class FragmentListModel
    extends AbstractListModel
    implements FragmentListener {
        private static final long serialVersionUID = -2253303710061129296L;
        private String _type = null;
        private int _size = 0;

        public void setFilter(Object id, String type) {
            this.fireIntervalRemoved(this, 0, this.getSize());
            this._type = type;
            this.fireIntervalAdded(this, 0, this.getSize());
        }

        public Object getElementAt(int index) {
            return FragmentsPanel.this._model.getFragmentKeyAt(this._type, index);
        }

        public int getSize() {
            if (this._type == null) {
                return 0;
            }
            this._size = FragmentsPanel.this._model.getFragmentCount(this._type);
            return this._size;
        }

        protected void fireContentsChanged() {
            if (this._size > 0) {
                this.fireIntervalRemoved(this, 0, this._size);
            }
            if (this.getSize() > 0) {
                this.fireIntervalAdded(this, 0, this.getSize());
            }
        }

        public void fragmentAdded(HttpUrl url, ConversationID id, String type, String key) {
        }

        public void fragmentAdded(String type, String key, final int position) {
            if (this._type == null || !this._type.equals(type)) {
                return;
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FragmentListModel.this.fireIntervalAdded(this, position, position);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void fragmentsChanged() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FragmentListModel.this.fireContentsChanged();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class Listener
    implements FragmentListener {
        private Listener() {
        }

        public void fragmentAdded(final HttpUrl url, final ConversationID id, final String type, String key) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ColumnDataModel cdm = (ColumnDataModel)FragmentsPanel.this._urlColumns.get(type);
                        if (cdm != null) {
                            cdm.fireValueChanged(url);
                        }
                        if ((cdm = (ColumnDataModel)FragmentsPanel.this._conversationColumns.get(type)) != null) {
                            cdm.fireValueChanged(id);
                        }
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void fragmentAdded(String type, String key, int position) {
        }

        public void fragmentsChanged() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        FragmentsPanel.this._flm.fireContentsChanged();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class FragmentsAction
    extends AbstractAction {
        private static final long serialVersionUID = -4183487246345191629L;
        private String _type;
        private String _where;

        public FragmentsAction(String where, String type) {
            this._where = where;
            this._type = type;
            this.putValue("Name", "Show " + this._type.toLowerCase());
            this.putValue("ShortDescription", "Displays any " + this._type.toLowerCase() + " seen in the " + this._where.toLowerCase());
            this.putValue(this._where, null);
        }

        private String[] getFragments() {
            String[] fragments = new String[]{};
            Object o = this.getValue(this._where);
            if (this._where.equals("URL") && o instanceof HttpUrl) {
                HttpUrl url = (HttpUrl)o;
                fragments = FragmentsPanel.this._model.getUrlFragmentKeys(url, this._type);
            } else if (this._where.equals("CONVERSATION") && o instanceof ConversationID) {
                ConversationID id = (ConversationID)o;
                fragments = FragmentsPanel.this._model.getConversationFragmentKeys(id, this._type);
            }
            for (int i = 0; i < fragments.length; ++i) {
                fragments[i] = FragmentsPanel.this._model.getFragment(fragments[i]);
            }
            return fragments;
        }

        public void actionPerformed(ActionEvent e) {
            String[] fragments = this.getFragments();
            if (fragments.length > 0) {
                FragmentsFrame ff = new FragmentsFrame();
                ff.setFragments(fragments);
                ff.setTitle(this._type + " in " + this._where + " " + this.getValue(this._where));
                ff.setVisible(true);
            }
        }

        public void putValue(String key, Object value) {
            super.putValue(key, value);
            if (key != null && key.equals(this._where)) {
                if (value != null && this.getFragments().length > 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        }
    }
}

