/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fragments;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.AbstractConversationModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.AbstractPluginModel;
import org.owasp.webscarab.plugin.fragments.FragmentListener;
import org.owasp.webscarab.plugin.fragments.FragmentsStore;
import org.owasp.webscarab.util.Encoding;

public class FragmentsModel
extends AbstractPluginModel {
    private FragmentsStore _store = null;
    private FrameworkModel _model = null;
    private FragmentConversationModel _fcm = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private EventListenerList _listenerList = new EventListenerList();

    public FragmentsModel(FrameworkModel model) {
        this._model = model;
        this._fcm = new FragmentConversationModel(model);
    }

    public void addFragment(HttpUrl url, ConversationID id, String type, String fragment) {
        try {
            this._rwl.writeLock().acquire();
            String key = Encoding.hashMD5(fragment);
            int position = this._store.putFragment(type, key, fragment);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._model.addConversationProperty(id, type, key);
            this._model.addUrlProperty(url, type, key);
            this.fireFragmentAdded(url, id, type, key);
            if (position > -1) {
                this.fireFragmentAdded(type, key, position);
            }
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this.setModified(true);
    }

    public String[] getUrlFragmentKeys(HttpUrl url, String type) {
        if (type.equals("SCRIPTS") || type.equals("COMMENTS")) {
            return this._model.getUrlProperties(url, type);
        }
        return new String[0];
    }

    public String[] getConversationFragmentKeys(ConversationID id, String type) {
        if (type.equals("SCRIPTS") || type.equals("COMMENTS")) {
            return this._model.getConversationProperties(id, type);
        }
        return new String[0];
    }

    public int getFragmentTypeCount() {
        if (this._store == null) {
            return 0;
        }
        return this._store.getFragmentTypeCount();
    }

    public String getFragmentType(int index) {
        return this._store.getFragmentType(index);
    }

    public int getFragmentCount(String type) {
        return this._store.getFragmentCount(type);
    }

    public String getFragmentKeyAt(String type, int position) {
        return this._store.getFragmentKeyAt(type, position);
    }

    public int indexOfFragment(String type, String key) {
        return this._store.indexOfFragment(type, key);
    }

    public String getFragment(String key) {
        return this._store.getFragment(key);
    }

    public void addModelListener(FragmentListener listener) {
        this._listenerList.add(FragmentListener.class, listener);
    }

    public void removeModelListener(FragmentListener listener) {
        this._listenerList.remove(FragmentListener.class, listener);
    }

    public ConversationModel getConversationModel() {
        return this._fcm;
    }

    public void setSelectedFragment(String type, String key) {
        try {
            this._rwl.writeLock().acquire();
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._fcm.setSelectedFragment(type, key);
    }

    public void setStore(FragmentsStore store) {
        this._store = store;
        this.fireFragmentsChanged();
        this.setModified(false);
    }

    public void flush() throws StoreException {
        if (this._store != null && this.isModified()) {
            this._store.flush();
            this.setModified(false);
        }
    }

    private void fireFragmentsChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fragments$FragmentListener == null ? FragmentsModel.class$("org.owasp.webscarab.plugin.fragments.FragmentListener") : class$org$owasp$webscarab$plugin$fragments$FragmentListener)) continue;
            try {
                ((FragmentListener)listeners[i + 1]).fragmentsChanged();
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    private void fireFragmentAdded(String type, String key, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fragments$FragmentListener == null ? FragmentsModel.class$("org.owasp.webscarab.plugin.fragments.FragmentListener") : class$org$owasp$webscarab$plugin$fragments$FragmentListener)) continue;
            try {
                ((FragmentListener)listeners[i + 1]).fragmentAdded(type, key, position);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    private void fireFragmentAdded(HttpUrl url, ConversationID id, String type, String key) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$fragments$FragmentListener == null ? FragmentsModel.class$("org.owasp.webscarab.plugin.fragments.FragmentListener") : class$org$owasp$webscarab$plugin$fragments$FragmentListener)) continue;
            try {
                ((FragmentListener)listeners[i + 1]).fragmentAdded(url, id, type, key);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled : " + e);
            }
        }
    }

    private class FragmentConversationModel
    extends AbstractConversationModel
    implements FragmentListener {
        private String _type;
        private String _key;
        private List _conversationList;

        public FragmentConversationModel(FrameworkModel model) {
            super(model);
            this._type = null;
            this._key = null;
            this._conversationList = new ArrayList();
        }

        public void setSelectedFragment(String type, String key) {
            try {
                FragmentsModel.this._rwl.writeLock().acquire();
                this._type = type;
                this._key = key;
                this._conversationList.clear();
                if (this._type != null && this._key != null) {
                    ConversationModel cmodel = FragmentsModel.this._model.getConversationModel();
                    int count = cmodel.getConversationCount();
                    block2: for (int i = 0; i < count; ++i) {
                        ConversationID id = cmodel.getConversationAt(i);
                        String[] fragments = FragmentsModel.this.getConversationFragmentKeys(id, this._type);
                        if (fragments == null) continue;
                        for (int j = 0; j < fragments.length; ++j) {
                            if (!fragments[j].equals(this._key)) continue;
                            this._conversationList.add(id);
                            continue block2;
                        }
                    }
                }
                FragmentsModel.this._rwl.readLock().acquire();
                FragmentsModel.this._rwl.writeLock().release();
                this.fireConversationsChanged();
                FragmentsModel.this._rwl.readLock().release();
            }
            catch (InterruptedException ie) {
                FragmentsModel.this._logger.severe("Interrupted! " + ie);
            }
        }

        public ConversationID getConversationAt(int index) {
            return (ConversationID)this._conversationList.get(index);
        }

        public int getConversationCount() {
            return this._conversationList.size();
        }

        public int getIndexOfConversation(ConversationID id) {
            return Collections.binarySearch(this._conversationList, id);
        }

        public Sync readLock() {
            return FragmentsModel.this._rwl.readLock();
        }

        public void fragmentAdded(String type, String key, int position) {
        }

        public void fragmentAdded(HttpUrl url, ConversationID id, String type, String key) {
            int index;
            if (this._type != null && this._key != null && this._type.equals(type) && this._key.equals(key) && (index = this.getIndexOfConversation(id)) < 0) {
                try {
                    FragmentsModel.this._rwl.writeLock().acquire();
                    this._conversationList.add(-index - 1, id);
                    FragmentsModel.this._rwl.readLock().acquire();
                    FragmentsModel.this._rwl.writeLock().release();
                    this.fireConversationAdded(id, -index - 1);
                    FragmentsModel.this._rwl.readLock().release();
                }
                catch (InterruptedException ie) {
                    FragmentsModel.this._logger.severe("Interrupted! " + ie);
                }
            }
        }

        public void fragmentsChanged() {
            try {
                FragmentsModel.this._rwl.writeLock().acquire();
                this._key = null;
                this._type = null;
                this._conversationList.clear();
                FragmentsModel.this._rwl.readLock().acquire();
                FragmentsModel.this._rwl.writeLock().release();
                this.fireConversationsChanged();
                FragmentsModel.this._rwl.readLock().release();
            }
            catch (InterruptedException ie) {
                FragmentsModel.this._logger.severe("Interrupted! " + ie);
            }
        }
    }
}

