/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fragments;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.fragments.FragmentsStore;

public class FileSystemStore
implements FragmentsStore {
    private File _dir;
    private static final String[] NONE = new String[0];
    private Map _types = new TreeMap();
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public FileSystemStore(File dir, String session) throws StoreException {
        this._dir = dir;
        this.create();
    }

    private void create() throws StoreException {
        if (!this._dir.exists()) {
            throw new StoreException(this._dir + " does not exist!");
        }
        this._dir = new File(this._dir, "fragments");
        if (!this._dir.exists() && !this._dir.mkdirs()) {
            throw new StoreException("Couldn't create directory " + this._dir);
        }
        if (!this._dir.isDirectory()) {
            throw new StoreException(this._dir + " exists, and is not a directory!");
        }
        this.load();
    }

    private void load() throws StoreException {
        File index = new File(this._dir, "index");
        try {
            String line;
            String type = null;
            ArrayList<String> list = null;
            BufferedReader br = new BufferedReader(new FileReader(index));
            while ((line = br.readLine()) != null) {
                if (line.equals("")) {
                    type = null;
                    continue;
                }
                if (type == null) {
                    type = line;
                    list = new ArrayList<String>();
                    this._types.put(type, list);
                    continue;
                }
                list.add(line);
            }
            br.close();
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            throw new StoreException("IOException reading the index: " + ioe);
        }
    }

    public String getFragment(String key) {
        File f = new File(this._dir, key);
        FileReader fr = null;
        try {
            fr = new FileReader(f);
        }
        catch (FileNotFoundException fnfe) {
            this._logger.warning("Error reading fragment '" + key + "' : " + fnfe);
            return "";
        }
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[1024];
        int got = 0;
        try {
            while ((got = fr.read(buf)) > 0) {
                sb.append(buf, 0, got);
            }
            fr.close();
        }
        catch (IOException ioe) {
            this._logger.warning("Error reading fragment '" + key + "' : " + ioe);
        }
        return sb.toString();
    }

    public int putFragment(String type, String key, String fragment) {
        ArrayList<String> list = (ArrayList<String>)this._types.get(type);
        if (list == null) {
            list = new ArrayList<String>();
            this._types.put(type, list);
        }
        if (list.indexOf(key) > -1) {
            return -1;
        }
        list.add(key);
        File f = new File(this._dir, key);
        FileWriter fw = null;
        try {
            fw = new FileWriter(f);
            fw.write(fragment);
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            this._logger.warning("Error writing fragment " + key + " : " + ioe);
        }
        return list.size() - 1;
    }

    public void flush() throws StoreException {
        File index = new File(this._dir, "index");
        if (this._types.size() == 0) {
            return;
        }
        try {
            String type = null;
            BufferedWriter bw = new BufferedWriter(new FileWriter(index));
            Iterator it = this._types.keySet().iterator();
            while (it.hasNext()) {
                type = (String)it.next();
                bw.write(type + "\r\n");
                List list = (List)this._types.get(type);
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    String fragment = (String)it2.next();
                    bw.write(fragment + "\r\n");
                }
                bw.write("\r\n");
            }
            bw.close();
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            throw new StoreException("IOException reading the index: " + ioe);
        }
    }

    public int getFragmentCount(String type) {
        List fragments = (List)this._types.get(type);
        if (fragments == null) {
            return 0;
        }
        return fragments.size();
    }

    public String getFragmentKeyAt(String type, int position) {
        List fragments = (List)this._types.get(type);
        if (fragments == null) {
            return null;
        }
        return (String)fragments.get(position);
    }

    public String getFragmentType(int index) {
        return this._types.keySet().toArray(NONE)[index];
    }

    public int getFragmentTypeCount() {
        return this._types.size();
    }

    public int indexOfFragment(String type, String key) {
        List list = (List)this._types.get(type);
        if (list == null) {
            return -1;
        }
        return list.indexOf(key);
    }
}

