/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.extensions;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FilteredConversationModel;
import org.owasp.webscarab.model.FilteredUrlModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.plugin.AbstractPluginModel;

public class ExtensionsModel
extends AbstractPluginModel {
    private FrameworkModel _model;
    private ConversationModel _conversationModel;
    private UrlModel _urlModel;
    private String[] _directoryExtensions = new String[]{".zip", ".arj", ".tar", ".tar.gz", ".tar.bz2", ".tgz", ".exe", ".rar", ".tbz"};
    private String[] _fileExtensions = new String[]{".bak", "~", ".old", ".rej", ".orig", ".inc"};
    private LinkedList toBeAnalyzedQueue = new LinkedList();
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public ExtensionsModel(FrameworkModel model) {
        this._model = model;
        this._conversationModel = new FilteredConversationModel(model, model.getConversationModel()){

            public boolean shouldFilter(ConversationID id) {
                return !this.getConversationOrigin(id).equals("Extensions");
            }
        };
        this._urlModel = new FilteredUrlModel(model.getUrlModel()){

            public boolean shouldFilter(HttpUrl url) {
                return url.getParameters() != null || ExtensionsModel.this.isTested(url);
            }
        };
    }

    public void setDirectoryExtensions(String[] extensions) {
        this._directoryExtensions = extensions;
    }

    public String[] getDirectoryExtensions() {
        return this._directoryExtensions;
    }

    public void setFileExtensions(String[] extensions) {
        this._fileExtensions = extensions;
    }

    public String[] getFileExtensions() {
        return this._fileExtensions;
    }

    public ConversationModel getConversationModel() {
        return this._conversationModel;
    }

    public UrlModel getUrlModel() {
        return this._urlModel;
    }

    public int getExtensionsTested(HttpUrl url) {
        String checked = this._model.getUrlProperty(url, "EXTENSIONS");
        if (checked == null) {
            return 0;
        }
        try {
            int count = Integer.parseInt(checked);
            return count;
        }
        catch (NumberFormatException nfe) {
            this._logger.warning("NumberFormatException parsing Extensions property: " + checked);
            return 0;
        }
    }

    public void incrementExtensionsTested(HttpUrl url) {
        int count = this.getExtensionsTested(url);
        this._model.setUrlProperty(url, "EXTENSIONS", Integer.toString(++count));
    }

    public int getExtensionCount(HttpUrl url) {
        if (url.getPath().endsWith("/")) {
            return this._directoryExtensions == null ? 0 : this._directoryExtensions.length;
        }
        return this._fileExtensions == null ? 0 : this._fileExtensions.length;
    }

    public String getExtension(HttpUrl url, int index) {
        if (url.getPath().endsWith("/")) {
            return this._directoryExtensions[index];
        }
        return this._fileExtensions[index];
    }

    public boolean isTested(HttpUrl url) {
        return this.getExtensionsTested(url) >= this.getExtensionCount(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueURL(HttpUrl url) {
        LinkedList linkedList = this.toBeAnalyzedQueue;
        synchronized (linkedList) {
            if (!this.isTested(url)) {
                this.toBeAnalyzedQueue.addLast(url);
                this.toBeAnalyzedQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpUrl dequeueURL() {
        LinkedList linkedList = this.toBeAnalyzedQueue;
        synchronized (linkedList) {
            try {
                while (this.toBeAnalyzedQueue.isEmpty()) {
                    this.toBeAnalyzedQueue.wait();
                }
                return (HttpUrl)this.toBeAnalyzedQueue.removeFirst();
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }
}

