/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.bsf.BSFManager;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.CredentialManager;
import org.owasp.webscarab.plugin.FrameworkModelWrapper;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.ScriptManager;
import org.owasp.webscarab.plugin.ScriptableConversation;

public class Framework {
    private List _plugins = new ArrayList();
    private List _analysisQueue = new LinkedList();
    private FrameworkModel _model;
    private FrameworkModelWrapper _wrapper;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private String _version;
    private ScriptManager _scriptManager;
    private CredentialManager _credentialManager;
    private AddConversationHook _allowAddConversation;
    private AnalyseConversationHook _analyseConversation;
    private Thread _queueThread = null;
    private QueueProcessor _qp = null;
    private Pattern dropPattern = null;

    public Framework() {
        this._model = new FrameworkModel();
        this._wrapper = new FrameworkModelWrapper(this._model);
        this._scriptManager = new ScriptManager(this);
        this._allowAddConversation = new AddConversationHook();
        this._analyseConversation = new AnalyseConversationHook();
        this._scriptManager.registerHooks("Framework", new Hook[]{this._allowAddConversation, this._analyseConversation});
        this.extractVersionFromManifest();
        this._credentialManager = new CredentialManager();
        this.configureHTTPClient();
        String dropRegex = Preferences.getPreference("WebScarab.dropRegex", null);
        try {
            this.setDropPattern(dropRegex);
        }
        catch (PatternSyntaxException pse) {
            this._logger.warning("Got an invalid regular expression for conversations to ignore: " + dropRegex + " results in " + pse.toString());
        }
        this._qp = new QueueProcessor();
        this._queueThread = new Thread((Runnable)this._qp, "QueueProcessor");
        this._queueThread.setDaemon(true);
        this._queueThread.setPriority(1);
        this._queueThread.start();
    }

    public ScriptManager getScriptManager() {
        return this._scriptManager;
    }

    public CredentialManager getCredentialManager() {
        return this._credentialManager;
    }

    public String getDropPattern() {
        return this.dropPattern == null ? "" : this.dropPattern.pattern();
    }

    public void setDropPattern(String pattern) throws PatternSyntaxException {
        if (pattern == null || "".equals(pattern)) {
            this.dropPattern = null;
            Preferences.setPreference("WebScarab.dropRegex", "");
        } else {
            this.dropPattern = Pattern.compile(pattern);
            Preferences.setPreference("WebScarab.dropRegex", pattern);
        }
    }

    public void setSession(String type, Object store, String session) throws StoreException {
        this._model.setSession(type, store, session);
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.isRunning()) {
                plugin.setSession(type, store, session);
                continue;
            }
            this._logger.warning(plugin.getPluginName() + " is running while we are setting the session");
        }
    }

    public FrameworkModel getModel() {
        return this._model;
    }

    private void extractVersionFromManifest() {
        Package pkg = Package.getPackage("org.owasp.webscarab");
        if (pkg != null) {
            this._version = pkg.getImplementationVersion();
        } else {
            this._logger.severe("PKG is null");
        }
        if (this._version == null) {
            this._version = "unknown (local build?)";
        }
    }

    public void addPlugin(Plugin plugin) {
        this._plugins.add(plugin);
        Hook[] hooks = plugin.getScriptingHooks();
        this._scriptManager.registerHooks(plugin.getPluginName(), hooks);
    }

    public Plugin getPlugin(String name) {
        Plugin plugin = null;
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            plugin = (Plugin)it.next();
            if (!plugin.getPluginName().equals(name)) continue;
            return plugin;
        }
        return null;
    }

    public void startPlugins() {
        HTTPClientFactory.getInstance().getSSLContextManager().invalidateSessions();
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.isRunning()) {
                Thread t = new Thread((Runnable)plugin, plugin.getPluginName());
                t.setDaemon(true);
                t.start();
                continue;
            }
            this._logger.warning(plugin.getPluginName() + " was already running");
        }
        this._scriptManager.loadScripts();
    }

    public boolean isBusy() {
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.isBusy()) continue;
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.isRunning()) continue;
            return true;
        }
        return false;
    }

    public boolean isModified() {
        if (this._model.isModified()) {
            return true;
        }
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.isModified()) continue;
            return true;
        }
        return false;
    }

    public String[] getStatus() {
        ArrayList<String> status = new ArrayList<String>();
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            status.add(plugin.getPluginName() + " : " + plugin.getStatus());
        }
        return status.toArray(new String[0]);
    }

    public boolean stopPlugins() {
        if (this.isBusy()) {
            return false;
        }
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (plugin.isRunning()) {
                plugin.stop();
                continue;
            }
            this._logger.warning(plugin.getPluginName() + " was not running");
        }
        this._scriptManager.saveScripts();
        return true;
    }

    public void saveSessionData() throws StoreException {
        StoreException storeException = null;
        if (this._model.isModified()) {
            this._logger.info("Flushing model");
            this._model.flush();
            this._logger.info("Done");
        }
        Iterator it = this._plugins.iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            if (!plugin.isModified()) continue;
            try {
                this._logger.info("Flushing " + plugin.getPluginName());
                plugin.flush();
                this._logger.info("Done");
            }
            catch (StoreException se) {
                if (storeException == null) {
                    storeException = se;
                }
                this._logger.severe("Error saving data for " + plugin.getPluginName() + ": " + se);
            }
        }
        if (storeException != null) {
            throw storeException;
        }
    }

    public String getVersion() {
        return this._version;
    }

    public ConversationID reserveConversationID() {
        return this._model.reserveConversationID();
    }

    public void addConversation(ConversationID id, Request request, Response response, String origin) {
        this.addConversation(id, new Date(), request, response, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConversation(ConversationID id, Date when, Request request, Response response, String origin) {
        ScriptableConversation conversation = new ScriptableConversation(id, request, response, origin);
        this._allowAddConversation.runScripts(conversation);
        if (conversation.isCancelled()) {
            return;
        }
        if (this.dropPattern != null && this.dropPattern.matcher(request.getURL().toString()).matches()) {
            return;
        }
        this._model.addConversation(id, when, request, response, origin);
        if (!conversation.shouldAnalyse()) {
            return;
        }
        this._analyseConversation.runScripts(conversation);
        List list = this._analysisQueue;
        synchronized (list) {
            this._analysisQueue.add(id);
        }
    }

    public ConversationID addConversation(Request request, Response response, String origin) {
        ConversationID id = this.reserveConversationID();
        this.addConversation(id, new Date(), request, response, origin);
        return id;
    }

    private void configureHTTPClient() {
        HTTPClientFactory factory = HTTPClientFactory.getInstance();
        String prop = null;
        try {
            prop = "WebScarab.httpProxy";
            String value = Preferences.getPreference(prop);
            if (value == null || value.equals("")) {
                value = ":3128";
            }
            int colon = value.indexOf(":");
            factory.setHttpProxy(value.substring(0, colon), Integer.parseInt(value.substring(colon + 1).trim()));
            prop = "WebScarab.httpsProxy";
            value = Preferences.getPreference(prop);
            if (value == null || value.equals("")) {
                value = ":3128";
            }
            colon = value.indexOf(":");
            factory.setHttpsProxy(value.substring(0, colon), Integer.parseInt(value.substring(colon + 1).trim()));
            prop = "WebScarab.noProxy";
            value = Preferences.getPreference(prop, "");
            if (value == null) {
                value = "";
            }
            factory.setNoProxy(value.split(" *, *"));
            int connectTimeout = 30000;
            prop = "HttpClient.connectTimeout";
            value = Preferences.getPreference(prop, "");
            if (value != null && !value.equals("")) {
                try {
                    connectTimeout = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            int readTimeout = 0;
            prop = "HttpClient.readTimeout";
            value = Preferences.getPreference(prop, "");
            if (value != null && !value.equals("")) {
                try {
                    readTimeout = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            factory.setTimeouts(connectTimeout, readTimeout);
        }
        catch (NumberFormatException nfe) {
            this._logger.warning("Error parsing property " + prop + ": " + nfe);
        }
        catch (Exception e) {
            this._logger.warning("Error configuring the HTTPClient property " + prop + ": " + e);
        }
        factory.setAuthenticator(this._credentialManager);
    }

    private class AnalyseConversationHook
    extends Hook {
        public AnalyseConversationHook() {
            super("Analyse Conversation", "Called when a new conversation is added to the framework.\nUse model.setConversationProperty(id, property, value) to assign properties");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runScripts(ScriptableConversation conversation) {
            if (this._bsfManager == null) {
                return;
            }
            BSFManager bSFManager = this._bsfManager;
            synchronized (bSFManager) {
                try {
                    this._bsfManager.declareBean("id", (Object)conversation.getId(), conversation.getId().getClass());
                    this._bsfManager.declareBean("conversation", (Object)conversation, conversation.getClass());
                    this._bsfManager.declareBean("model", (Object)Framework.this._wrapper, Framework.this._wrapper.getClass());
                    super.runScripts();
                    this._bsfManager.undeclareBean("conversation");
                }
                catch (Exception e) {
                    Framework.this._logger.severe("Declaring or undeclaring a bean should not throw an exception! " + e);
                }
            }
        }
    }

    private class AddConversationHook
    extends Hook {
        public AddConversationHook() {
            super("Add Conversation", "Called when a new conversation is added to the framework.\nUse conversation.setCancelled(boolean) and conversation.setAnalyse(boolean) after deciding using conversation.getRequest() and conversation.getResponse()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runScripts(ScriptableConversation conversation) {
            if (this._bsfManager == null) {
                return;
            }
            BSFManager bSFManager = this._bsfManager;
            synchronized (bSFManager) {
                try {
                    this._bsfManager.declareBean("conversation", (Object)conversation, conversation.getClass());
                    super.runScripts();
                    this._bsfManager.undeclareBean("conversation");
                }
                catch (Exception e) {
                    Framework.this._logger.severe("Declaring or undeclaring a bean should not throw an exception! " + e);
                }
            }
        }
    }

    private class QueueProcessor
    implements Runnable {
        private QueueProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block7: while (true) {
                ConversationID id = null;
                List list = Framework.this._analysisQueue;
                synchronized (list) {
                    if (Framework.this._analysisQueue.size() > 0) {
                        id = (ConversationID)Framework.this._analysisQueue.remove(0);
                    }
                }
                if (id != null) {
                    Request request = Framework.this._model.getRequest(id);
                    Response response = Framework.this._model.getResponse(id);
                    String origin = Framework.this._model.getConversationOrigin(id);
                    Iterator it = Framework.this._plugins.iterator();
                    while (true) {
                        if (!it.hasNext()) continue block7;
                        Plugin plugin = (Plugin)it.next();
                        if (!plugin.isRunning()) continue;
                        try {
                            plugin.analyse(id, request, response, origin);
                        }
                        catch (Exception e) {
                            Framework.this._logger.warning(plugin.getPluginName() + " failed to process " + id + ": " + e);
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

