/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.text.ParseException;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Message;

public class Request
extends Message {
    private String _method = "GET";
    private HttpUrl _url = null;
    private String _version = "HTTP/1.0";

    public Request() {
    }

    public Request(Request req) {
        this._method = req.getMethod();
        this._url = req.getURL();
        this._version = req.getVersion();
        this.setHeaders(req.getHeaders());
        this.setContent(req.getContent());
    }

    public void read(InputStream is) throws IOException {
        this.read(is, null);
    }

    public void read(InputStream is, HttpUrl base) throws IOException {
        String line = null;
        this._logger.finer("Base: " + base);
        try {
            line = this.readLine(is);
            this._logger.finest("Request: " + line);
        }
        catch (SocketTimeoutException ste) {
            return;
        }
        if (line == null || line.equals("")) {
            return;
        }
        String[] parts = line.split(" ");
        if (parts.length == 2 || parts.length == 3) {
            this.setMethod(parts[0]);
            if (this.getMethod().equalsIgnoreCase("CONNECT")) {
                this.setURL(new HttpUrl("https://" + parts[1] + "/"));
            } else {
                this.setURL(new HttpUrl(base, parts[1]));
            }
        } else {
            throw new IOException("Invalid request line reading from the InputStream '" + line + "'");
        }
        if (parts.length == 3) {
            this.setVersion(parts[2]);
        } else {
            this.setVersion("HTTP/0.9");
        }
        super.read(is);
        if (this._method.equals("CONNECT") || this._method.equals("GET") || this._method.equals("HEAD") || this._method.equals("TRACE")) {
            this.setNoBody();
        }
    }

    public void parse(String string) throws ParseException {
        this.parse(new StringBuffer(string));
    }

    public void parse(StringBuffer buff) throws ParseException {
        String line = null;
        line = this.getLine(buff);
        String[] parts = line.split(" ");
        if (parts.length == 2 || parts.length == 3) {
            this.setMethod(parts[0]);
            try {
                if (this.getMethod().equalsIgnoreCase("CONNECT")) {
                    this.setURL(new HttpUrl("https://" + parts[1] + "/"));
                }
                this.setURL(new HttpUrl(parts[1]));
            }
            catch (MalformedURLException mue) {
                throw new ParseException("Malformed URL '" + parts[1] + "' : " + mue, parts[0].length() + 1);
            }
        } else {
            throw new ParseException("Invalid request line '" + line + "'", 0);
        }
        if (parts.length == 3) {
            this.setVersion(parts[2]);
        } else {
            this.setVersion("HTTP/0.9");
        }
        super.parse(buff);
        if (this._method.equals("CONNECT") || this._method.equals("GET") || this._method.equals("HEAD") || this._method.equals("TRACE")) {
            this.setNoBody();
        }
    }

    public void write(OutputStream os) throws IOException {
        this.write(os, "\r\n");
    }

    public void write(OutputStream os, String crlf) throws IOException {
        if (this._method == null || this._url == null || this._version == null) {
            System.err.println("Uninitialised Request!");
            return;
        }
        os = new BufferedOutputStream(os);
        String requestLine = this._method + " " + this._url + " " + this._version + crlf;
        os.write(requestLine.getBytes());
        this._logger.finer("Request: " + requestLine);
        super.write(os, crlf);
        os.flush();
    }

    public void writeDirect(OutputStream os) throws IOException {
        this.writeDirect(os, "\r\n");
    }

    public void writeDirect(OutputStream os, String crlf) throws IOException {
        if (this._method == null || this._url == null || this._version == null) {
            System.err.println("Uninitialised Request!");
            return;
        }
        os = new BufferedOutputStream(os);
        String requestLine = this._method + " " + this._url.direct() + " " + this._version;
        os.write((requestLine + crlf).getBytes());
        this._logger.finer("Request: " + requestLine);
        super.write(os, crlf);
        os.flush();
    }

    public void setMethod(String method) {
        this._method = method.toUpperCase();
    }

    public String getMethod() {
        return this._method;
    }

    public void setURL(HttpUrl url) {
        this._url = url;
    }

    public HttpUrl getURL() {
        return this._url;
    }

    public void setVersion(String version) {
        this._version = version.toUpperCase();
    }

    public String getVersion() {
        return this._version;
    }

    public String toString() {
        return this.toString("\r\n");
    }

    public String toString(String crlf) {
        if (this._method == null || this._url == null || this._version == null) {
            return "Unitialised Request!";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this._method).append(" ");
        buff.append(this._url).append(" ");
        buff.append(this._version).append(crlf);
        buff.append(super.toString(crlf));
        return buff.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Request)) {
            return false;
        }
        Request req = (Request)obj;
        if (!this.getMethod().equals(req.getMethod())) {
            return false;
        }
        if (!this.getURL().equals(req.getURL())) {
            return false;
        }
        if (!this.getVersion().equals(req.getVersion())) {
            return false;
        }
        return super.equals(req);
    }
}

