/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.ConversationEvent;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationListener;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;

public abstract class AbstractConversationModel
implements ConversationModel {
    private FrameworkModel _model;
    private EventListenerList _listenerList = new EventListenerList();
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public AbstractConversationModel(FrameworkModel model) {
        this._model = model;
    }

    public abstract int getConversationCount();

    public abstract ConversationID getConversationAt(int var1);

    public abstract int getIndexOfConversation(ConversationID var1);

    public abstract Sync readLock();

    public String getConversationOrigin(ConversationID id) {
        return this._model.getConversationOrigin(id);
    }

    public Date getConversationDate(ConversationID id) {
        return this._model.getConversationDate(id);
    }

    public String getRequestMethod(ConversationID id) {
        return this._model.getRequestMethod(id);
    }

    public String getConversationProperty(ConversationID id, String property) {
        return this._model.getConversationProperty(id, property);
    }

    public void setConversationProperty(ConversationID id, String property, String value) {
        this._model.setConversationProperty(id, property, value);
    }

    public String getResponseStatus(ConversationID id) {
        return this._model.getResponseStatus(id);
    }

    public HttpUrl getRequestUrl(ConversationID id) {
        return this._model.getRequestUrl(id);
    }

    public Request getRequest(ConversationID id) {
        return this._model.getRequest(id);
    }

    public Response getResponse(ConversationID id) {
        return this._model.getResponse(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConversationListener(ConversationListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.remove(ConversationListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConversationListener(ConversationListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.add(ConversationListener.class, listener);
        }
    }

    protected void fireConversationAdded(ConversationID id, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        ConversationEvent evt = new ConversationEvent(this, id, position);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$ConversationListener == null ? AbstractConversationModel.class$("org.owasp.webscarab.model.ConversationListener") : class$org$owasp$webscarab$model$ConversationListener)) continue;
            try {
                ((ConversationListener)listeners[i + 1]).conversationAdded(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireConversationRemoved(ConversationID id, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        ConversationEvent evt = new ConversationEvent(this, id, position);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$ConversationListener == null ? AbstractConversationModel.class$("org.owasp.webscarab.model.ConversationListener") : class$org$owasp$webscarab$model$ConversationListener)) continue;
            try {
                ((ConversationListener)listeners[i + 1]).conversationRemoved(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireConversationChanged(ConversationID id, int position) {
        Object[] listeners = this._listenerList.getListenerList();
        ConversationEvent evt = new ConversationEvent(this, id, position);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$ConversationListener == null ? AbstractConversationModel.class$("org.owasp.webscarab.model.ConversationListener") : class$org$owasp$webscarab$model$ConversationListener)) continue;
            try {
                ((ConversationListener)listeners[i + 1]).conversationChanged(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireConversationsChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$ConversationListener == null ? AbstractConversationModel.class$("org.owasp.webscarab.model.ConversationListener") : class$org$owasp$webscarab$model$ConversationListener)) continue;
            try {
                ((ConversationListener)listeners[i + 1]).conversationsChanged();
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }
}

