/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.httpclient;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.owasp.webscarab.httpclient.AliasKeyManager;
import org.owasp.webscarab.util.Encoding;
import org.owasp.webscarab.util.NullComparator;

public class SSLContextManager {
    private Map _contextMaps = new TreeMap(new NullComparator());
    private SSLContext _noClientCertContext;
    private String _defaultKey = null;
    private Map _aliasPasswords = new HashMap();
    private List _keyStores = new ArrayList();
    private Map _keyStoreDescriptions = new HashMap();
    private static TrustManager[] _trustAllCerts = new TrustManager[]{new X509TrustManager(){

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public SSLContextManager() {
        try {
            this._noClientCertContext = SSLContext.getInstance("SSL");
            this._noClientCertContext.init(null, _trustAllCerts, new SecureRandom());
        }
        catch (NoSuchAlgorithmException nsao) {
            this._logger.severe("Could not get an instance of the SSL algorithm: " + nsao.getMessage());
        }
        catch (KeyManagementException kme) {
            this._logger.severe("Error initialising the SSL Context: " + kme);
        }
        try {
            this.initMSCAPI();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isProviderAvailable(String type) {
        try {
            if (type.equals("PKCS11")) {
                Class.forName("sun.security.pkcs11.SunPKCS11");
            } else if (type.equals("msks")) {
                Class.forName("se.assembla.jce.provider.ms.MSProvider");
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private int addKeyStore(KeyStore ks, String description) {
        int index = this._keyStores.indexOf(ks);
        if (index == -1) {
            this._keyStores.add(ks);
            index = this._keyStores.size() - 1;
        }
        this._keyStoreDescriptions.put(ks, description);
        return index;
    }

    public int getKeyStoreCount() {
        return this._keyStores.size();
    }

    public String getKeyStoreDescription(int keystoreIndex) {
        return (String)this._keyStoreDescriptions.get(this._keyStores.get(keystoreIndex));
    }

    public int getAliasCount(int keystoreIndex) {
        return this.getAliases((KeyStore)this._keyStores.get(keystoreIndex)).length;
    }

    public String getAliasAt(int keystoreIndex, int aliasIndex) {
        return this.getAliases((KeyStore)this._keyStores.get(keystoreIndex))[aliasIndex];
    }

    private String[] getAliases(KeyStore ks) {
        ArrayList<String> aliases = new ArrayList<String>();
        try {
            Enumeration<String> en = ks.aliases();
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (!ks.isKeyEntry(alias)) continue;
                aliases.add(alias);
            }
        }
        catch (KeyStoreException kse) {
            kse.printStackTrace();
        }
        return aliases.toArray(new String[0]);
    }

    public Certificate getCertificate(int keystoreIndex, int aliasIndex) {
        try {
            KeyStore ks = (KeyStore)this._keyStores.get(keystoreIndex);
            String alias = this.getAliasAt(keystoreIndex, aliasIndex);
            return ks.getCertificate(alias);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFingerPrint(Certificate cert) throws KeyStoreException {
        if (!(cert instanceof X509Certificate)) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        X509Certificate x509 = (X509Certificate)cert;
        try {
            String fingerprint = Encoding.hashMD5(cert.getEncoded());
            for (int i = 0; i < fingerprint.length(); i += 2) {
                buff.append(fingerprint.substring(i, i + 1)).append(":");
            }
            buff.deleteCharAt(buff.length() - 1);
        }
        catch (CertificateEncodingException e) {
            throw new KeyStoreException(e.getMessage());
        }
        String dn = x509.getSubjectDN().getName();
        this._logger.info("Fingerprint is " + buff.toString().toUpperCase());
        return buff.toString().toUpperCase() + " " + dn;
    }

    public boolean isKeyUnlocked(int keystoreIndex, int aliasIndex) {
        KeyStore ks = (KeyStore)this._keyStores.get(keystoreIndex);
        String alias = this.getAliasAt(keystoreIndex, aliasIndex);
        Map pwmap = (Map)this._aliasPasswords.get(ks);
        if (pwmap == null) {
            return false;
        }
        return pwmap.containsKey(alias);
    }

    public void setDefaultKey(String fingerprint) {
        this._defaultKey = fingerprint;
    }

    public String getDefaultKey() {
        return this._defaultKey;
    }

    private void initMSCAPI() {
        try {
            if (!this.isProviderAvailable("msks")) {
                return;
            }
            Provider mscapi = (Provider)Class.forName("se.assembla.jce.provider.ms.MSProvider").newInstance();
            Security.addProvider(mscapi);
            KeyStore ks = KeyStore.getInstance("msks", "assembla");
            ks.load(null, null);
            this.addKeyStore(ks, "Microsoft CAPI Store");
        }
        catch (Exception e) {
            System.err.println("Error instantiating the MSCAPI provider");
            e.printStackTrace();
        }
    }

    public int initPKCS11(String name, String library, String kspassword) {
        try {
            if (!this.isProviderAvailable("PKCS11")) {
                return -1;
            }
            StringBuffer cardConfig = new StringBuffer();
            cardConfig.append("name = ").append(name).append("\n");
            cardConfig.append("library = ").append(library).append("\n");
            ByteArrayInputStream is = new ByteArrayInputStream(cardConfig.toString().getBytes());
            Class<?> pkcs11Class = Class.forName("sun.security.pkcs11.SunPKCS11");
            Constructor<?> c = pkcs11Class.getConstructor(InputStream.class);
            Provider pkcs11 = (Provider)c.newInstance(is);
            Security.addProvider(pkcs11);
            KeyStore ks = KeyStore.getInstance("PKCS11");
            ks.load(null, kspassword == null ? null : kspassword.toCharArray());
            return this.addKeyStore(ks, "PKCS#11");
        }
        catch (Exception e) {
            System.err.println("Error instantiating the PKCS11 provider");
            e.printStackTrace();
            return -1;
        }
    }

    public int loadPKCS12Certificate(String filename, String ksPassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        FileInputStream is = new FileInputStream(filename);
        if (is == null) {
            throw new FileNotFoundException(filename + " could not be found");
        }
        KeyStore ks = KeyStore.getInstance("PKCS12");
        ks.load(is, ksPassword == null ? null : ksPassword.toCharArray());
        return this.addKeyStore(ks, "PKCS#12 - " + filename);
    }

    public void unlockKey(int keystoreIndex, int aliasIndex, String keyPassword) throws KeyStoreException, KeyManagementException {
        SSLContext sc;
        KeyStore ks = (KeyStore)this._keyStores.get(keystoreIndex);
        String alias = this.getAliasAt(keystoreIndex, aliasIndex);
        AliasKeyManager akm = new AliasKeyManager(ks, alias, keyPassword);
        String fingerprint = this.getFingerPrint(this.getCertificate(keystoreIndex, aliasIndex));
        if (fingerprint == null) {
            this._logger.severe("No fingerprint found");
            return;
        }
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException nsao) {
            this._logger.severe("Could not get an instance of the SSL algorithm: " + nsao.getMessage());
            return;
        }
        sc.init(new KeyManager[]{akm}, _trustAllCerts, new SecureRandom());
        String key = fingerprint;
        if (key.indexOf(" ") > 0) {
            key = key.substring(0, key.indexOf(" "));
        }
        this._contextMaps.put(key, sc);
    }

    public void invalidateSessions() {
        this.invalidateSession(this._noClientCertContext);
        Iterator it = this._contextMaps.keySet().iterator();
        while (it.hasNext()) {
            this.invalidateSession((SSLContext)this._contextMaps.get(it.next()));
        }
    }

    private void invalidateSession(SSLContext sc) {
        int timeout;
        SSLSessionContext sslsc = sc.getClientSessionContext();
        if (sslsc != null) {
            timeout = sslsc.getSessionTimeout();
            sslsc.setSessionTimeout(1);
            sslsc.setSessionTimeout(timeout);
        }
        if ((sslsc = sc.getServerSessionContext()) != null) {
            timeout = sslsc.getSessionTimeout();
            sslsc.setSessionTimeout(1);
            sslsc.setSessionTimeout(timeout);
        }
    }

    public SSLContext getSSLContext(String fingerprint) {
        this._logger.info("Requested SSLContext for " + fingerprint);
        if (fingerprint == null || fingerprint.equals("none")) {
            return this._noClientCertContext;
        }
        if (fingerprint.indexOf(" ") > 0) {
            fingerprint = fingerprint.substring(0, fingerprint.indexOf(" "));
        }
        return (SSLContext)this._contextMaps.get(fingerprint);
    }
}

