/*
 * Decompiled with CFR 0.152.
 */
package no.geosoft.cc.ui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JWindow;
import javax.swing.Timer;

public class SplashScreen
extends JWindow {
    private static final long serialVersionUID = 6755880409556259144L;
    private Image image_;
    private int x_;
    private int y_;
    private int width_;
    private int height_;

    public SplashScreen(String imageFileName) {
        super(new Frame());
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            URL imageUrl = this.getClass().getResource(imageFileName);
            this.image_ = toolkit.getImage(imageUrl);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.image_, 0);
            mediaTracker.waitForID(0);
            this.width_ = this.image_.getWidth(this);
            this.height_ = this.image_.getHeight(this);
            Dimension screenSize = toolkit.getScreenSize();
            this.x_ = (screenSize.width - this.width_) / 2;
            this.y_ = (screenSize.height - this.height_) / 2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.image_ = null;
        }
    }

    public void open(int nMilliseconds) {
        if (this.image_ == null) {
            return;
        }
        Timer timer = new Timer(Integer.MAX_VALUE, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ((Timer)event.getSource()).stop();
                SplashScreen.this.close();
            }
        });
        timer.setInitialDelay(nMilliseconds);
        timer.start();
        this.setBounds(this.x_, this.y_, this.width_, this.height_);
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public void paint(Graphics graphics) {
        if (this.image_ == null) {
            return;
        }
        graphics.drawImage(this.image_, 0, 0, this.width_, this.height_, this);
    }
}

