<?php
/**
 * Shows how the encoding callback works: it first maps a class to another, then on decoding gets the correct class and on post decoding changes a value:
 *
 * myClass => anotherClass => myClass and increment $data
 * myClass2 => myClass2 => myClass2 and in post decoding make it a string
 */
include_once("test_common.php");

class myClass
{
    var $data = 10;
    var $data2 = 20;
};

class myClass2
{
    var $dataB = "wooow";
};

// default is use of typed object with original class
function amfphp_serialize_callback($value)
{
    if(is_resource($value))
        return "";
	$className = strtolower(get_class($value));
	if($className == 'myclass')
        return array($value, AMFC_TYPEDOBJECT, "anotherClass");
}

function amfphp_unserialize_callback($event, $arg)
{
    if($event == AMFE_MAP)
    {
        echo("mapping $arg\n");
        if($arg == "anotherClass")
            return new myClass();
    }
    else if($event == AMFE_POST_OBJECT)
    {
        echo("post object of class <" . get_class($arg). ">\n");
        if(strtolower(get_class($arg)) == "myclass")
        {
            $arg->data2++;
            return $arg;
        }
        else if(strtolower(get_class($arg)) == "myclass2")
            return $arg->dataB;
        else
            return $arg;
    }
}

$a = new myClass();
$b = new myClass2();

$defaultFlags = AMF_POST_DECODE; // note not associative

test($a);
test($b);
//test(array($a,$a,&$a));
//test(array($b,$b,&$b));
?>