
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include <unistd.h>
#if defined(__DJGPP__) || defined(__MINGW32__)
#include <conio.h>
#endif
#include "zlib.h"
#include "endian.h"
#include "flasm.h"

extern FILE *yyin;
extern int strIcmp (char *s, char *t);
extern void skipBuffered(FILE *f, unsigned long int length);
int swfVersion;

char *inputName; // actual command-line parameter
char *updateName = NULL; // swf file name found in disassembly's first line (movie foo.swf...)
char *tempName = NULL; // temporary file during assembling
char *flmName = NULL; // temporary disassembly during update
char *backupName = NULL; // foo.$wf if foo.swf is updated
FILE *updateFile = NULL;
FILE *tempFile = NULL;
FILE *inputFile = NULL;
FILE *iniFile = NULL;
char swfHeader[4];
unsigned long int flength = 0;
char wasCompressed = 0;
char compressAfter = 0;
char backupCreated = 0;
int mode;

/* ini entries */
char *flaplayer, *flabrowser, *flatest, *profiler; /* profiler not used yet */
char inipath[256];
char flapath[512];

void yyerror(char *s);
void warning(char *s);
int yyparse();

void disassembleSWF(FILE *in, char *fname);
void decompressSWF (FILE *f, char *fname);
void compressSWF (FILE *f, char *fname);
char *strIstr(const char *String, const char *Pattern);
unsigned int getWord (FILE *f);
unsigned long int getDoubleWord (FILE *f);

unsigned long int defineMCLengthPos = 0;
unsigned long int buttonLengthPos = 0;
unsigned long int buttonLastOffsetPos = 0;
unsigned long int placeMCLengthPos = 0;
unsigned long int MCAllEventsPos = 0;

void waitUserInput()
{
  #if defined(__DJGPP__) || defined(__MINGW32__)
    /* make sure we have kbhit(), otherwise do nothing */
    fprintf(stderr,"Hit any key to continue..");
    while (!kbhit()) {
      #ifdef __DJGPP__
        /* cygwin/mingw don't have pause()
        it seems also no need for it there,
        since kbhit() looping doesn't hang the CPU
        djgpp executables, however, do need it */
        pause();
      #endif
    }
  #endif
}

void error(char *s, ...)
{
  va_list ap;
  if (strlen(s)>0)
  {
    va_start(ap, s);
    vfprintf(stderr, s, ap);
    va_end(ap);
    fputc('\n', stderr);
  }

  if (tempFile!=NULL) {
    fclose(tempFile);
    remove(tempName);
  }

  if (updateFile!=NULL)
    fclose(updateFile);

  if (mode != MODE_ASSEMBLE)
    waitUserInput();

  if (wasCompressed && backupCreated && updateName!=NULL && access(backupName, R_OK)==0)
  {
    remove(updateName);
    rename(backupName,updateName);
  }
  
  exit(-1);
}

unsigned long int len;
unsigned char *output;
int nLabels;

struct label
{
  char *name;
  int offset;
  int final; /* 1 if actual label definition, 0 if predefinition from branch */
};

struct label labels[MAX_LABELS];

int findLabel(char *label)
{
  int i;

  for(i=0; i<nLabels; ++i)
  {
    if(strcmp(label, labels[i].name) == 0)
      return i;
  }

  return -1;
}

void addLabel(char *label)
{
  int i = findLabel(label);

  if(i == -1)
  {
    labels[nLabels].name = strdup(label);
    labels[nLabels].offset = len;
    labels[nLabels].final = 1;
    ++nLabels;
    if(nLabels>MAX_LABELS-2)
      yyerror("Too many labels");
  }
  else
  {
    if (labels[i].final == 0)
    {
      /* write actual offset */
      labels[i].offset = len;
      labels[i].final = 1;
    }
    else
      yyerror("Label defined twice");
  }
}

void addLabelFromBranch(char *label)
{
  /* branch to the label which is not defined yet - predefine */
  labels[nLabels].name = strdup(label);
  labels[nLabels].offset = len;
  labels[nLabels].final = 0;
  ++nLabels;
  if(nLabels>MAX_LABELS-2)
    yyerror("Too many labels");
}

#define OUTPUT_INCREMENT 1024

int writeByte(unsigned char num)
{
  if(len % OUTPUT_INCREMENT == 0)
    output = realloc(output, len+OUTPUT_INCREMENT);

  output[len] = num & 0xff;
  ++len;

  return 1;
}

int writeShort(unsigned int num)
{
  writeByte(num & 0xff);
  writeByte((num>>8) & 0xff);

  return 2;
}

int writeFloat(float num)
{
  unsigned char *p = (unsigned char *)&num;

  if(byteorder == FLASM_BIG_ENDIAN)
  {
    writeByte(p[3]);
    writeByte(p[2]);
    writeByte(p[1]);
    writeByte(p[0]);
  }
  else
  {
    writeByte(p[0]);
    writeByte(p[1]);
    writeByte(p[2]);
    writeByte(p[3]);
  }

  return 4;
}

int writeDouble(double num)
{
  unsigned char *p = (unsigned char *)&num;

  if(byteorder == FLASM_BIG_ENDIAN)
  {
    writeByte(p[3]);
    writeByte(p[2]);
    writeByte(p[1]);
    writeByte(p[0]);
    writeByte(p[7]);
    writeByte(p[6]);
    writeByte(p[5]);
    writeByte(p[4]);
  }
  else
  {
    writeByte(p[4]);
    writeByte(p[5]);
    writeByte(p[6]);
    writeByte(p[7]);
    writeByte(p[0]);
    writeByte(p[1]);
    writeByte(p[2]);
    writeByte(p[3]);
  }

  return 8;
}

int writeInt(int num)
{
  unsigned char *p = (unsigned char *)&num;

  if(byteorder == FLASM_BIG_ENDIAN)
  {
    writeByte(p[3]);
    writeByte(p[2]);
    writeByte(p[1]);
    writeByte(p[0]);
  }
  else
  {
    writeByte(p[0]);
    writeByte(p[1]);
    writeByte(p[2]);
    writeByte(p[3]);
  }

  return 4;
}

int writeString(char *str)
{
  int i;

  for(i=0; str[i]!=0; ++i)
    writeByte(str[i]);

  writeByte(0);

  return i+1;
}

int xtoi(char *p)
{
  int num = 0;
  char c;

  while((c = tolower(*p)) != '\0')
  {
    num <<= 4;

    if(isdigit(c))
      num += c - '0';
    else if(c >= 'a' && c <= 'f')
      num += c - 'a' + 10;
    else
      return 0;

    ++p;
  }

  return num;
}


int nConstants = 0;
char *constants[MAX_CONSTANTS];

void addConstant(char *str)
{
  constants[nConstants] = strdup(str);
  ++nConstants;

  if (nConstants>MAX_CONSTANTS)
    yyerror("Too many constants");
}

unsigned int writeConstants()
{
  int i;
  unsigned long int len = 2;

  writeByte(SWFACTION_CONSTANTPOOL);
  writeShort(0); /* length */
  writeShort(nConstants);

  for(i=0; i<nConstants; ++i)
    len += writeString(constants[i]);

  if (len<65533)
    patchLength((unsigned int)len);
  else
    error("Constant pool exceeds 64k");

  return (unsigned int)len+3;
}

unsigned int writePushString(char *str)
{
  int i;

  for(i=0; i<nConstants; ++i)
  {
    if(strcmp(constants[i], str) == 0)
      break;
  }

  if(i<nConstants)
  {
    if (i<256)
    { /* constant, 1-byte reference */
      writeByte(0x08);
      writeByte(i);
      return 2;
    }
    else
    { /* constant, 2-byte reference */
      writeByte(0x09);
      writeShort(i);
      return 3;
    }
  }
  
  /* string */
  writeByte(0);
  return writeString(str)+1;
}

int branchTarget(char *label)
{
  int i = findLabel(label);

  if(i == -1)
  {
    i = nLabels;
    addLabelFromBranch(label);
  }

  return writeShort(i);
}

int addNumLabel(int numLabel)
{
  /* numerical offset given in a branch */
  int i = nLabels;
  labels[i].name = NULL;
  labels[i].offset = len+numLabel+2;
  labels[i].final = 1;
  ++nLabels;
  if(nLabels>MAX_LABELS-2)
    yyerror("Too many labels");

  return writeShort(i);
}

static void patchTargets()
{
  int l, i=0;

  while(i<len)
  {
    if(output[i] & 0x80) /* then it's a multibyte instruction */
    {
      if(output[i] == SWFACTION_BRANCHALWAYS || output[i] == SWFACTION_BRANCHIFTRUE)
      {
        int target, offset;

        i += 3; /* plus instruction plus two-byte length */

        target = output[i]+(output[i+1]<<8);
                
        if (labels[target].offset == i)
          yyerror(strcat("Label not found: ",labels[target].name));
        /* does it work? or schould create buffer? weird! */
                
        offset = labels[target].offset - (i+2);
        output[i] = offset & 0xff;
        output[++i] = (offset>>8) & 0xff;
        ++i;
      }
      else
      {
        ++i;
        l = output[i];
        ++i;
        l += output[i]<<8;
        i += l+1;
      }
    }
    else
      ++i;
  }
}

int flput(int b)
{ 
  ++flength;
  return fputc(b,tempFile);
}

int dupByte() 
{ 
  int b;
  b = fgetc(updateFile);
  flput(b);
  return (unsigned char)b;
}

unsigned int dupWord() {
  int b1, b2;
  b1 = fgetc(updateFile);
  flput(b1);
  b2 = fgetc(updateFile);
  flput(b2);
  return ((unsigned int)b1+((unsigned int)b2<<8));
}

unsigned int dupDoubleWord() {
  return ((unsigned long int)dupWord(updateFile)+((unsigned long int)dupWord(updateFile)<<16));
}

void dupBuffered(unsigned long int length) {
  unsigned char dupBuffer[MAX_BUFFER];

  flength += length;

  while(length>MAX_BUFFER)
    length -= fwrite(dupBuffer, 1, fread(dupBuffer, 1, MAX_BUFFER, updateFile), tempFile);

  if (length <= 0)
    return;

  fwrite(dupBuffer, 1, fread(dupBuffer, 1, (unsigned int)length, updateFile), tempFile);
}

void patchLength(unsigned int back)
{
  output[len-back-1] = (back>>8) & 0xff;
  output[len-back-2] = back & 0xff;
}

void patchFrameLoaded(unsigned int back, int numActions)
{
  output[len-back-1] = numActions;
}

void updateTmpLength(unsigned long int lenpos, unsigned long int reallen)
{
  unsigned long int curpos;
  curpos = ftell(tempFile);

  fseek(tempFile,lenpos,SEEK_SET);

  /* update long(!) length */
  /* dont use flput to not affect the file size calculation */
  fputc(reallen & 0xff,tempFile);
  fputc((reallen>>8) & 0xff,tempFile);
  fputc((reallen>>16) & 0xff,tempFile);
  fputc((reallen>>24) & 0xff,tempFile);

  fseek(tempFile,curpos,SEEK_SET);
}

void updateShort(unsigned long int lenpos, unsigned int w)
{
  unsigned long int curpos = ftell(tempFile);

  fseek(tempFile,lenpos,SEEK_SET);

  /* update short */
  fputc(w & 0xff,tempFile);
  fputc((w>>8) & 0xff,tempFile);

  fseek(tempFile,curpos,SEEK_SET);
}

void flushOutput()
{
  patchTargets();

  if (fwrite(output, 1, len, tempFile)!=len)
    error("Error writing action block");

  flength +=len;

  len = 0;
  nLabels = 0;
  nConstants = 0;
}

void writeTagHeader (int type, unsigned long int length)
{
  unsigned int tagHeader;

  if (length>=63 || type==36 || type == 20) {
      /* long length, and also workaround for a really strange bug
         in flash player - it expects DefineBitsLosless/DefineBitsLosless2
	 to always have long length */
      tagHeader = (type<<6) + 63;
      flput(tagHeader & 0xff);
      flput((tagHeader>>8) & 0xff);
      flput(length & 0xff);
      flput((length>>8) & 0xff);
      flput((length>>16) & 0xff);
      flput((length>>24) & 0xff);
  } else {
      /* short length */
      tagHeader = (type<<6) + length;
      flput(tagHeader & 0xff);
      flput((tagHeader>>8) & 0xff);
  }
}

unsigned long int findNextBlock(int typeneeded)
{
  /* dumps all blocks of the updateFile to the tempFile
     until required block found, returns its length */

  while(!feof(updateFile))
  { 
    unsigned int type, tagHeader;
    unsigned long int length;

    tagHeader = getWord(updateFile);
    type = tagHeader >> 6;

    if (type > 1023)
      error("Couldn't update because of unexpected swf structure");

    length = tagHeader & ((1<<6)-1);

    if (length == 63)
      length = getDoubleWord(updateFile);

    if (type == typeneeded)
      return length;

    if ((type == TAG_PROTECT)||(type == TAG_ENABLEDEBUGGER)||(type == TAG_ENABLEDEBUGGER2)) {
      /* skip protect and enableDebugger */
      skipBuffered(updateFile, length);
    }
    else {
      /* dump others */
      writeTagHeader(type,length);
      dupBuffered(length);
    }
  }
  error("Couldn't update because of unexpected swf structure");
  return(-1);
}

void writeDoAction()
{
  unsigned long int oldLength = findNextBlock(TAG_DOACTION);

  /* skip old action */
  skipBuffered(updateFile, oldLength);

  writeTagHeader(TAG_DOACTION,len);

  /* write bison output from buffer to file and empty buffer */
  flushOutput();
}

void writeInitMC(int clipID)
{
  int givenID;
  unsigned long int oldLength = findNextBlock(TAG_INITMOVIECLIP);

  writeTagHeader(TAG_INITMOVIECLIP,len+2);

  givenID = dupWord();
  if (givenID!=clipID) error("Couldn't update because of unexpected swf structure:\ninitMovieClip ID doesn't match");

  skipBuffered(updateFile, oldLength-2);

  flushOutput();
}

signed int bitPos;
unsigned int bitBuf,temp;

int dupBits (unsigned int n)
{
  unsigned long int v = 0;

  while (1)
  {
    int s = n - bitPos;

    if (s > 0)
    {
      v |= bitBuf << s;
      n -= bitPos;
      bitBuf = dupByte();
      bitPos = 8;
    }
    else
    {
      v |= bitBuf >> -s;
      bitPos -= n;
      bitBuf &= 0xff >> (8 - bitPos);
      return v;
    }
  }
}

void dupMatrix()
{
  bitPos = 8;
  bitBuf = (unsigned int)dupByte();
   
  if (dupBits(1)) dupBits(dupBits(5)*2);
  if (dupBits(1)) dupBits(dupBits(5)*2);
  dupBits(dupBits(5)*2);
}

void dupColorTransform() 
{
  unsigned int needAdd,needMul,nBits;

  bitPos = 8;
  bitBuf = (unsigned int)dupByte();

  needAdd = dupBits(1);
  needMul = dupBits(1);
  nBits = dupBits(4);
  if (needMul) dupBits(nBits*4);
  if (needAdd) dupBits(nBits*4);
}

void writePlaceMCStart(int clipID)
{ 
  int givenID, flags;
  unsigned long int i, length, curEvent, eventLength;

  /* skip all mcs without onClipEvent actions */ 
  while (!feof(updateFile)) {
    length = findNextBlock(TAG_PLACEOBJECT2);
    flags = fgetc(updateFile);

    if (flags & splaceOnClipEvents)
      break;

    writeTagHeader(TAG_PLACEOBJECT2,length);
    flput(flags);

    /* copy the rest of the placeobject2 */
    dupBuffered(length-1);
  }

  /* placemc header, temporary long length, save length pos */
  writeTagHeader(TAG_PLACEOBJECT2,0xFF);
  placeMCLengthPos = ftell(tempFile)-4; 

  flput(flags);
  
  /* character depth */
  dupWord();
  
  if (flags & splaceCharacter) givenID = dupWord();
  if (givenID!=clipID) error("Couldn't update because of unexpected swf structure");
  
  if (flags & splaceMatrix) dupMatrix();
  if (flags & splaceColorTransform) dupColorTransform();
  if (flags & splaceRatio) dupWord();
  if (flags & splaceName) while ((i=dupByte())!=0);

  dupWord(); // dump ?? - always 0?

  /* save the pos for logical or of all events */
  MCAllEventsPos = ftell(tempFile);

  /* skip old events */
  if (swfVersion == 5) {
    /* dup logical or of all events - temporary */
    dupWord();
    while (getWord(updateFile)>0) {
      eventLength = getDoubleWord(updateFile);
      skipBuffered(updateFile, eventLength);
    }
  } else if (swfVersion == 6) {
    /* dup logical or of all events - temporary */
    dupDoubleWord(updateFile);
    while ((curEvent = getDoubleWord(updateFile))!=0) {
      eventLength = getDoubleWord(updateFile);
      skipBuffered(updateFile, eventLength);
    }
  }
}

void writePlaceMCEnd(unsigned long int flags)
{ /* zero event */
  flput(0);
  flput(0);
  if(swfVersion>=6) {
    flput(0);
    flput(0);
  }

  updateTmpLength(placeMCLengthPos,ftell(tempFile)-placeMCLengthPos-4);

  if (swfVersion==5)
    updateShort(MCAllEventsPos,(unsigned int)flags);
  else if (swfVersion>=6) {
    updateShort(MCAllEventsPos,(unsigned int)(flags&0xFFFF));
    updateShort(MCAllEventsPos+2,(unsigned int)((flags>>16)&0xFFFF));
  }

  placeMCLengthPos = 0;
  MCAllEventsPos = 0;
}

void writeOnClipEvent(unsigned long int flag)
{
  /* write event flag */
  flput(flag & 0xff);
  flput((flag>>8) & 0xff);
  if(swfVersion>=6) {
    flput((flag>>16) & 0xff);
    flput((flag>>24) & 0xff);
  }

  /* write action length */
  flput(len & 0xff);
  flput((len>>8) & 0xff);
  flput((len>>16) & 0xff);
  flput((len>>24) & 0xff);

  flushOutput();
}

void writeButtonStart(int buttonID)
{
  int givenID, trackAsMenu;
  unsigned int actionOffset;
  unsigned long int length;

  /* skip all buttons without actions */ 
  while (!feof(updateFile)) {
    length = findNextBlock(TAG_DEFINEBUTTON2);
    givenID = getWord(updateFile);
    trackAsMenu = fgetc(updateFile);
    actionOffset = getWord(updateFile);

    if (actionOffset>0)
      break;

    writeTagHeader(TAG_DEFINEBUTTON2,length);
    flput(givenID & 0xff);
    flput((givenID>>8) & 0xff);
    flput(trackAsMenu);
    /* put action offset = 0 */
    flput(0);
    flput(0);
    /* copy the rest of the button */
    dupBuffered(length-5);
  }

  if (givenID!=buttonID) error("Couldn't update because of unexpected swf structure");
  
  /* defineButton2 header, temporary long length, save length pos */
  writeTagHeader(TAG_DEFINEBUTTON2,0xFF);
  buttonLengthPos = ftell(tempFile)-4; 

  flput(givenID & 0xff);
  flput((givenID>>8) & 0xff);
  flput(trackAsMenu);
  flput(actionOffset & 0xff);
  flput((actionOffset>>8) & 0xff); 
  
  /* copy button visual part */
  dupBuffered(actionOffset-2);

  /* skip old button actions part */
  skipBuffered(updateFile, length-3-actionOffset);
}

void writeButtonEnd()
{      
  updateTmpLength(buttonLengthPos,ftell(tempFile)-buttonLengthPos-4);

  /* last offset is always 0 */
  updateShort(buttonLastOffsetPos,0);

  buttonLengthPos = 0;
  buttonLastOffsetPos = 0;
}

void writeButtonEvent(unsigned int flags)
{
  /* write offset to the next condition */
  buttonLastOffsetPos = ftell(tempFile);
  flput((len+4) & 0xff);
  flput(((len+4)>>8) & 0xff);

  /* write button event flags */
  flput(flags & 0xff);
  flput((flags>>8) & 0xff);

  flushOutput();
}

void writeDefineMCStart(int clipID)
{
  int givenID;

  findNextBlock(TAG_DEFINEMOVIECLIP);

  /* defineMovieClip header, temporary long length, save length pos */
  writeTagHeader(TAG_DEFINEMOVIECLIP,0xFF);
  defineMCLengthPos = ftell(tempFile)-4;

  givenID = dupWord();
  if (givenID!=clipID) error("Couldn't update because of unexpected swf structure");
  dupWord(); /* frames total */
}

void writeDefineMCEnd()
{
  /* dump the rest of movie clip */
  findNextBlock(TAG_END);

  /* write movie clip end tag */
  flput(0);
  flput(0);

  updateTmpLength(defineMCLengthPos,ftell(tempFile)-defineMCLengthPos-4);

  defineMCLengthPos = 0;
}

void writeProtect(char *str)
{
  if (strlen(str) == 0) {
    /* no password */
    writeTagHeader(TAG_PROTECT,0);
  }
  else {
    /* password found */
    int i;
    writeTagHeader(TAG_PROTECT, strlen(str)+3);
    flput(0);
    flput(0);
    for(i=0; str[i]!=0; ++i)
      flput(str[i]);
    flput(0);
  }
}

void writeEnableDebugger(char *str)
{
  if (strlen(str) == 0) {
    /* no password, probably not possible? */
    writeTagHeader(TAG_ENABLEDEBUGGER,0);
  }
  else {
    /* password found */
    int i;
    writeTagHeader(TAG_ENABLEDEBUGGER, strlen(str)+3);
    flput(0);
    flput(0);
    for(i=0; str[i]!=0; ++i)
      flput(str[i]);
    flput(0);
  }
}

void writeEnableDebugger2(char *str)
{
  if (strlen(str) == 0) {
    /* no password, probably not possible? */
    writeTagHeader(TAG_ENABLEDEBUGGER2,0);
  }
  else {
    /* password found */
    int i;
    writeTagHeader(TAG_ENABLEDEBUGGER2, strlen(str)+3);
    flput(0);
    flput(0);
    for(i=0; str[i]!=0; ++i)
      flput(str[i]);
    flput(0);
  }
}

void finalizeTemporaryFile (char *name)
{
  fclose(tempFile); 
  if (!backupCreated)
  {
    backupName = strdup(name);
    backupCreated = 1;
    strcpy(backupName+strlen(backupName)-4, ".$wf");
    remove(backupName);
    rename(name,backupName); // foo.swf -> foo.$wf
    rename(tempName,name);  // foo.tmp (assemble) or flasm.tmp (compress/decompress) -> foo.swf
  }
  else
  {
    // backup already here, just make temp file our final file
    remove(name);
    rename(tempName,name);
  }
}

void getSWFHeader (FILE *f)
{
  swfHeader[0] = fgetc(f);
  swfHeader[1] = fgetc(f);
  swfHeader[2] = fgetc(f);
  swfHeader[3] = 0;
}

void finishUpdate()
{
  /* dump the rest of swf */
  // while((b = fgetc(updateFile)) != EOF) flput(b);
  findNextBlock(0);
  /* write movie end */
  flput(0);
  flput(0);

  updateTmpLength(4,flength);

  fclose(updateFile);

  finalizeTemporaryFile (updateName);

  if (compressAfter)
  {
    updateFile = fopen(updateName, "rb");
    getSWFHeader(updateFile);
    compressSWF(updateFile, updateName);
  }

  if (mode < MODE_IDE)
    fprintf(stderr,"%s succesfully updated, %li bytes!\n",updateName,flength);
}

void startUpdate(char *outputName)
{
  int b,i,bitstotal;

  if((updateFile = fopen(outputName, "rb")) == NULL)
    error("Couldn't open file %s for update", outputName);

  getSWFHeader(updateFile);

  if (strcmp(swfHeader, "FWS") != 0)
  {
    if (strcmp(swfHeader, "CWS") == 0) {
       decompressSWF(updateFile, outputName); // decompresses foo.swf, foo.$wf backup is created
       updateFile = fopen(outputName, "rb");
       getSWFHeader(updateFile); // now we are just after the header in decompressed file
    }
    else
       error("Input file %s doesn't appear to be an SWF file",outputName);
  }

  flength = 0;

  updateName = strdup(outputName);
  tempName = strdup(outputName);
  strcpy(tempName+strlen(tempName)-4, ".tmp");

  if((tempFile = fopen(tempName, "wb")) == NULL)
    error("Couldn't create temporary file!");
 
  /* swf header */
  flput('F');
  flput('W');
  flput('S');

  /* version */
  flput(swfVersion = fgetc(updateFile));

  /* file length - temporary! */
  flput(fgetc(updateFile));
  flput(fgetc(updateFile));
  flput(fgetc(updateFile));
  flput(fgetc(updateFile));

  /* movie bounds */
  b = fgetc(updateFile);
  bitstotal = 5 + 4*((b & 0xf8) >> 3);
  flput(b);
  for(i=0; i<(bitstotal+7)/8 - 1; ++i)
    flput(fgetc(updateFile));

  /* frame rate and # of frames */
  flput(fgetc(updateFile));
  flput(fgetc(updateFile));
  flput(fgetc(updateFile));
  flput(fgetc(updateFile));
}

void createTemporaryFile ()
{
  tempName = strdup("flasm.tmp");
  if((tempFile = fopen(tempName, "wb+")) == NULL)
    error("Couldn't create file: %s", tempName);
}

void decompressSWF (FILE *f, char *fname)
{
  z_stream stream;
  unsigned char inputBuffer[MAX_BUFFER];
  unsigned char outputBuffer[MAX_BUFFER];
  int status, count;

  flength = 0; 
  createTemporaryFile();

  /* swf header */
  flput('F');
  flput('W');
  flput('S');

  /* version */
  flput(fgetc(f));

  flput(fgetc(f));
  flput(fgetc(f));
  flput(fgetc(f));
  flput(fgetc(f));

  stream.avail_in = 0;
  stream.next_in = inputBuffer;
  stream.next_out = outputBuffer;
  stream.zalloc = Z_NULL;
  stream.zfree = Z_NULL;
  stream.opaque = (voidpf)0;
  stream.avail_out = sizeof(outputBuffer);
  
  status = inflateInit(&stream);
  if (status != Z_OK)
    error("Zlib error: %s\n", stream.msg);

  do {
    if (stream.avail_in == 0) {
      stream.next_in = inputBuffer;
      stream.avail_in = fread(inputBuffer, 1, sizeof(inputBuffer), f);
    }

    if (stream.avail_in == 0)
      break;

    status = inflate(&stream, Z_SYNC_FLUSH);

    count = sizeof(outputBuffer) - stream.avail_out;
    if (count) {
      fwrite(outputBuffer, 1, count, tempFile);
      flength += count;
    }

    stream.next_out = outputBuffer;
    stream.avail_out = sizeof(outputBuffer);
  } while (status == Z_OK);

  if (status != Z_STREAM_END)
    error("Zlib error: %s\n", stream.msg);

  inflateEnd(&stream);

  fclose(f);

  if (mode != MODE_DISASSEMBLE)
    finalizeTemporaryFile(fname);

  if (mode == MODE_DECOMPRESS)
    fprintf(stderr,"%s succesfully decompressed, %li bytes!\n",fname,flength);

  wasCompressed = 1;
}

void compressSWF (FILE *f, char *fname)
{
  z_stream stream;
  unsigned char inputBuffer[MAX_BUFFER];
  unsigned char outputBuffer[MAX_BUFFER];
  int status, count;
// fread(inputBuffer, 1, sizeof(inputBuffer), f);

  flength = 0;
  createTemporaryFile();

  /* swf header */
  flput('C');
  flput('W');
  flput('S');

  /* version */
  flput(fgetc(f));

  flput(fgetc(f));
  flput(fgetc(f));
  flput(fgetc(f));
  flput(fgetc(f));

  stream.avail_in = 0;
  stream.next_out = outputBuffer;
  stream.avail_out = sizeof(outputBuffer);
  stream.zalloc = (alloc_func)0;
  stream.zfree = (free_func)0;
  stream.opaque = (voidpf)0;
  stream.next_in = inputBuffer;

  status = deflateInit(&stream, Z_BEST_COMPRESSION);

  if (status != Z_OK)
    error("Zlib error: %s\n", stream.msg);

  while (1) {
    if (stream.avail_in == 0) {
      stream.next_in = inputBuffer;
      stream.avail_in = fread(inputBuffer, 1, sizeof(inputBuffer), f);
    }

    if (stream.avail_in == 0)
      break;

    status = deflate(&stream, Z_NO_FLUSH);
    if (status != Z_OK)
      error("Zlib error: %s\n", stream.msg);
  
    count = sizeof(outputBuffer) - stream.avail_out;
    if (count) {
      fwrite(outputBuffer, 1, count, tempFile);
      flength += count;
    }

    stream.next_out = outputBuffer;
    stream.avail_out = sizeof(outputBuffer);
  }

  stream.next_out = outputBuffer;
  stream.avail_out = sizeof(outputBuffer);

  do
  {
    status = deflate(&stream, Z_FINISH);
  
    count = sizeof(outputBuffer) - stream.avail_out;
    if (count) {
      fwrite(outputBuffer, 1, count, tempFile);
      flength += count;
    }

    stream.next_out = outputBuffer;
    stream.avail_out = sizeof(outputBuffer);
  } while (status == Z_OK);

  if (status != Z_STREAM_END)
    error("Zlib error: %s\n", stream.msg);

  status = deflateEnd(&stream);
  if (status != Z_OK)
    error("Zlib error: %d\n", stream.msg);

  fclose(f);

  finalizeTemporaryFile(fname);

  if (mode == MODE_COMPRESS)
    fprintf(stderr,"%s succesfully compressed, %li bytes!\n",fname,flength);

}

extern int yydebug;

void usage()
{
  puts("");
  printf("flasm 1.42 build %s\n",__DATE__);
  puts("");
  puts("(c) 2001-2002 Opaque Industries and Igor Kogan");
  puts("");
  puts("Usage: flasm [command] filename");
  puts("");
  puts("Commands:");
  puts("   -d     Disassemble the given SWF file to the console");
  puts("   -a     Assemble the given flasm project");
  puts("   -u     Update SWF, replace flasm macros");
  puts("   -z     Compress SWF with Zlib");
  puts("   -x     Decompress SWF");
  /* current obfuscation is not really protecting from AS viewer, so drop it
     till better times
    puts("   -o     Like -u, but also obfuscate the swf");
  */
  puts(""); 
  puts("Backups are created for altered swf files with $wf extension");
  puts("");
  puts("To save the disassembly to file, redirect it:");
  puts("flasm -d foo.swf > foo.flm");
  puts("");
  puts("Read flasm.html for more information");

  exit(1);
}

void unescapePath(char *argument)
{ 
  int n = 0;
  char esc[3];
  int slen = strlen(argument);
  char *s = argument;

  inputName = malloc(slen+1);

  while ((inputName[n] = *s++)!=0)
  { 
    if ((inputName[n] == '.') && (*s == 'h') && (*(s+1) == 't') && (*(s+2) == 'm'))
      /* extension found */
      break;

    if (inputName[n] == '%')
    { /* unescape URL encoded char */
      esc[0] = *s++;
      esc[1] = *s++;
      esc[2] = 0;

      inputName[n] = (char)(xtoi(esc));
    }
    n++;
  } 

  inputName[n] = 0;
  strcat(inputName, ".swf");
}

void readINI(FILE *fp, char *names, char *types, ...)
{
  /* slightly changed INITVARS from SNIPPETS collection
     public domain by Raymond Gardner, Sept. 1991 */

  char ln[256];
  char *p;
  va_list arglist;
  char *namep, *typep, name[40], *e;
  void *argp;
  int k;

  while (fgets(ln, 256, fp)) {		/* read ini file */
    while (isspace(ln[0]))		/* drop leading whitespace */
      memmove(ln, ln+1, strlen(ln));
    if (ln[0] == 0)			/* skip if blank line */
      continue;

    p = strchr(ln, '=');		/* find equal sign */
    if (p == NULL)			/* error if none */
      error("Error parsing flasm.ini: %s", ln);

    while (p>ln && isspace(p[-1])) {	/* remove whitespace before eq sign */
      memmove(p-1, p, strlen(p-1));    
      --p;
    }
    *p++ = 0;				/* plug EOS over eq sign */

    while (isspace(p[0]) )		/* remove leading space on init string */
      memmove(p, p+1, strlen(p));

    k = strlen(p)-1;			/* init string length */
    if (k<0)
      error("Error parsing flasm.ini: %s", ln);

    if (p[k] == '\n')			
      p[k] = 0;				/* plug EOS over newline */
    else if (feof(fp))			/* '\n' is missing - last line or buffer exceeded? */
      p[k+1] = 0;				
    else
      error("Line too long in flasm.ini: %s", ln); 

    va_start(arglist, types);		/* setup for arglist search */

    namep = names;			/* init ptr to var names */
    typep = types;			/* init ptr to var types */

    while (*namep == ' ')		/* skip blanks before namelist */
      ++namep;

    while (*typep) {			/* while any typelist items left...*/
      argp = (void *)va_arg(arglist, void *); /* get var arg */

      k = strcspn(namep, " ");		/* length of namelist entry */
      memmove(name, namep, k);		/* put into name hold area */
      name[k] = 0;			/* terminate it */
      if (strIcmp(name, ln) != 0) {	/* if it doesn't match... */
        namep += k;			/* get next name */
        while (*namep == ' ')
          ++namep;
        ++typep;			/* get next type */
      }
      else {				/* else name is found... */
        if (*typep == 'i') {		/* if it's an int, init it */
          *(int *)argp = atoi(p);
        }
	else if ( *typep == 's' || *typep == 'p' ) {
          if ( *p == '"' ) {		/* is string in quotes? */
            ++p;			/* skip leading quote, and */
            e = strchr(p, '"');		/* look for trailing quote */
            if (e)			/* terminate string if found */
              *e = 0;
          }
          if (*typep == 'p') {		/* if it's a char *ptr */
            e = malloc(strlen(p) + 1);	/* get space */
            if (e == 0)		
              error("Not enough memory to read flasm.ini");
            *(char **)argp = e;
            strcpy(*(char **)argp, p);  /* copy in string */
          }
	  else				/* must be char array */
            strcpy(argp, p);		/* copy in string */
        }
	else
          error("Contact developer: bad argument type in readINI() call");

        break;				/* break search; get next line */
      }
    }
    va_end(arglist);
  }
}

void parseArgs(int argc, char *argv[])
{
  if (argv[1]==NULL) usage();

  if ((strstr(argv[1],".htm") != NULL) || (strstr(argv[1],"http://") != NULL))
  { 
    char *p;
    mode = MODE_IDE;

    /* read ini file - currently only needed in embed mode */
    strcpy(inipath, argv[0]);
    p = inipath+strlen(inipath);
    while (*p!='\\' && *p!='/' && *p!= ':')
      --p;
    strcpy(p+1, "flasm.ini");
    if((iniFile = fopen(inipath, "r")) == NULL)
      error("%s is missing",inipath);
    /* readINI(iniFile, "flabrowser flaplayer flatest profiler", "pppp", &flabrowser, &flaplayer, &flatest, &profiler); */
    readINI(iniFile, "flabrowser flaplayer flatest", "pppp", &flabrowser, &flaplayer, &flatest);
    fclose(iniFile);
    
    /*
    if (strIstr(profiler,"YES") != NULL)
      mode = MODE_PROFILE;
    */

    if ((strIstr(argv[1],"ContextHelp") != NULL) || (strIstr(argv[1],"http://") != NULL))
    {
      /* an attempt to access flash help */
      mode = MODE_FLASH_HELP;
      
      if (strlen(flabrowser) == 0)
	error("You must define 'flabrowser' value in flasm.ini to access flash help");
      
      if (access(flabrowser,X_OK)!=0)
        error("Couldn't start browser: %s", flabrowser);

      strcpy(flapath, flabrowser);
      strcat(flapath, " ");
      strcat(flapath, argv[1]);

      return;
    }

    if (strIstr(flatest,"FLAPLAYER") != NULL)
      strcpy(flapath, flaplayer);
    else if (strIstr(flatest,"FLABROWSER") != NULL)
      strcpy(flapath, flabrowser);
    else
      error("Invalid or missing 'flatest' value in flasm.ini");
      
    if (strlen(flapath) == 0)
      error("You must define '%s' value in flasm.ini for debugging", flatest);

    if (access(flapath,X_OK)!=0)
      error("Couldn't start: %s", flapath);

    if (strstr(argv[1],"file:///") != NULL)
      unescapePath(argv[1]+8); /* +8: skip "file:///" */
    else
      unescapePath(argv[1]);

    if((inputFile = fopen(inputName, "rb")) == NULL)
      error("Couldn't open input file %s for reading", inputName);

    strcat(flapath, " ");
    strcat(flapath, argv[1]);

    if (strIstr(flatest,"FLAPLAYER")!=NULL)
      strcpy(strstr(flapath,".htm"), ".swf\0");

    return;
  }

  if(argv[1][0] == '-')
  {
    int i;
    if (argc<3) usage();
    inputName = malloc(256);
    inputName = argv[2];

    /* join all arguments into one string - to support spaces in file names */
    for (i=3; i<argc; i++ ) {
      strcat(inputName, " ");
      strcat(inputName, argv[i]);
    }

    switch(argv[1][1])
    {
      case 'd':
        mode = MODE_DISASSEMBLE;
        break;

      case 'a':
        mode = MODE_ASSEMBLE;
        break;

      case 'u':
        mode = MODE_UPDATE;
        break;

      case 'x':
        mode = MODE_DECOMPRESS;
        break;

      case 'z':
        mode = MODE_COMPRESS;
        break;

/*
      case 'o':
        mode = MODE_OBFUSCATE;
        break;
*/
      default:
        usage();
    }
  }
  else
  {
    int i;
    inputName = malloc(256);
    inputName = argv[1];

    /* join all arguments into one string - to support spaces in file names */
    for (i=2; i<argc; i++ ) {
      strcat(inputName, " ");
      strcat(inputName, argv[i]);
    }
    
    if (strIstr(inputName, ".swf") != NULL) {
      char *flmName = strdup(inputName);
      strcpy(strIstr(flmName, ".swf"), ".flm");
      freopen(flmName, "wb", stdout); // redirect stdout to inputName.flm
      mode = MODE_DISASSEMBLE;
      /* should close it later? */
    }
    else usage();
  }

  if (inputName == NULL) usage();

  if((inputFile = fopen(inputName, "rb")) == NULL)
    error("Couldn't open input file %s for reading", inputName);
}

int main(int argc, char *argv[])
{
  yydebug = 0;

  checkByteOrder();

  parseArgs(argc, argv);

  if (mode == MODE_DISASSEMBLE)
  {
    getSWFHeader(inputFile);
    if (strcmp(swfHeader, "FWS") != 0)
    {
      if (strcmp(swfHeader, "CWS") == 0)
      {
         decompressSWF(inputFile, inputName);
	 fseek(tempFile,3,SEEK_SET); // skip SWF header, we know it's 'FWS'
         disassembleSWF(tempFile,inputName);
	 remove(tempName);
      }
      else
         error("Input file doesn't appear to be an SWF file..");
    }
    else
      disassembleSWF(inputFile,inputName);

    exit(0);
  }

  if (mode == MODE_DECOMPRESS)
  {
    getSWFHeader(inputFile);
    if (strcmp(swfHeader, "CWS") != 0)
    {
      if (strcmp(swfHeader, "FWS") == 0)
         error("Know what, the SWF isn't compressed!");
      else
         error("Input file doesn't appear to be an SWF file..");
    }
    decompressSWF(inputFile, inputName);
    exit(0);
  }

  if (mode == MODE_COMPRESS)
  {
    getSWFHeader(inputFile);
    if (strcmp(swfHeader, "FWS") != 0)
    {
      if (strcmp(swfHeader, "CWS") == 0)
         error("Know what, the SWF is already compressed!");
      else
         error("Input file doesn't appear to be an SWF file..");
    }
    compressSWF(inputFile, inputName);
    exit(0);
  }

  if (mode == MODE_ASSEMBLE)
  {
    yyin = inputFile;
    yyparse();
    fclose(inputFile);
    exit(0);
  }

  if ((mode >= MODE_UPDATE) && (mode != MODE_FLASH_HELP))
  {
    FILE *stdoutTempFile;
    getSWFHeader(inputFile);

    if (strcmp(swfHeader, "FWS") != 0)
    {
      if (strcmp(swfHeader, "CWS") == 0)
      {
         decompressSWF(inputFile, inputName);
	 inputFile = fopen(inputName, "rb");
         getSWFHeader(inputFile);
      }
      else
         error("Input file doesn't appear to be an SWF file..");
    }
    
    flmName = strdup(inputName);
    strcpy(strIstr(flmName, ".swf"), ".$lm");
    stdoutTempFile = freopen(flmName, "wb", stdout); // redirect stdout to inputName.flm

    if (stdoutTempFile == 0)
      error("Couldn't create temporary file");

    disassembleSWF(inputFile,inputName);
    fclose(stdoutTempFile);

    inputFile = fopen(flmName, "rb");
    inputName = strdup(flmName);
    yyin = inputFile;

    yyparse();

    fclose(inputFile);
    remove(flmName);
  }

  if (mode >= MODE_IDE)
  { 
    if (system(flapath) == -1)
        error("Couldn't start %s for some strange reason", flapath);
  }

  exit(0);
}
