/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.xml;

import java.io.*;
import org.w3c.dom.Node;
import org.relaxer.xml.visitor.UDOMVisitor;

/**
 * UXMLMaker
 *
 * @since   Jan. 16, 2001
 * @version May.  4, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public final class UXMLMaker {
    public static String getXMLText(Node node) {
	return (getXMLText(node, new XMLMaker()));
    }

    public static String getXMLVisualText(Node node) {
	XMLMaker maker = new XMLMaker();
	maker.setVisual(true);
	maker.setEmptyElementTag(true);
	return (getXMLText(node, maker));
    }

    public static String getXMLText(Node node, XMLMaker maker) {
	UDOMVisitor.traverse(node, maker);
	return (maker.getText());
    }

    public static void makeProcessingInstruction(
	String target,
	String data,
	Writer buffer
    ) throws IOException {
	buffer.write("<?");
	buffer.write(target);
	buffer.write(" ");
	buffer.write(data);
	buffer.write("?>");
    }

    public static void makeUnparsedEntity(
	String name,
	String publicId,
	String systemId,
	String notation,
	Writer buffer
    ) throws IOException {
	if (systemId == null) {
	    throw (new IllegalArgumentException("null system id"));
	}
	buffer.write("<!ENTITY ");
	buffer.write(name);
	if (publicId != null) {
	    buffer.write(" PUBLIC \"");
	    buffer.write(publicId);
	    buffer.write("\" \"");
	    buffer.write(UDOM.escapeSystemQuot(systemId));
	    buffer.write("\">");
	} else {
	    buffer.write(" SYSTEM \"");
	    buffer.write(UDOM.escapeSystemQuot(systemId));
	    buffer.write("\">");
	}
	if (notation != null) {
	    buffer.write(" NDATA ");
	    buffer.write(notation);
	    buffer.write(">");
	}
    }

    public static void makeNotation(
	String name,
	String pid,
	String sid,
	Writer buffer
    ) throws IOException {
	buffer.write("<!NOTATION ");
	buffer.write(name);
	if (pid != null) {
	    buffer.write(" PUBLIC \"");
	    buffer.write(pid);
	    buffer.write("\"");
	    if (sid != null) {
		buffer.write(" \"");
		buffer.write(UDOM.escapeSystemQuot(sid));
		buffer.write("\"");
	    }
	} else if (sid != null) {
	    buffer.write(" SYSTEM \"");
	    buffer.write(UDOM.escapeSystemQuot(sid));
	    buffer.write("\"");
	}
	buffer.write(">");
    }
}
