/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import javax.xml.parsers.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import javax.naming.*;
import org.w3c.dom.*;

/**
 * ULog
 *
 * @since   Apr. 19, 2002
 * @version Apr. 23, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public final class ULog {
    private static Boolean isLog__;

    public static void log(Object caller, String message) {
	if (!__isLog()) {
	    return;
	}
	System.out.println(message);
    }

    private static boolean __isLog() {
	if (isLog__ != null) {
	    return (isLog__.booleanValue());
	}
	try {
            Context jndiRoot = new InitialContext();
            String value = (String)jndiRoot.lookup("java:comp/env/relaxer/log");
	    if ("true".equals(value)) {
		isLog__ = Boolean.TRUE;
		return (true);
	    }
	} catch (NamingException e) {
	}
	isLog__ = Boolean.FALSE;
	return (false);
    }
}
