/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import java.sql.SQLException;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.relaxer.beans.RJDBCSelectBean;

/**
 * RJDBCSelectBeanTag
 *
 * @since   Mar.  4, 2001
 * @version Aug. 14, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RJDBCSelectBeanTag extends AbstractRJDBCBeanTag {
    private String where_ = null;

    public RJDBCSelectBeanTag() {
	_setup(new RJDBCSelectBean());
    }

    public void setWhere(String where) {
	where_ = where;
    }

    protected int _doRelaxerStartTag() throws JspTagException {
	RJDBCSelectBean bean = (RJDBCSelectBean)bean_;
	try {
//ULog.log("start");
	    if (where_ != null) {
		setRObjects(bean.selectRObjects(where_));
	    } else {
		setRObjects(bean.selectRObjects());
	    }
//ULog.log("end");
	} catch (SQLException e) {
	    throw (new JspTagException(e.getMessage()));
	}
	return (EVAL_PAGE);
    }
}
