/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.taglib;

import java.util.*;
import java.io.Serializable;
import java.lang.reflect.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.relaxer.beans.AbstractRJDBCBean;

/**
 * AbstractRJDBCBeanTag
 *
 * @since   Feb.  1, 2001
 * @version Jul. 23, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class AbstractRJDBCBeanTag extends AbstractRelaxerTag {
    protected AbstractRJDBCBean bean_;

    protected final void _setup(AbstractRJDBCBean bean) {
	bean_ = bean;
    }

    public void setJdbcUri(String uri) {
	bean_.setJdbcUri(uri);
    }

    public void setTableName(String tableName) {
	bean_.setTableName(tableName);
    }

    public void setUserName(String userName) {
//System.out.println("[" + userName + "]");
	bean_.setUserName(userName);
    }

    public void setPassword(String password) {
	bean_.setPassword(password);
    }

    public void setClassName(String className) {
	bean_.setClassName(className);
	
    }

    public void setDriver(String driver) {
	bean_.setDriver(driver);
    }
}
