/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.tabular;

import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * JDBCTabular
 *
 * @since   Jul. 11, 2001
 * @version Jul. 11, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class JDBCTabular extends TabularDecorator {
    public JDBCTabular(
	String url,
	String username,
	String password,
	String sql
    ) throws SQLException {
	this(url, username, password, sql, null);
    }

    public JDBCTabular(
	String url,
	String username,
	String password,
	String sql,
	String driver
    ) throws SQLException {
	if (driver != null) {
	    _loadDriver(driver);
	}
	Connection conn = DriverManager.getConnection(
	    url,
	    username,
	    password
	);
	JDBCConnectionTabular tabular = new JDBCConnectionTabular(conn, sql);
	_setup(tabular);
	conn.close();
    }

    private void _loadDriver(String driver) throws SQLException {
	try {
	    Class.forName(driver);
	} catch (ClassNotFoundException e) {
	    throw (new SQLException(e.getMessage()));
	}
    }
}
