/*
 * RelaxerOrg class library
 *  Copyright (C) 2000-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.runtime.datatype;

import java.util.*;

/**
 * RDataTime
 *
 * @since   Apr. 12, 2002
 * @version Apr. 12, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class RDateTime extends AbstractRDatatype {
    private Calendar calendar_;

    public RDateTime(String value) {
    }

    public RDateTime() {
	TimeZone zone = TimeZone.getTimeZone("GMT");
	calendar_ = Calendar.getInstance(zone);
    }

    public String toString() {
	StringBuffer buffer = new StringBuffer();
	buffer.append(calendar_.get(Calendar.YEAR));
	buffer.append("-");
	buffer.append(calendar_.get(Calendar.MONTH) + 1);
	buffer.append("-");
	buffer.append(calendar_.get(Calendar.DATE));
	buffer.append("T");
	buffer.append(calendar_.get(Calendar.HOUR_OF_DAY));
	buffer.append(":");
	buffer.append(calendar_.get(Calendar.MINUTE));
	buffer.append(":");
	buffer.append(calendar_.get(Calendar.SECOND));
	TimeZone zone = calendar_.getTimeZone();
	buffer.append(zone.getDisplayName(false, TimeZone.SHORT));
	return (new String(buffer));
    }
}
