/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.parcel;

import java.io.OutputStream;
import java.io.IOException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;

/**
 * BinaryGadget
 *
 * @since   Aug. 24, 2000
 * @version Feb. 25, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class BinaryGadget extends AbstractGadget {
    private byte[] content_;

    public final void setBinary(byte[] binary) {
	content_ = binary;
    }

    public final byte[] getBinary() {
	return (content_);
    }
    
    public void write(OutputStream out) throws IOException {
	out.write(content_);
    }

    public byte[] getBytes() throws IOException {
	return (content_);
    }
}
