package org.relaxer.goldenport.facade.service;

import java.io.StringReader;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.xml.parsers.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;
import org.relaxer.xml.UDOM;
import org.relaxer.goldenport.*;
import org.relaxer.goldenport.ports.*;
import org.relaxer.goldenport.ports.interpreter.*;
import org.relaxer.goldenport.selecter.*;
import org.relaxer.goldenport.facade.*;

/**
 * GoldenportService
 *
 * @since   Jun.  3, 2003
 * @version Jun.  6, 2003
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class GoldenportService extends AbstractGoldenportService {

    /**
     * Implementation of a operation eval.
     *
     * @param source
     * @exception RemoteException
     * @return String
     */
    public String eval(String source) throws RemoteException {
//System.out.println("s:" + source);
	try {
	    DocumentBuilderFactory factory
		= DocumentBuilderFactory.newInstance();
	    DocumentBuilder builder = factory.newDocumentBuilder();
	    Document doc = eval(builder.parse(source));
//System.out.println("y:" + UDOM.makeTextDocument(doc));
	    return (UDOM.makeTextDocument(doc));
	} catch (ParserConfigurationException e) {
	    throw (new RemoteException(e.getMessage(), e));
	} catch (SAXException e) {
	    throw (new RemoteException(e.getMessage(), e));
	} catch (IOException e) {
	    throw (new RemoteException(e.getMessage(), e));
	}
    }

    public Document eval(Document doc) throws RemoteException {
//System.out.println("x:" + UDOM.makeTextDocumentVisual(doc));
	PortFactory factory = new PortFactory();
	_addFilterPort(factory);
	_addInterpreterPort(factory, doc);
	PortEngine engine = new PortEngine(factory);
	PortContext portContext = new PortContext();
	portContext.setEngine(engine);
	return (engine.eval(doc, portContext));
    }

    private void _addFilterPort(PortFactory factory) {
/*
	String format = docContext.getFormat();
	FilterPort filter = new FilterPort();
	ISelecter selecter = new AllSelecter();
	if (format != null) {
	    filter.addPattern(
		selecter,
		"http://www.relaxer.org/xmlns/goldenport",
		"format",
		format
	    );
	}
	factory.addPort(filter);
*/
    }

    private void _addInterpreterPort(PortFactory factory, Document doc) {
	InterpreterPort interpreter = new InterpreterPort(doc);
	factory.addPort(interpreter);
    }
}
