package org.relaxer.goldenport.facade;

import java.util.*;
import java.io.IOException;
import java.rmi.RemoteException;
import java.beans.Beans;
import java.lang.reflect.*;

/**
 * URComponent
 *
 * @since   Mar. 23, 2002
 * @version Apr. 26, 2003
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public final class URComponent {
    public static Object makeBean(String beanName) throws RemoteException {
	try {
	    return (Beans.instantiate(null, beanName));
	} catch (ClassNotFoundException e) {
	    return (new RemoteException(e.getMessage(), e));
	} catch (IOException e) {
	    return (new RemoteException(e.getMessage(), e));
	}
    }

    public static Object makeProvider(
	String provider,
	String providerParam
    ) throws RemoteException {
	try {
	    Class clazz = Class.forName(provider);
	    Constructor constructor = clazz.getConstructor(
		new Class[] { String.class }
	    );
	    Object object = constructor.newInstance(
		new Object[] { providerParam }
	    );
	    return (object);
	} catch (ClassNotFoundException e) {
	    return (new RemoteException(e.getMessage(), e));
	} catch (InstantiationException e) {
	    return (new RemoteException(e.getMessage(), e));
	} catch (NoSuchMethodException e) {
	    return (new RemoteException(e.getMessage(), e));
	} catch (IllegalAccessException e) {
	    return (new RemoteException(e.getMessage(), e));
	} catch (IllegalArgumentException e) {
	    return (new RemoteException(e.getMessage(), e));
	} catch (InvocationTargetException e) {
	    Throwable cause = e.getTargetException();
	    if (cause != null) {
		return (new RemoteException(cause.getMessage(), cause));
	    } else {
		return (new RemoteException(e.getMessage(), e));
	    }
	}
    }

    public static Object makeProvider(String config) throws RemoteException {
	Map params = _getParams(config);
	String providerName = (String)params.get("provider");
	String providerParam = (String)params.get("provider.params");
	return (makeProvider(providerName, providerParam));
    }

    private static final int INIT = 1;
    private static final int NAME = 2;
    private static final int VALUE = 3;
    private static final int BLOCK = 4;

    private static Map _getParams(String config) {
	Map map = new HashMap();
	StringBuffer buffer = new StringBuffer();
	String name = null;
	String value = null;
	int blockCount = 0;
	int size = config.length();
	int state = INIT;
	for (int i = 0;i < size;i++) {
	    char c = config.charAt(i);
	    switch (state) {
	    case INIT:
		switch (c) {
		case ':':
		    // syntax error
		    break;
		case ';':
		    // syntax error
		    break;
		case '[':
		    // syntax error
		    break;
		case ']':
		    // syntax error
		    break;
		default:
		    buffer.append(c);
		    state = NAME;
		}
		break;
	    case NAME:
		switch (c) {
		case ':':
		    name = new String(buffer);
		    buffer = new StringBuffer();
		    state = VALUE;
		    break;
		case ';':
		    name = new String(buffer);
		    buffer = new StringBuffer();
		    value = "";
		    map.put(name, value);
		    state = INIT;
		    break;
		case '[':
		    // syntax error
		    break;
		case ']':
		    // syntax error
		    break;
		default:
		    buffer.append(c);
		    state = NAME;
		}
		break;
	    case VALUE:
		switch (c) {
		case ':':
		    buffer.append(c);
		    state = VALUE;
		    break;
		case ';':
		    value = new String(buffer);
		    buffer = new StringBuffer();
		    map.put(name, value);
		    state = INIT;
		    break;
		case '[':
		    state = BLOCK;
		    blockCount = 1;
		    break;
		case ']':
		    // syntax error
		    break;
		default:
		    buffer.append(c);
		    state = VALUE;
		}
		break;
	    case BLOCK:
		switch (c) {
		case ':':
		    buffer.append(c);
		    state = BLOCK;
		    break;
		case ';':
		    buffer.append(c);
		    state = BLOCK;
		    break;
		case '[':
		    blockCount++;
		    state = BLOCK;
		    break;
		case ']':
		    blockCount--;
		    if (blockCount > 0) {
			state = BLOCK;
		    } else {
			state = VALUE;
		    }
		    break;
		default:
		    buffer.append(c);
		    state = BLOCK;
		}
		break;
	    default:
		throw (new InternalError());
	    }
	}
	return (map);
    }

    public static String encodeValue(
	String name,
	String xmlType,
	Object object
    ) {
	return (name + "[" + xmlType + "]:" + object);
    }

    public static String encodeValue(
	String name,
	String xmlType,
	boolean value
    ) {
	return (name + "[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String name,
	String xmlType,
	byte value
    ) {
	return (name + "[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String name,
	String xmlType,
	short value
    ) {
	return (name + "[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String name,
	String xmlType,
	int value
    ) {
	return (name + "[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String name,
	String xmlType,
	long value
    ) {
	return (name + "[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String name,
	String xmlType,
	float value
    ) {
	return (name + "[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String name,
	String xmlType,
	double value
    ) {
	return (name + "[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String xmlType,
	Object object
    ) {
	return ("[" + xmlType + "]:" + object);
    }

    public static String encodeValue(
	String xmlType,
	boolean value
    ) {
	return ("[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String xmlType,
	byte value
    ) {
	return ("[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String xmlType,
	short value
    ) {
	return ("[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String xmlType,
	int value
    ) {
	return ("[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String xmlType,
	long value
    ) {
	return ("[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String xmlType,
	float value
    ) {
	return ("[" + xmlType + "]:" + value);
    }

    public static String encodeValue(
	String xmlType,
	double value
    ) {
	return ("[" + xmlType + "]:" + value);
    }

    //
    public static String getProvider(String[] args) {
	for (int i = 0;i < args.length;i++) {
	    if (args[i].startsWith("-provider:")) {
		return (args[i].substring("-provider:".length()));
	    }
	}
	return (null);
    }

    public static String getProviderParams(String[] args) {
	for (int i = 0;i < args.length;i++) {
	    if (args[i].startsWith("-provider.params:")) {
		return (args[i].substring("-provider.params:".length()));
	    }
	}
	return (null);
    }

    public static boolean isSecurity(String[] args) {
	for (int i = 0;i < args.length;i++) {
	    if (args[i].startsWith("-security:false")) {
		return (false);
	    }
	}
	return (true);
    }

    public static String[] getArgs(String[] args) {
	List list = new ArrayList();
	for (int i = 0;i < args.length;i++) {
	    if (!args[i].startsWith("-")) {
		list.add(args[i]);
	    }
	}
	String[] result = new String[list.size()];
	return ((String[])list.toArray(result));
    }
}
