package org.relaxer.goldenport.facade;

import java.rmi.RemoteException;

public abstract class GoldenportForwardProxy implements IGoldenport {
    private IGoldenportFilter rReference_;

    /**
     * @param filter
     */
    public void rPushFilter(IGoldenportFilter filter) {
        filter.rSetReference$Goldenport(rReference_);
        rReference_ = filter;
    }

    /**
     * @return IGoldenportFilter
     */
    public IGoldenportFilter rPopFilter() {
        IGoldenportFilter filter = rReference_;
        rReference_ = filter.rGetReference$Goldenport();
        return (filter);
    }

    /**
     * @param reference
     */
    public void rSetReference(IGoldenportFilter reference) {
        rReference_ = reference;
    }

    /**
     * @return IGoldenportFilter
     */
    public IGoldenportFilter rGetReference() {
        return (rReference_);
    }

    /**
     * Forwards a request of the operation eval.
     *
     * @param source
     * @exception RemoteException
     * @return String
     */
    public String eval(String source) throws RemoteException {
        IGoldenportFilter $reference$ = rReference_;
        try {
            return ($reference$.eval$Goldenport(source));
        } catch (RemoteException e) {
            throw (e);
        } catch (Exception e) {
            throw (new RemoteException(e.getMessage(), e));
        }
    }
}
