package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DJdbc</b> is generated from dialog.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="jdbc">
 *   <attribute name="javaClass">
 *     <data type="token"/>
 *   </attribute>
 *   <attribute name="uri">
 *     <data type="anyURI"/>
 *   </attribute>
 *   <attribute name="table">
 *     <data type="normalizedString"/>
 *   </attribute>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="jdbc"&gt;
 *   &lt;attribute name="javaClass"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="uri"&gt;
 *     &lt;data type="anyURI"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="table"&gt;
 *     &lt;data type="normalizedString"/&gt;
 *   &lt;/attribute&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version dialog.rng (Tue Jun 03 11:20:58 GMT+09:00 2003)
 * @author  Relaxer 1.0beta (http://www.relaxer.org)
 */
public class DJdbc implements java.io.Serializable, Cloneable, IREvaluatable, IRNode, IDAccessMethodChoice {
    private String javaClass_;
    private String uri_;
    private String table_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>DJdbc</code>.
     *
     */
    public DJdbc() {
        javaClass_ = "";
        uri_ = "";
        table_ = "";
    }

    /**
     * Creates a <code>DJdbc</code>.
     *
     * @param source
     */
    public DJdbc(DJdbc source) {
        setup(source);
    }

    /**
     * Creates a <code>DJdbc</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DJdbc(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>DJdbc</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public DJdbc(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>DJdbc</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public DJdbc(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>DJdbc</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DJdbc(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>DJdbc</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DJdbc(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>DJdbc</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DJdbc(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>DJdbc</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DJdbc(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>DJdbc</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DJdbc(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>DJdbc</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DJdbc(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>DJdbc</code> by the DJdbc <code>source</code>.
     *
     * @param source
     */
    public void setup(DJdbc source) {
        int size;
        setJavaClass(source.getJavaClass());
        setUri(source.getUri());
        setTable(source.getTable());
    }

    /**
     * Initializes the <code>DJdbc</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>DJdbc</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>DJdbc</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IDialogFactory factory = DialogFactory.getFactory();
        RStack stack = new RStack(element);
        javaClass_ = URelaxer.getAttributePropertyAsString(element, "javaClass");
        uri_ = URelaxer.getAttributePropertyAsString(element, "uri");
        table_ = URelaxer.getAttributePropertyAsString(element, "table");
    }

    /**
     * @return Object
     */
    public Object clone() {
        IDialogFactory factory = DialogFactory.getFactory();
        return (factory.createDJdbc(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("jdbc");
        int size;
        if (this.javaClass_ != null) {
            URelaxer.setAttributePropertyByString(element, "javaClass", this.javaClass_);
        }
        if (this.uri_ != null) {
            URelaxer.setAttributePropertyByString(element, "uri", this.uri_);
        }
        if (this.table_ != null) {
            URelaxer.setAttributePropertyByString(element, "table", this.table_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>DJdbc</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>DJdbc</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DJdbc</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DJdbc</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DJdbc</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DJdbc</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>javaClass</b>.
     *
     * @return String
     */
    public final String getJavaClass() {
        return (javaClass_);
    }

    /**
     * Sets the String property <b>javaClass</b>.
     *
     * @param javaClass
     */
    public final void setJavaClass(String javaClass) {
        this.javaClass_ = javaClass;
    }

    /**
     * Gets the String property <b>uri</b>.
     *
     * @return String
     */
    public final String getUri() {
        return (uri_);
    }

    /**
     * Sets the String property <b>uri</b>.
     *
     * @param uri
     */
    public final void setUri(String uri) {
        this.uri_ = uri;
    }

    /**
     * Gets the String property <b>table</b>.
     *
     * @return String
     */
    public final String getTable() {
        return (table_);
    }

    /**
     * Sets the String property <b>table</b>.
     *
     * @param table
     */
    public final void setTable(String table) {
        this.table_ = table;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<jdbc");
        if (javaClass_ != null) {
            buffer.append(" javaClass=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getJavaClass())));
            buffer.append("\"");
        }
        if (uri_ != null) {
            buffer.append(" uri=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getUri())));
            buffer.append("\"");
        }
        if (table_ != null) {
            buffer.append(" table=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getTable())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</jdbc>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<jdbc");
        if (javaClass_ != null) {
            buffer.write(" javaClass=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getJavaClass())));
            buffer.write("\"");
        }
        if (uri_ != null) {
            buffer.write(" uri=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getUri())));
            buffer.write("\"");
        }
        if (table_ != null) {
            buffer.write(" table=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getTable())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</jdbc>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<jdbc");
        if (javaClass_ != null) {
            buffer.print(" javaClass=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getJavaClass())));
            buffer.print("\"");
        }
        if (uri_ != null) {
            buffer.print(" uri=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getUri())));
            buffer.print("\"");
        }
        if (table_ != null) {
            buffer.print(" table=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getTable())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</jdbc>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getJavaClassAsString() {
        return (URelaxer.getString(getJavaClass()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getUriAsString() {
        return (URelaxer.getString(getUri()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTableAsString() {
        return (URelaxer.getString(getTable()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setJavaClassByString(String string) {
        setJavaClass(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setUriByString(String string) {
        setUri(URelaxer.getString(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTableByString(String string) {
        setTable(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = rGetRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>DJdbc</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "jdbc")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "javaClass")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "uri")) {
            return (false);
        }
        $match$ = true;
        if (!URelaxer.hasAttributeHungry(target, "table")) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DJdbc</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DJdbc</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
