package org.relaxer.dialog.rDialog;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>DDialog</b> is generated from dialog.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="dialog">
 *   <attribute name="name">
 *     <data type="token"/>
 *   </attribute>
 *   <zeroOrMore>
 *     <ref name="slot"/>
 *   </zeroOrMore>
 *   <zeroOrMore>
 *     <ref name="command"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="dialog"&gt;
 *   &lt;attribute name="name"&gt;
 *     &lt;data type="token"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="slot"/&gt;
 *   &lt;/zeroOrMore&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="command"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version dialog.rng (Tue Jun 03 11:20:57 GMT+09:00 2003)
 * @author  Relaxer 1.0beta (http://www.relaxer.org)
 */
public class DDialog implements java.io.Serializable, Cloneable, IREvaluatable, IRNode {
    private String name_;
    // List<DSlot>
    private java.util.List slot_ = new java.util.ArrayList();
    // List<DCommand>
    private java.util.List command_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>DDialog</code>.
     *
     */
    public DDialog() {
        name_ = "";
    }

    /**
     * Creates a <code>DDialog</code>.
     *
     * @param source
     */
    public DDialog(DDialog source) {
        setup(source);
    }

    /**
     * Creates a <code>DDialog</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public DDialog(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>DDialog</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public DDialog(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>DDialog</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public DDialog(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>DDialog</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DDialog(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>DDialog</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DDialog(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>DDialog</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DDialog(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>DDialog</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DDialog(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>DDialog</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DDialog(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>DDialog</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public DDialog(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>DDialog</code> by the DDialog <code>source</code>.
     *
     * @param source
     */
    public void setup(DDialog source) {
        int size;
        setName(source.getName());
        this.slot_.clear();
        size = source.slot_.size();
        for (int i = 0;i < size;i++) {
            addSlot((DSlot)source.getSlot(i).clone());
        }
        this.command_.clear();
        size = source.command_.size();
        for (int i = 0;i < size;i++) {
            addCommand((DCommand)source.getCommand(i).clone());
        }
    }

    /**
     * Initializes the <code>DDialog</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>DDialog</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>DDialog</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        IDialogFactory factory = DialogFactory.getFactory();
        RStack stack = new RStack(element);
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        slot_.clear();
        while (true) {
            if (DSlot.isMatch(stack)) {
                addSlot(factory.createDSlot(stack));
            } else {
                break;
            }
        }
        command_.clear();
        while (true) {
            if (DCommand.isMatch(stack)) {
                addCommand(factory.createDCommand(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        IDialogFactory factory = DialogFactory.getFactory();
        return (factory.createDDialog(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("dialog");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        size = this.slot_.size();
        for (int i = 0;i < size;i++) {
            DSlot value = (DSlot)this.slot_.get(i);
            value.makeElement(element);
        }
        size = this.command_.size();
        for (int i = 0;i < size;i++) {
            DCommand value = (DCommand)this.command_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>DDialog</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>DDialog</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DDialog</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DDialog</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DDialog</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>DDialog</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public final String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public final void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the DSlot property <b>slot</b>.
     *
     * @return DSlot[]
     */
    public final DSlot[] getSlot() {
        DSlot[] array = new DSlot[slot_.size()];
        return ((DSlot[])slot_.toArray(array));
    }

    /**
     * Sets the DSlot property <b>slot</b>.
     *
     * @param slot
     */
    public final void setSlot(DSlot[] slot) {
        this.slot_.clear();
        for (int i = 0;i < slot.length;i++) {
            addSlot(slot[i]);
        }
        for (int i = 0;i < slot.length;i++) {
            slot[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the DSlot property <b>slot</b>.
     *
     * @param slot
     */
    public final void setSlot(DSlot slot) {
        this.slot_.clear();
        addSlot(slot);
        if (slot != null) {
            slot.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DSlot property <b>slot</b>.
     *
     * @param slot
     */
    public final void addSlot(DSlot slot) {
        this.slot_.add(slot);
        if (slot != null) {
            slot.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DSlot property <b>slot</b>.
     *
     * @param slot
     */
    public final void addSlot(DSlot[] slot) {
        for (int i = 0;i < slot.length;i++) {
            addSlot(slot[i]);
        }
        for (int i = 0;i < slot.length;i++) {
            slot[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the DSlot property <b>slot</b>.
     *
     * @return int
     */
    public final int sizeSlot() {
        return (slot_.size());
    }

    /**
     * Gets the DSlot property <b>slot</b> by index.
     *
     * @param index
     * @return DSlot
     */
    public final DSlot getSlot(int index) {
        return ((DSlot)slot_.get(index));
    }

    /**
     * Sets the DSlot property <b>slot</b> by index.
     *
     * @param index
     * @param slot
     */
    public final void setSlot(int index, DSlot slot) {
        this.slot_.set(index, slot);
        if (slot != null) {
            slot.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DSlot property <b>slot</b> by index.
     *
     * @param index
     * @param slot
     */
    public final void addSlot(int index, DSlot slot) {
        this.slot_.add(index, slot);
        if (slot != null) {
            slot.rSetParentRNode(this);
        }
    }

    /**
     * Remove the DSlot property <b>slot</b> by index.
     *
     * @param index
     */
    public final void removeSlot(int index) {
        this.slot_.remove(index);
    }

    /**
     * Remove the DSlot property <b>slot</b> by object.
     *
     * @param slot
     */
    public final void removeSlot(DSlot slot) {
        this.slot_.remove(slot);
    }

    /**
     * Clear the DSlot property <b>slot</b>.
     *
     */
    public final void clearSlot() {
        this.slot_.clear();
    }

    /**
     * Gets the DCommand property <b>command</b>.
     *
     * @return DCommand[]
     */
    public final DCommand[] getCommand() {
        DCommand[] array = new DCommand[command_.size()];
        return ((DCommand[])command_.toArray(array));
    }

    /**
     * Sets the DCommand property <b>command</b>.
     *
     * @param command
     */
    public final void setCommand(DCommand[] command) {
        this.command_.clear();
        for (int i = 0;i < command.length;i++) {
            addCommand(command[i]);
        }
        for (int i = 0;i < command.length;i++) {
            command[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the DCommand property <b>command</b>.
     *
     * @param command
     */
    public final void setCommand(DCommand command) {
        this.command_.clear();
        addCommand(command);
        if (command != null) {
            command.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DCommand property <b>command</b>.
     *
     * @param command
     */
    public final void addCommand(DCommand command) {
        this.command_.add(command);
        if (command != null) {
            command.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DCommand property <b>command</b>.
     *
     * @param command
     */
    public final void addCommand(DCommand[] command) {
        for (int i = 0;i < command.length;i++) {
            addCommand(command[i]);
        }
        for (int i = 0;i < command.length;i++) {
            command[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the DCommand property <b>command</b>.
     *
     * @return int
     */
    public final int sizeCommand() {
        return (command_.size());
    }

    /**
     * Gets the DCommand property <b>command</b> by index.
     *
     * @param index
     * @return DCommand
     */
    public final DCommand getCommand(int index) {
        return ((DCommand)command_.get(index));
    }

    /**
     * Sets the DCommand property <b>command</b> by index.
     *
     * @param index
     * @param command
     */
    public final void setCommand(int index, DCommand command) {
        this.command_.set(index, command);
        if (command != null) {
            command.rSetParentRNode(this);
        }
    }

    /**
     * Adds the DCommand property <b>command</b> by index.
     *
     * @param index
     * @param command
     */
    public final void addCommand(int index, DCommand command) {
        this.command_.add(index, command);
        if (command != null) {
            command.rSetParentRNode(this);
        }
    }

    /**
     * Remove the DCommand property <b>command</b> by index.
     *
     * @param index
     */
    public final void removeCommand(int index) {
        this.command_.remove(index);
    }

    /**
     * Remove the DCommand property <b>command</b> by object.
     *
     * @param command
     */
    public final void removeCommand(DCommand command) {
        this.command_.remove(command);
    }

    /**
     * Clear the DCommand property <b>command</b>.
     *
     */
    public final void clearCommand() {
        this.command_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<dialog");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.slot_.size();
        for (int i = 0;i < size;i++) {
            DSlot value = (DSlot)this.slot_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.command_.size();
        for (int i = 0;i < size;i++) {
            DCommand value = (DCommand)this.command_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</dialog>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<dialog");
        if (name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.slot_.size();
        for (int i = 0;i < size;i++) {
            DSlot value = (DSlot)this.slot_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.command_.size();
        for (int i = 0;i < size;i++) {
            DCommand value = (DCommand)this.command_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</dialog>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<dialog");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.slot_.size();
        for (int i = 0;i < size;i++) {
            DSlot value = (DSlot)this.slot_.get(i);
            value.makeTextElement(buffer);
        }
        size = this.command_.size();
        for (int i = 0;i < size;i++) {
            DCommand value = (DCommand)this.command_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</dialog>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Evaluates the node.
     *
     * @return Object
     */
    public Object eval() {
        return (eval(new RSimpleEvaluationContext()));
    }

    /**
     * Evaluates the node with the evaluation context.
     *
     * @param context
     * @return Object
     */
    public Object eval(IREvaluationContext context) {
        IRNode[] children = rGetRNodes();
        Object[] params = new Object[children.length];
        for (int i = 0;i < children.length;i++) {
            IRNode child = children[i];
            if (child instanceof IREvaluatable) {
                params[i] = ((IREvaluatable)child).eval(context);
            } else {
                params[i] = child;
            }
        }
        return (eval(params, context));
    }

    /**
     * Evaluates against the params.
     *
     * @param params
     * @param context
     * @return Object
     */
    public Object eval(Object[] params, IREvaluationContext context) {
        if (params == null) {
            return (null);
        }
        if (params.length == 0) {
            return (null);
        }
        return (params[params.length -1]);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(slot_);
        classNodes.addAll(command_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>DDialog</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "dialog")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!DSlot.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        while (true) {
            if (!DCommand.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DDialog</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>DDialog</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
