/*
 * RelaxerOrg class library
 *  Copyright (C) 2000,2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.dialog;

import java.io.IOException;
import javax.xml.parsers.*;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.relaxer.xml.UDOM;
import org.relaxer.dialog.rDialog.DBean;

/**
 * BeanEntity
 *
 * @since   Jul. 10, 2001
 * @version Jul. 10, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class BeanEntityAdapter extends AbstractEntityAdapter {
    private String uri_;

    public BeanEntityAdapter(String uri) {
	uri_ = uri;
    }

    public BeanEntityAdapter(DBean method) {
    }

    public Document load() throws IOException {
	try {
	    return (UDOM.loadDocument(uri_));
	} catch (ParserConfigurationException e) {
	    throw (new DialogException(e));
	} catch (SAXException e) {
	    throw (new DialogException(e));
	}
    }

    public void save(Document doc) throws IOException {
	try {
	    UDOM.saveDocument(uri_, doc);
	} finally {
	}
    }
}
