/*
 * The RelaxerOrg class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@relaxer.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.relaxer.bus.model;

import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import org.w3c.dom.Document;
import org.relaxer.bus.*;

/**
 * UriValue
 *
 * @since   Jan.  2, 2002
 * @version Jan.  2, 2002
 * @author  ASAMI, Tomoharu (asami@relaxer.org)
 */
public class UriValue implements IRBusValue {
    private String uri_;
    private URL url_;

    public UriValue(String uri) throws MalformedURLException {
	setUri(uri);
    }

    public UriValue(String uri, URL url) {
	uri_ = uri;
	url_ = url;
    }

    public String getUri() {
	return (uri_);
    }

    public void setUri(String uri) throws MalformedURLException {
	uri_ = uri;
	try {
	    url_ = new URL(uri);
	} catch (MalformedURLException e) {
	    File file = new File(uri);
	    url_ = file.toURL();
	}
    }

    // binary
    public byte[] getBinary() throws IOException {
	return (UIO.makeBinary(url_));
    }

    public InputStream getInputStream() throws IOException {
	return (url_.openStream());
    }

    // string
    public String getText() throws IOException {
	return (UIO.makeText(url_));
    }

    public Reader getReader() throws IOException {
	throw (new UnsupportedOperationException());
    }

    // XML
    public Document getDocument() {
	throw (new UnsupportedOperationException());
    }

    // Object
    public Object getObject() {
	throw (new UnsupportedOperationException());
    }
}
