/*
 * The JabaJaba class library
 *  Copyright (C) 1997-1999  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.schema;

import java.util.*;
import java.net.URL;
import java.net.MalformedURLException;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * Schema
 *
 * @since   Aug. 17, 1999
 * @version Aug. 18, 1999
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public class Schema implements Constants {
    protected URL xmlSchema_;
    protected URL schemaID_;
    protected String schemaVersion_;
    protected int model_;
    // export
    protected boolean exportAllDataTypes_ = true;
    protected boolean exportAllArcheTypes_ = true;
    protected boolean exportAllElementTypes_ = true;
    protected boolean exportAllModelGroups_ = true;
    protected boolean exportAllAttributeGroups_ = true;
    protected boolean exportAllEntities_ = true;
    protected boolean exportAllNotations_ = true;
    // import
    protected String importSchemaAbbrev_;
    protected URL importSchemaName_;
    // XXX : importRestrictions_
    // include
    protected SchemaRef includeSchema_;
    protected boolean includeAllDataTypes_ = true;
    protected boolean includeAllArcheTypes_ = true;
    protected boolean includeAllElementTypes_ = true;
    protected boolean includeAllModelGroups_ = true;
    protected boolean includeAllAttributeGroups_ = true;
    protected boolean includeAllEntities_ = true;
    protected boolean includeAllNotations_ = true;
    protected DataTypeRef[] includeDataTypeRefs_;
    protected ElementTypeRef[] includeElementTypeRefs_;
    protected ArcheTypeRef[] includeArcheTypeRefs_;
    protected ModelGroupRef[] includeModelGroupRefs_;
    protected AttrGroupRef[] includeAttrGroupRefs_;
    protected EntityRef[] includeEntityRefs_;
    protected NotationRef[] includeNotationRefs_;
    // dds
    protected Map dataTypes_ = new HashMap();
    protected Map archeTypes_ = new HashMap();
    protected Map elementTypes_ = new HashMap();
    protected Map attrGroups_ = new HashMap();
    protected Map modelGroups_ = new HashMap();
    protected Map notations_ = new HashMap();
    protected Map entities_ = new HashMap();

    public Schema(Document doc) {
	this(doc.getDocumentElement());
    }

    public Schema(Element root) {
	try {
	    SmartElement se = new SmartElement(root);
	    xmlSchema_ = se.getAttributeAsURL("xmlns");
	    schemaID_ = se.getAttributeAsURL("name");
	    schemaVersion_ = se.getAttribute("version");
	    model_ = se.getAttributeAsEnumerationNumber(
		"model",
		new String[] { "open", "refinable", "closed" },
		1,
		"open"		// XXX : open issue
	    );
	    // XXX: export
	    // XXX: import
	    // XXX: include
	    // DataType
	    NodeList nodes = se.getElementsByTagName("datatype");
	    int size = nodes.getLength();
	    for (int i = 0;i < size;i++) {
		DataType datatype = DataType.create((Element)nodes.item(i));
		dataTypes_.put(datatype.getName(), datatype);
	    }
	    // ArcheType
	    nodes = se.getElementsByTagName("archetype");
	    size = nodes.getLength();
	    for (int i = 0;i < size;i++) {
		ArcheType archetype
		    = ArcheType.create((Element)nodes.item(i));
		archeTypes_.put(archetype.getName(), archetype);
	    }
	    // ElementType
	    nodes = se.getElementsByTagName("elementtype");
	    size = nodes.getLength();
	    for (int i = 0;i < size;i++) {
		ElementType elementtype
		    = ElementType.create((Element)nodes.item(i));
		elementTypes_.put(elementtype.getName(), elementtype);
	    }
	    // AttrGroup
	    nodes = se.getElementsByTagName("attrGroup");
	    size = nodes.getLength();
	    for (int i = 0;i < size;i++) {
		AttrGroup attrGroup
		    = AttrGroup.create((Element)nodes.item(i));
		attrGroups_.put(attrGroup.getName(), attrGroup);
	    }
	    // ModelGroup
	    nodes = se.getElementsByTagName("modelGroup");
	    size = nodes.getLength();
	    for (int i = 0;i < size;i++) {
		ModelGroup modelGroup
		    = ModelGroup.create((Element)nodes.item(i));
		modelGroups_.put(
		    modelGroup.getName(), modelGroup);
	    }
	    // XXX : Notation
	    // XXX : Entity
	} catch (MalformedURLException e) {
	    throw (new InternalError()); // XXX
	}
    }

    public static Schema create(Document doc) {
	return (new Schema(doc));
    }

    public static Schema create(Element root) {
	return (new Schema(root));
    }
}
