package jp.gr.java_conf.jaba2.xml.relaxng.rRelaxng;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>RNTextExcept</b> is generated from relaxNg.rxm by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule label="textExcept">
 *   <tag name="except"/>
 *   <choice occurs="*">
 *     <hedgeRef label="textHedge"/>
 *   </choice>
 * </elementRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule label="textExcept"&gt;
 *   &lt;tag name="except"/&gt;
 *   &lt;choice occurs="*"&gt;
 *     &lt;hedgeRef label="textHedge"/&gt;
 *   &lt;/choice&gt;
 * &lt;/elementRule&gt;
 * </pre>
 *
 * @version relaxNg.rxm (Sun May 18 08:58:08 JST 2003)
 * @author  Relaxer 1.0rc2b (http://www.relaxer.org)
 */
public class RNTextExcept implements java.io.Serializable, Cloneable, IRNSContainer, IRNTextExceptChoice, IRVisitable, IRNode, IRNTextGroupChoice, IRNDataChoice, IRNTextHedgeChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://relaxng.org/ns/structure/1.0");
    // List<IRNTextExceptChoice>
    private java.util.List content_ = new java.util.ArrayList();
    private Element xmlElement;
    private java.util.Map $directAttributes$_ = new java.util.HashMap();
    private IRNode parentRNode_;

    /**
     * Creates a <code>RNTextExcept</code>.
     *
     */
    public RNTextExcept() {
    }

    /**
     * Creates a <code>RNTextExcept</code>.
     *
     * @param source
     */
    public RNTextExcept(RNTextExcept source) {
        setup(source);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public RNTextExcept(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public RNTextExcept(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public RNTextExcept(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextExcept(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>RNTextExcept</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextExcept(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextExcept(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextExcept(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextExcept(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>RNTextExcept</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public RNTextExcept(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the RNTextExcept <code>source</code>.
     *
     * @param source
     */
    public void setup(RNTextExcept source) {
        int size;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IRNTextExceptChoice)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        xmlElement = element;
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        content_.clear();
        while (true) {
            if (RNDefine.isMatch(stack)) {
                addContent(factory.createRNDefine(stack));
            } else if (RNElement.isMatch(stack)) {
                addContent(factory.createRNElement(stack));
            } else if (RNAttribute.isMatch(stack)) {
                addContent(factory.createRNAttribute(stack));
            } else if (RNData.isMatch(stack)) {
                addContent(factory.createRNData(stack));
            } else if (RNValue.isMatch(stack)) {
                addContent(factory.createRNValue(stack));
            } else if (RNRef.isMatch(stack)) {
                addContent(factory.createRNRef(stack));
            } else if (RNText.isMatch(stack)) {
                addContent(factory.createRNText(stack));
            } else if (RNList.isMatch(stack)) {
                addContent(factory.createRNList(stack));
            } else if (RNNotAllowed.isMatch(stack)) {
                addContent(factory.createRNNotAllowed(stack));
            } else if (RNEmpty.isMatch(stack)) {
                addContent(factory.createRNEmpty(stack));
            } else if (RNTextChoice.isMatch(stack)) {
                addContent(factory.createRNTextChoice(stack));
            } else if (RNTextOptional.isMatch(stack)) {
                addContent(factory.createRNTextOptional(stack));
            } else if (RNTextOneOrMore.isMatch(stack)) {
                addContent(factory.createRNTextOneOrMore(stack));
            } else if (RNTextZeroOrMore.isMatch(stack)) {
                addContent(factory.createRNTextZeroOrMore(stack));
            } else if (RNTextGroup.isMatch(stack)) {
                addContent(factory.createRNTextGroup(stack));
            } else if (RNTextExcept.isMatch(stack)) {
                addContent(factory.createRNTextExcept(stack));
            } else {
                break;
            }
        }
        stack.addDirectAttributes($directAttributes$_);
    }

    /**
     * @return Object
     */
    public Object clone() {
        IRelaxNgFactory factory = RelaxNgFactory.getFactory();
        return (factory.createRNTextExcept(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://relaxng.org/ns/structure/1.0", "except");
        rNSContext_.setupNamespace(element);
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IRNTextExceptChoice value = (IRNTextExceptChoice)this.content_.get(i);
            value.makeElement(element);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            element.setAttribute(key, rGetAttribute(key));
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>RNTextExcept</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>RNTextExcept</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the IRNTextExceptChoice property <b>content</b>.
     *
     * @return IRNTextExceptChoice[]
     */
    public final IRNTextExceptChoice[] getContent() {
        IRNTextExceptChoice[] array = new IRNTextExceptChoice[content_.size()];
        return ((IRNTextExceptChoice[])content_.toArray(array));
    }

    /**
     * Sets the IRNTextExceptChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IRNTextExceptChoice[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IRNTextExceptChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IRNTextExceptChoice content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IRNTextExceptChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IRNTextExceptChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IRNTextExceptChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IRNTextExceptChoice[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IRNTextExceptChoice property <b>content</b>.
     *
     * @return int
     */
    public final int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IRNTextExceptChoice property <b>content</b> by index.
     *
     * @param index
     * @return IRNTextExceptChoice
     */
    public final IRNTextExceptChoice getContent(int index) {
        return ((IRNTextExceptChoice)content_.get(index));
    }

    /**
     * Sets the IRNTextExceptChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IRNTextExceptChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IRNTextExceptChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void addContent(int index, IRNTextExceptChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IRNTextExceptChoice property <b>content</b> by index.
     *
     * @param index
     */
    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IRNTextExceptChoice property <b>content</b> by object.
     *
     * @param content
     */
    public final void removeContent(IRNTextExceptChoice content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IRNTextExceptChoice property <b>content</b>.
     *
     */
    public final void clearContent() {
        this.content_.clear();
    }

    /**
     * Gets the element to be used in the object construction.
     *
     * @return Element
     */
    public Element rGetElement() {
        return (xmlElement);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.append("<");
        URelaxer.makeQName(prefix, "except", buffer);
        rNSContext_.makeNSMappings(buffer);
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IRNTextExceptChoice value = (IRNTextExceptChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.append(" ");
            buffer.append(key);
            buffer.append("=\"");
            buffer.append(rGetAttribute(key));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IRNTextExceptChoice value = (IRNTextExceptChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "except", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.write("<");
        URelaxer.makeQName(prefix, "except", buffer);
        rNSContext_.makeNSMappings(buffer);
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IRNTextExceptChoice value = (IRNTextExceptChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.write(" ");
            buffer.write(key);
            buffer.write("=\"");
            buffer.write(rGetAttribute(key));
            buffer.write("\"");
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IRNTextExceptChoice value = (IRNTextExceptChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "except", buffer);
        buffer.write(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://relaxng.org/ns/structure/1.0");
        buffer.print("<");
        URelaxer.makeQName(prefix, "except", buffer);
        rNSContext_.makeNSMappings(buffer);
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IRNTextExceptChoice value = (IRNTextExceptChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        String[] keys = rGetAttributeKeys();
        for (int i = 0;i < keys.length;i++) {
            String key = keys[i];
            buffer.print(" ");
            buffer.print(key);
            buffer.print("=\"");
            buffer.print(rGetAttribute(key));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IRNTextExceptChoice value = (IRNTextExceptChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "except", buffer);
        buffer.print(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets a value of the attribute.
     *
     * @param qName
     * @return String
     */
    public String rGetAttribute(String qName) {
        return ((String)$directAttributes$_.get(qName));
    }

    /**
     * Sets a value of the attribute.
     *
     * @param qName
     * @param value
     */
    public void rSetAttribute(String qName, String value) {
        $directAttributes$_.put(qName, value);
    }

    /**
     * Gets attribute keys.
     *
     * @return String[]
     */
    public String[] rGetAttributeKeys() {
        java.util.Set keys = $directAttributes$_.keySet();
        String[] result = new String[keys.size()];
        return ((String[])keys.toArray(result));
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>RNTextExcept</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://relaxng.org/ns/structure/1.0", "except")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (RNDefine.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNElement.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNAttribute.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNData.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNRef.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNText.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNList.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNNotAllowed.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNEmpty.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextChoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextOptional.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextOneOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextZeroOrMore.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextGroup.isMatchHungry(target)) {
                $match$ = true;
            } else if (RNTextExcept.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNTextExcept</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>RNTextExcept</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
