/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2003  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relaxng;

import jp.gr.java_conf.jaba2.xml.relax.cooked.*;

/**
 * CParentRef
 *
 * @since   Jul. 13, 2003
 * @version Jul. 13, 2003
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public class CParentRef extends CNode
    implements ICParticle, ICContentModel {

    private String label_;
    private String ns_;
    private COccurs occurs_;

    public CParentRef(String label, String occurs) {
        this(label, null, occurs);
    }

    public CParentRef(String label, String ns, String occurs) {
        label_ = label;
        ns_ = ns;
        occurs_ = new COccurs(occurs);
    }

    public final String getLabel() {
	return (label_);
    }

    public final String getNamespace() {
        return (ns_);
    }

    public final COccurs getOccurs() {
	return (occurs_);
    }
}
