/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax.raw;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.relaxng.RNGGrammar;
import jp.gr.java_conf.jaba2.xml.relaxng.RNGModule;

/**
 * RRelax
 *
 * @since   Dec. 18, 1999
 * @version Jun. 15, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class RRelax {
    private RGrammar grammar_ = null;
    private List modules_ = new ArrayList(); // List<RModule>
    private List ngModules_ = new ArrayList(); // List<RNGModule>

    public void setGrammar(RGrammar grammar) {
	grammar_ = grammar;
    }

    public RGrammar getGrammar() {
	return (grammar_);
    }

    public void addModule(RModule module) {
	modules_.add(module);
    }

    public void addNgGrammar(RNGGrammar grammar) {
	ngModules_.addAll(Arrays.asList(grammar.getModules()));
    }

    public RModule[] getModules() {
	RModule[] modules = new RModule[modules_.size()];
	return ((RModule[])modules_.toArray(modules));
    }

    public RNGModule[] getNgModules() {
	RNGModule[] modules = new RNGModule[ngModules_.size()];
	return ((RNGModule[])ngModules_.toArray(modules));
    }
}
