/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2001  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.relax;

import java.util.*;
import java.io.IOException;
import java.net.URL;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.io.UURL;
import jp.gr.java_conf.jaba2.xml.*;
import jp.gr.java_conf.jaba2.xml.relax.raw.*;
import jp.gr.java_conf.jaba2.xml.relax.cooked.*;
import jp.gr.java_conf.jaba2.xml.relax.expanded.*;
import jp.gr.java_conf.jaba2.xml.relaxng.RNGModule;

/**
 * URelax
 *
 * @since   Jan. 18, 2000
 * @version Jun. 19, 2001
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public final class URelax {
    public static CRelax buildCModel(URL url) throws IOException {
	return (buildCModel(url, null));
    }

    public static CRelax buildCModel(URL url, String baseURI)
	throws IOException {

	IProcessor processor = ProcessorFactory.getProcessor();
	return (buildCModel(url, processor, baseURI));
    }

    public static ERelax buildEModel(URL url) throws IOException {
	IProcessor processor = ProcessorFactory.getProcessor();
	return (buildEModel(url, processor));
    }

    public static CRelax buildCModel(
	URL url,
	IProcessor processor,
	String baseURI
    ) throws IOException {
	Document doc = processor.parseValidDocument(url);
	return (buildCModel(url, doc, baseURI));
    }

    public static CRelax buildCModel(
	URL url,
	Document doc,
	String baseURI
    ) {
	if (baseURI == null) {
	    baseURI = UURL.getBaseURI(url);
	}
	RRelax rrelax = URRelax.buildModel(doc, baseURI);
	RModule[] rmodules = rrelax.getModules();
	for (int i = 0;i < rmodules.length;i++) {
	    rmodules[i].setFileURI(url.toExternalForm());
	}
	RNGModule[] ngModules = rrelax.getNgModules();
	for (int i = 0;i < ngModules.length;i++) {
	    ngModules[i].setFileURI(url.toExternalForm());
	}
	CRelax crelax = UCRelax.buildModel(rrelax);
	return (crelax);
    }


    public static ERelax buildEModel(URL url, IProcessor processor)
	throws IOException {
	Document doc = processor.parseValidDocument(url);
	RRelax rrelax = URRelax.buildModel(doc);
	CRelax crelax = UCRelax.buildModel(rrelax);
	ERelax erelax = UERule.buildModel(crelax);
	return (erelax);
    }
}
