package jp.gr.java_conf.jaba2.xml.mathml.relaxer;

import org.w3c.dom.*;

/**
 * <b>MInterval</b> is generated by Relaxer based on MathML.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="interval">
 *   <choice occurs="*">
 *     <ref label="ci"/>
 *     <ref label="cn"/>
 *     <ref label="apply"/>
 *     <ref label="reln"/>
 *     <ref label="lambda"/>
 *     <ref label="condition"/>
 *     <ref label="declare"/>
 *     <ref label="sep"/>
 *     <ref label="semantics"/>
 *     <ref label="annotation"/>
 *     <ref label="annotation-xml"/>
 *     <ref label="interval"/>
 *     <ref label="list"/>
 *     <ref label="matrix"/>
 *     <ref label="matrixrow"/>
 *     <ref label="set"/>
 *     <ref label="vector"/>
 *     <ref label="lowlimit"/>
 *     <ref label="uplimit"/>
 *     <ref label="bvar"/>
 *     <ref label="degree"/>
 *     <ref label="logbase"/>
 *     <ref label="inverse"/>
 *     <ref label="ident"/>
 *     <ref label="abs"/>
 *     <ref label="conjugate"/>
 *     <ref label="exp"/>
 *     <ref label="factorial"/>
 *     <ref label="not"/>
 *     <ref label="ln"/>
 *     <ref label="sin"/>
 *     <ref label="cos"/>
 *     <ref label="tan"/>
 *     <ref label="sec"/>
 *     <ref label="csc"/>
 *     <ref label="cot"/>
 *     <ref label="sinh"/>
 *     <ref label="cosh"/>
 *     <ref label="tanh"/>
 *     <ref label="sech"/>
 *     <ref label="csch"/>
 *     <ref label="coth"/>
 *     <ref label="arcsin"/>
 *     <ref label="arccos"/>
 *     <ref label="arctan"/>
 *     <ref label="determinant"/>
 *     <ref label="transpose"/>
 *     <ref label="quotient"/>
 *     <ref label="divide"/>
 *     <ref label="power"/>
 *     <ref label="rem"/>
 *     <ref label="implies"/>
 *     <ref label="setdiff"/>
 *     <ref label="fn"/>
 *     <ref label="compose"/>
 *     <ref label="plus"/>
 *     <ref label="times"/>
 *     <ref label="max"/>
 *     <ref label="min"/>
 *     <ref label="gcd"/>
 *     <ref label="and"/>
 *     <ref label="or"/>
 *     <ref label="xor"/>
 *     <ref label="union"/>
 *     <ref label="intersect"/>
 *     <ref label="mean"/>
 *     <ref label="sdev"/>
 *     <ref label="variance"/>
 *     <ref label="median"/>
 *     <ref label="mode"/>
 *     <ref label="selector"/>
 *     <ref label="root"/>
 *     <ref label="minus"/>
 *     <ref label="log"/>
 *     <ref label="int"/>
 *     <ref label="diff"/>
 *     <ref label="partialdiff"/>
 *     <ref label="sum"/>
 *     <ref label="product"/>
 *     <ref label="limit"/>
 *     <ref label="moment"/>
 *     <ref label="exists"/>
 *     <ref label="forall"/>
 *     <ref label="neq"/>
 *     <ref label="in"/>
 *     <ref label="notin"/>
 *     <ref label="notsubset"/>
 *     <ref label="notprsubset"/>
 *     <ref label="tendsto"/>
 *     <ref label="eq"/>
 *     <ref label="leq"/>
 *     <ref label="lt"/>
 *     <ref label="geq"/>
 *     <ref label="gt"/>
 *     <ref label="subset"/>
 *     <ref label="prsubset"/>
 *     <ref label="mi"/>
 *     <ref label="mn"/>
 *     <ref label="mo"/>
 *     <ref label="mtext"/>
 *     <ref label="ms"/>
 *     <ref label="mspace"/>
 *     <ref label="mrow"/>
 *     <ref label="mfrac"/>
 *     <ref label="msqrt"/>
 *     <ref label="mroot"/>
 *     <ref label="mstyle"/>
 *     <ref label="merror"/>
 *     <ref label="mpadded"/>
 *     <ref label="mphantom"/>
 *     <ref label="mfenced"/>
 *     <ref label="msub"/>
 *     <ref label="msup"/>
 *     <ref label="msubsup"/>
 *     <ref label="munder"/>
 *     <ref label="mover"/>
 *     <ref label="munderover"/>
 *     <ref label="mmultiscripts"/>
 *     <ref label="mtable"/>
 *     <ref label="mtr"/>
 *     <ref label="mtd"/>
 *     <ref label="maligngroup"/>
 *     <ref label="malignmark"/>
 *     <ref label="maction"/>
 *   </choice>
 * </elementRule>
 * 
 * <tag name="interval">
 *   <attribute name="closure" type="string"/>
 *   <attribute name="class" type="string"/>
 *   <attribute name="style" type="string"/>
 *   <attribute name="id" type="ID"/>
 *   <attribute name="other" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="interval"&gt;
 *   &lt;choice occurs="*"&gt;
 *     &lt;ref label="ci"/&gt;
 *     &lt;ref label="cn"/&gt;
 *     &lt;ref label="apply"/&gt;
 *     &lt;ref label="reln"/&gt;
 *     &lt;ref label="lambda"/&gt;
 *     &lt;ref label="condition"/&gt;
 *     &lt;ref label="declare"/&gt;
 *     &lt;ref label="sep"/&gt;
 *     &lt;ref label="semantics"/&gt;
 *     &lt;ref label="annotation"/&gt;
 *     &lt;ref label="annotation-xml"/&gt;
 *     &lt;ref label="interval"/&gt;
 *     &lt;ref label="list"/&gt;
 *     &lt;ref label="matrix"/&gt;
 *     &lt;ref label="matrixrow"/&gt;
 *     &lt;ref label="set"/&gt;
 *     &lt;ref label="vector"/&gt;
 *     &lt;ref label="lowlimit"/&gt;
 *     &lt;ref label="uplimit"/&gt;
 *     &lt;ref label="bvar"/&gt;
 *     &lt;ref label="degree"/&gt;
 *     &lt;ref label="logbase"/&gt;
 *     &lt;ref label="inverse"/&gt;
 *     &lt;ref label="ident"/&gt;
 *     &lt;ref label="abs"/&gt;
 *     &lt;ref label="conjugate"/&gt;
 *     &lt;ref label="exp"/&gt;
 *     &lt;ref label="factorial"/&gt;
 *     &lt;ref label="not"/&gt;
 *     &lt;ref label="ln"/&gt;
 *     &lt;ref label="sin"/&gt;
 *     &lt;ref label="cos"/&gt;
 *     &lt;ref label="tan"/&gt;
 *     &lt;ref label="sec"/&gt;
 *     &lt;ref label="csc"/&gt;
 *     &lt;ref label="cot"/&gt;
 *     &lt;ref label="sinh"/&gt;
 *     &lt;ref label="cosh"/&gt;
 *     &lt;ref label="tanh"/&gt;
 *     &lt;ref label="sech"/&gt;
 *     &lt;ref label="csch"/&gt;
 *     &lt;ref label="coth"/&gt;
 *     &lt;ref label="arcsin"/&gt;
 *     &lt;ref label="arccos"/&gt;
 *     &lt;ref label="arctan"/&gt;
 *     &lt;ref label="determinant"/&gt;
 *     &lt;ref label="transpose"/&gt;
 *     &lt;ref label="quotient"/&gt;
 *     &lt;ref label="divide"/&gt;
 *     &lt;ref label="power"/&gt;
 *     &lt;ref label="rem"/&gt;
 *     &lt;ref label="implies"/&gt;
 *     &lt;ref label="setdiff"/&gt;
 *     &lt;ref label="fn"/&gt;
 *     &lt;ref label="compose"/&gt;
 *     &lt;ref label="plus"/&gt;
 *     &lt;ref label="times"/&gt;
 *     &lt;ref label="max"/&gt;
 *     &lt;ref label="min"/&gt;
 *     &lt;ref label="gcd"/&gt;
 *     &lt;ref label="and"/&gt;
 *     &lt;ref label="or"/&gt;
 *     &lt;ref label="xor"/&gt;
 *     &lt;ref label="union"/&gt;
 *     &lt;ref label="intersect"/&gt;
 *     &lt;ref label="mean"/&gt;
 *     &lt;ref label="sdev"/&gt;
 *     &lt;ref label="variance"/&gt;
 *     &lt;ref label="median"/&gt;
 *     &lt;ref label="mode"/&gt;
 *     &lt;ref label="selector"/&gt;
 *     &lt;ref label="root"/&gt;
 *     &lt;ref label="minus"/&gt;
 *     &lt;ref label="log"/&gt;
 *     &lt;ref label="int"/&gt;
 *     &lt;ref label="diff"/&gt;
 *     &lt;ref label="partialdiff"/&gt;
 *     &lt;ref label="sum"/&gt;
 *     &lt;ref label="product"/&gt;
 *     &lt;ref label="limit"/&gt;
 *     &lt;ref label="moment"/&gt;
 *     &lt;ref label="exists"/&gt;
 *     &lt;ref label="forall"/&gt;
 *     &lt;ref label="neq"/&gt;
 *     &lt;ref label="in"/&gt;
 *     &lt;ref label="notin"/&gt;
 *     &lt;ref label="notsubset"/&gt;
 *     &lt;ref label="notprsubset"/&gt;
 *     &lt;ref label="tendsto"/&gt;
 *     &lt;ref label="eq"/&gt;
 *     &lt;ref label="leq"/&gt;
 *     &lt;ref label="lt"/&gt;
 *     &lt;ref label="geq"/&gt;
 *     &lt;ref label="gt"/&gt;
 *     &lt;ref label="subset"/&gt;
 *     &lt;ref label="prsubset"/&gt;
 *     &lt;ref label="mi"/&gt;
 *     &lt;ref label="mn"/&gt;
 *     &lt;ref label="mo"/&gt;
 *     &lt;ref label="mtext"/&gt;
 *     &lt;ref label="ms"/&gt;
 *     &lt;ref label="mspace"/&gt;
 *     &lt;ref label="mrow"/&gt;
 *     &lt;ref label="mfrac"/&gt;
 *     &lt;ref label="msqrt"/&gt;
 *     &lt;ref label="mroot"/&gt;
 *     &lt;ref label="mstyle"/&gt;
 *     &lt;ref label="merror"/&gt;
 *     &lt;ref label="mpadded"/&gt;
 *     &lt;ref label="mphantom"/&gt;
 *     &lt;ref label="mfenced"/&gt;
 *     &lt;ref label="msub"/&gt;
 *     &lt;ref label="msup"/&gt;
 *     &lt;ref label="msubsup"/&gt;
 *     &lt;ref label="munder"/&gt;
 *     &lt;ref label="mover"/&gt;
 *     &lt;ref label="munderover"/&gt;
 *     &lt;ref label="mmultiscripts"/&gt;
 *     &lt;ref label="mtable"/&gt;
 *     &lt;ref label="mtr"/&gt;
 *     &lt;ref label="mtd"/&gt;
 *     &lt;ref label="maligngroup"/&gt;
 *     &lt;ref label="malignmark"/&gt;
 *     &lt;ref label="maction"/&gt;
 *   &lt;/choice&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="interval"&gt;
 *   &lt;attribute name="closure" type="string"/&gt;
 *   &lt;attribute name="class" type="string"/&gt;
 *   &lt;attribute name="style" type="string"/&gt;
 *   &lt;attribute name="id" type="ID"/&gt;
 *   &lt;attribute name="other" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version MathML.rlx 1.0 (Sat Sep 09 10:48:44 JST 2000)
 * @author  Relaxer 0.11b (by ASAMI@Yokohama)
 */
public class MInterval implements java.io.Serializable, IMIntervalContent, IMListContent, IMMatrixContent, IMMatrixrowContent, IMSetContent, IMVectorContent, IMLowlimitContent, IMUplimitContent, IMBvarContent, IMDegreeContent, IMLogbaseContent, IMFnContent, IRVisitable, IRNode, IMAnnotationXmlContent, IMSemanticsContent, IMDeclareContent, IMConditionContent, IMLambdaContent, IMRelnContent, IMApplyContent, IMMactionContent, IMMtdContent, IMMtrContent, IMMtableContent, IMMmultiscriptsContent, IMMunderoverContent, IMMoverContent, IMMunderContent, IMMsubsupContent, IMMsupContent, IMMsubContent, IMMfencedContent, IMMphantomContent, IMMpaddedContent, IMMerrorContent, IMMstyleContent, IMMrootContent, IMMsqrtContent, IMMfracContent, IMMrowContent, IMMathContent {
    private String closure;
    private String classValue;
    private String style;
    private String id;
    private String other;
    // List<IMIntervalContent>
    private java.util.List content = new java.util.ArrayList();
    private IRNode parentRNode;

    /**
     * Creates a <code>MInterval</code>.
     *
     */
    public MInterval() {
    }

    /**
     * Creates a <code>MInterval</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public MInterval(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>MInterval</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public MInterval(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>MInterval</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public MInterval(Element element) {
        setup(element);
    }

    /**
     * Initializes the <code>MInterval</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>MInterval</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>MInterval</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        closure = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "closure");
        classValue = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "class");
        style = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "style");
        id = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "id");
        other = URelaxer2.getAttributePropertyAsString(element, "http://www.w3.org/1998/Math/MathML", "other");
        content.clear();
        while (!stack.isEmptyElement()) {
            if (MCi.isMatch(stack)) {
                addContent(new MCi(stack));
            } else if (MCn.isMatch(stack)) {
                addContent(new MCn(stack));
            } else if (MApply.isMatch(stack)) {
                addContent(new MApply(stack));
            } else if (MReln.isMatch(stack)) {
                addContent(new MReln(stack));
            } else if (MLambda.isMatch(stack)) {
                addContent(new MLambda(stack));
            } else if (MCondition.isMatch(stack)) {
                addContent(new MCondition(stack));
            } else if (MDeclare.isMatch(stack)) {
                addContent(new MDeclare(stack));
            } else if (MSep.isMatch(stack)) {
                addContent(new MSep(stack));
            } else if (MSemantics.isMatch(stack)) {
                addContent(new MSemantics(stack));
            } else if (MAnnotation.isMatch(stack)) {
                addContent(new MAnnotation(stack));
            } else if (MAnnotationXml.isMatch(stack)) {
                addContent(new MAnnotationXml(stack));
            } else if (MInterval.isMatch(stack)) {
                addContent(new MInterval(stack));
            } else if (MList.isMatch(stack)) {
                addContent(new MList(stack));
            } else if (MMatrix.isMatch(stack)) {
                addContent(new MMatrix(stack));
            } else if (MMatrixrow.isMatch(stack)) {
                addContent(new MMatrixrow(stack));
            } else if (MSet.isMatch(stack)) {
                addContent(new MSet(stack));
            } else if (MVector.isMatch(stack)) {
                addContent(new MVector(stack));
            } else if (MLowlimit.isMatch(stack)) {
                addContent(new MLowlimit(stack));
            } else if (MUplimit.isMatch(stack)) {
                addContent(new MUplimit(stack));
            } else if (MBvar.isMatch(stack)) {
                addContent(new MBvar(stack));
            } else if (MDegree.isMatch(stack)) {
                addContent(new MDegree(stack));
            } else if (MLogbase.isMatch(stack)) {
                addContent(new MLogbase(stack));
            } else if (MInverse.isMatch(stack)) {
                addContent(new MInverse(stack));
            } else if (MIdent.isMatch(stack)) {
                addContent(new MIdent(stack));
            } else if (MAbs.isMatch(stack)) {
                addContent(new MAbs(stack));
            } else if (MConjugate.isMatch(stack)) {
                addContent(new MConjugate(stack));
            } else if (MExp.isMatch(stack)) {
                addContent(new MExp(stack));
            } else if (MFactorial.isMatch(stack)) {
                addContent(new MFactorial(stack));
            } else if (MNot.isMatch(stack)) {
                addContent(new MNot(stack));
            } else if (MLn.isMatch(stack)) {
                addContent(new MLn(stack));
            } else if (MSin.isMatch(stack)) {
                addContent(new MSin(stack));
            } else if (MCos.isMatch(stack)) {
                addContent(new MCos(stack));
            } else if (MTan.isMatch(stack)) {
                addContent(new MTan(stack));
            } else if (MSec.isMatch(stack)) {
                addContent(new MSec(stack));
            } else if (MCsc.isMatch(stack)) {
                addContent(new MCsc(stack));
            } else if (MCot.isMatch(stack)) {
                addContent(new MCot(stack));
            } else if (MSinh.isMatch(stack)) {
                addContent(new MSinh(stack));
            } else if (MCosh.isMatch(stack)) {
                addContent(new MCosh(stack));
            } else if (MTanh.isMatch(stack)) {
                addContent(new MTanh(stack));
            } else if (MSech.isMatch(stack)) {
                addContent(new MSech(stack));
            } else if (MCsch.isMatch(stack)) {
                addContent(new MCsch(stack));
            } else if (MCoth.isMatch(stack)) {
                addContent(new MCoth(stack));
            } else if (MArcsin.isMatch(stack)) {
                addContent(new MArcsin(stack));
            } else if (MArccos.isMatch(stack)) {
                addContent(new MArccos(stack));
            } else if (MArctan.isMatch(stack)) {
                addContent(new MArctan(stack));
            } else if (MDeterminant.isMatch(stack)) {
                addContent(new MDeterminant(stack));
            } else if (MTranspose.isMatch(stack)) {
                addContent(new MTranspose(stack));
            } else if (MQuotient.isMatch(stack)) {
                addContent(new MQuotient(stack));
            } else if (MDivide.isMatch(stack)) {
                addContent(new MDivide(stack));
            } else if (MPower.isMatch(stack)) {
                addContent(new MPower(stack));
            } else if (MRem.isMatch(stack)) {
                addContent(new MRem(stack));
            } else if (MImplies.isMatch(stack)) {
                addContent(new MImplies(stack));
            } else if (MSetdiff.isMatch(stack)) {
                addContent(new MSetdiff(stack));
            } else if (MFn.isMatch(stack)) {
                addContent(new MFn(stack));
            } else if (MCompose.isMatch(stack)) {
                addContent(new MCompose(stack));
            } else if (MPlus.isMatch(stack)) {
                addContent(new MPlus(stack));
            } else if (MTimes.isMatch(stack)) {
                addContent(new MTimes(stack));
            } else if (MMax.isMatch(stack)) {
                addContent(new MMax(stack));
            } else if (MMin.isMatch(stack)) {
                addContent(new MMin(stack));
            } else if (MGcd.isMatch(stack)) {
                addContent(new MGcd(stack));
            } else if (MAnd.isMatch(stack)) {
                addContent(new MAnd(stack));
            } else if (MOr.isMatch(stack)) {
                addContent(new MOr(stack));
            } else if (MXor.isMatch(stack)) {
                addContent(new MXor(stack));
            } else if (MUnion.isMatch(stack)) {
                addContent(new MUnion(stack));
            } else if (MIntersect.isMatch(stack)) {
                addContent(new MIntersect(stack));
            } else if (MMean.isMatch(stack)) {
                addContent(new MMean(stack));
            } else if (MSdev.isMatch(stack)) {
                addContent(new MSdev(stack));
            } else if (MVariance.isMatch(stack)) {
                addContent(new MVariance(stack));
            } else if (MMedian.isMatch(stack)) {
                addContent(new MMedian(stack));
            } else if (MMode.isMatch(stack)) {
                addContent(new MMode(stack));
            } else if (MSelector.isMatch(stack)) {
                addContent(new MSelector(stack));
            } else if (MRoot.isMatch(stack)) {
                addContent(new MRoot(stack));
            } else if (MMinus.isMatch(stack)) {
                addContent(new MMinus(stack));
            } else if (MLog.isMatch(stack)) {
                addContent(new MLog(stack));
            } else if (MInt.isMatch(stack)) {
                addContent(new MInt(stack));
            } else if (MDiff.isMatch(stack)) {
                addContent(new MDiff(stack));
            } else if (MPartialdiff.isMatch(stack)) {
                addContent(new MPartialdiff(stack));
            } else if (MSum.isMatch(stack)) {
                addContent(new MSum(stack));
            } else if (MProduct.isMatch(stack)) {
                addContent(new MProduct(stack));
            } else if (MLimit.isMatch(stack)) {
                addContent(new MLimit(stack));
            } else if (MMoment.isMatch(stack)) {
                addContent(new MMoment(stack));
            } else if (MExists.isMatch(stack)) {
                addContent(new MExists(stack));
            } else if (MForall.isMatch(stack)) {
                addContent(new MForall(stack));
            } else if (MNeq.isMatch(stack)) {
                addContent(new MNeq(stack));
            } else if (MIn.isMatch(stack)) {
                addContent(new MIn(stack));
            } else if (MNotin.isMatch(stack)) {
                addContent(new MNotin(stack));
            } else if (MNotsubset.isMatch(stack)) {
                addContent(new MNotsubset(stack));
            } else if (MNotprsubset.isMatch(stack)) {
                addContent(new MNotprsubset(stack));
            } else if (MTendsto.isMatch(stack)) {
                addContent(new MTendsto(stack));
            } else if (MEq.isMatch(stack)) {
                addContent(new MEq(stack));
            } else if (MLeq.isMatch(stack)) {
                addContent(new MLeq(stack));
            } else if (MLt.isMatch(stack)) {
                addContent(new MLt(stack));
            } else if (MGeq.isMatch(stack)) {
                addContent(new MGeq(stack));
            } else if (MGt.isMatch(stack)) {
                addContent(new MGt(stack));
            } else if (MSubset.isMatch(stack)) {
                addContent(new MSubset(stack));
            } else if (MPrsubset.isMatch(stack)) {
                addContent(new MPrsubset(stack));
            } else if (MMi.isMatch(stack)) {
                addContent(new MMi(stack));
            } else if (MMn.isMatch(stack)) {
                addContent(new MMn(stack));
            } else if (MMo.isMatch(stack)) {
                addContent(new MMo(stack));
            } else if (MMtext.isMatch(stack)) {
                addContent(new MMtext(stack));
            } else if (MMs.isMatch(stack)) {
                addContent(new MMs(stack));
            } else if (MMspace.isMatch(stack)) {
                addContent(new MMspace(stack));
            } else if (MMrow.isMatch(stack)) {
                addContent(new MMrow(stack));
            } else if (MMfrac.isMatch(stack)) {
                addContent(new MMfrac(stack));
            } else if (MMsqrt.isMatch(stack)) {
                addContent(new MMsqrt(stack));
            } else if (MMroot.isMatch(stack)) {
                addContent(new MMroot(stack));
            } else if (MMstyle.isMatch(stack)) {
                addContent(new MMstyle(stack));
            } else if (MMerror.isMatch(stack)) {
                addContent(new MMerror(stack));
            } else if (MMpadded.isMatch(stack)) {
                addContent(new MMpadded(stack));
            } else if (MMphantom.isMatch(stack)) {
                addContent(new MMphantom(stack));
            } else if (MMfenced.isMatch(stack)) {
                addContent(new MMfenced(stack));
            } else if (MMsub.isMatch(stack)) {
                addContent(new MMsub(stack));
            } else if (MMsup.isMatch(stack)) {
                addContent(new MMsup(stack));
            } else if (MMsubsup.isMatch(stack)) {
                addContent(new MMsubsup(stack));
            } else if (MMunder.isMatch(stack)) {
                addContent(new MMunder(stack));
            } else if (MMover.isMatch(stack)) {
                addContent(new MMover(stack));
            } else if (MMunderover.isMatch(stack)) {
                addContent(new MMunderover(stack));
            } else if (MMmultiscripts.isMatch(stack)) {
                addContent(new MMmultiscripts(stack));
            } else if (MMtable.isMatch(stack)) {
                addContent(new MMtable(stack));
            } else if (MMtr.isMatch(stack)) {
                addContent(new MMtr(stack));
            } else if (MMtd.isMatch(stack)) {
                addContent(new MMtd(stack));
            } else if (MMaligngroup.isMatch(stack)) {
                addContent(new MMaligngroup(stack));
            } else if (MMalignmark.isMatch(stack)) {
                addContent(new MMalignmark(stack));
            } else if (MMaction.isMatch(stack)) {
                addContent(new MMaction(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("interval");
        int size;
        if (closure != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "closure", closure);
        }
        if (classValue != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "class", classValue);
        }
        if (style != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "style", style);
        }
        if (id != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "id", id);
        }
        if (other != null) {
            URelaxer2.setAttributePropertyByString(element, "http://www.w3.org/1998/Math/MathML", "other", other);
        }
        size = content.size();
        for (int i = 0;i < size;i++) {
            IMIntervalContent value = (IMIntervalContent)this.content.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Gets the String property <b>closure</b>.
     *
     * @return String
     */
    public final String getClosure() {
        return (closure);
    }

    /**
     * Sets the String property <b>closure</b>.
     *
     * @param closure
     */
    public final void setClosure(String closure) {
        this.closure = closure;
    }

    /**
     * Gets the String property <b>classValue</b>.
     *
     * @return String
     */
    public final String getClassValue() {
        return (classValue);
    }

    /**
     * Sets the String property <b>classValue</b>.
     *
     * @param classValue
     */
    public final void setClassValue(String classValue) {
        this.classValue = classValue;
    }

    /**
     * Gets the String property <b>style</b>.
     *
     * @return String
     */
    public final String getStyle() {
        return (style);
    }

    /**
     * Sets the String property <b>style</b>.
     *
     * @param style
     */
    public final void setStyle(String style) {
        this.style = style;
    }

    /**
     * Gets the String property <b>id</b>.
     *
     * @return String
     */
    public final String getId() {
        return (id);
    }

    /**
     * Sets the String property <b>id</b>.
     *
     * @param id
     */
    public final void setId(String id) {
        this.id = id;
    }

    /**
     * Gets the String property <b>other</b>.
     *
     * @return String
     */
    public final String getOther() {
        return (other);
    }

    /**
     * Sets the String property <b>other</b>.
     *
     * @param other
     */
    public final void setOther(String other) {
        this.other = other;
    }

    /**
     * Gets the IMIntervalContent property <b>content</b>.
     *
     * @return IMIntervalContent[]
     */
    public final IMIntervalContent[] getContent() {
        IMIntervalContent[] array = new IMIntervalContent[content.size()];
        return ((IMIntervalContent[])content.toArray(array));
    }

    /**
     * Sets the IMIntervalContent property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IMIntervalContent[] content) {
        this.content.clear();
        this.content.addAll(java.util.Arrays.asList(content));
        for (int i = 0;i < content.length;i++) {
            content[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IMIntervalContent property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IMIntervalContent content) {
        this.content.clear();
        this.content.add(content);
        content.setParentRNode(this);
    }

    /**
     * Adds the IMIntervalContent property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IMIntervalContent content) {
        this.content.add(content);
        content.setParentRNode(this);
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     */
    public void enter(IRVisitor visitor) {
        visitor.enter(this);
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>MInterval</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://www.w3.org/1998/Math/MathML", "interval")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (MCi.isMatchHungry(target)) {
            } else if (MCn.isMatchHungry(target)) {
            } else if (MApply.isMatchHungry(target)) {
            } else if (MReln.isMatchHungry(target)) {
            } else if (MLambda.isMatchHungry(target)) {
            } else if (MCondition.isMatchHungry(target)) {
            } else if (MDeclare.isMatchHungry(target)) {
            } else if (MSep.isMatchHungry(target)) {
            } else if (MSemantics.isMatchHungry(target)) {
            } else if (MAnnotation.isMatchHungry(target)) {
            } else if (MAnnotationXml.isMatchHungry(target)) {
            } else if (MInterval.isMatchHungry(target)) {
            } else if (MList.isMatchHungry(target)) {
            } else if (MMatrix.isMatchHungry(target)) {
            } else if (MMatrixrow.isMatchHungry(target)) {
            } else if (MSet.isMatchHungry(target)) {
            } else if (MVector.isMatchHungry(target)) {
            } else if (MLowlimit.isMatchHungry(target)) {
            } else if (MUplimit.isMatchHungry(target)) {
            } else if (MBvar.isMatchHungry(target)) {
            } else if (MDegree.isMatchHungry(target)) {
            } else if (MLogbase.isMatchHungry(target)) {
            } else if (MInverse.isMatchHungry(target)) {
            } else if (MIdent.isMatchHungry(target)) {
            } else if (MAbs.isMatchHungry(target)) {
            } else if (MConjugate.isMatchHungry(target)) {
            } else if (MExp.isMatchHungry(target)) {
            } else if (MFactorial.isMatchHungry(target)) {
            } else if (MNot.isMatchHungry(target)) {
            } else if (MLn.isMatchHungry(target)) {
            } else if (MSin.isMatchHungry(target)) {
            } else if (MCos.isMatchHungry(target)) {
            } else if (MTan.isMatchHungry(target)) {
            } else if (MSec.isMatchHungry(target)) {
            } else if (MCsc.isMatchHungry(target)) {
            } else if (MCot.isMatchHungry(target)) {
            } else if (MSinh.isMatchHungry(target)) {
            } else if (MCosh.isMatchHungry(target)) {
            } else if (MTanh.isMatchHungry(target)) {
            } else if (MSech.isMatchHungry(target)) {
            } else if (MCsch.isMatchHungry(target)) {
            } else if (MCoth.isMatchHungry(target)) {
            } else if (MArcsin.isMatchHungry(target)) {
            } else if (MArccos.isMatchHungry(target)) {
            } else if (MArctan.isMatchHungry(target)) {
            } else if (MDeterminant.isMatchHungry(target)) {
            } else if (MTranspose.isMatchHungry(target)) {
            } else if (MQuotient.isMatchHungry(target)) {
            } else if (MDivide.isMatchHungry(target)) {
            } else if (MPower.isMatchHungry(target)) {
            } else if (MRem.isMatchHungry(target)) {
            } else if (MImplies.isMatchHungry(target)) {
            } else if (MSetdiff.isMatchHungry(target)) {
            } else if (MFn.isMatchHungry(target)) {
            } else if (MCompose.isMatchHungry(target)) {
            } else if (MPlus.isMatchHungry(target)) {
            } else if (MTimes.isMatchHungry(target)) {
            } else if (MMax.isMatchHungry(target)) {
            } else if (MMin.isMatchHungry(target)) {
            } else if (MGcd.isMatchHungry(target)) {
            } else if (MAnd.isMatchHungry(target)) {
            } else if (MOr.isMatchHungry(target)) {
            } else if (MXor.isMatchHungry(target)) {
            } else if (MUnion.isMatchHungry(target)) {
            } else if (MIntersect.isMatchHungry(target)) {
            } else if (MMean.isMatchHungry(target)) {
            } else if (MSdev.isMatchHungry(target)) {
            } else if (MVariance.isMatchHungry(target)) {
            } else if (MMedian.isMatchHungry(target)) {
            } else if (MMode.isMatchHungry(target)) {
            } else if (MSelector.isMatchHungry(target)) {
            } else if (MRoot.isMatchHungry(target)) {
            } else if (MMinus.isMatchHungry(target)) {
            } else if (MLog.isMatchHungry(target)) {
            } else if (MInt.isMatchHungry(target)) {
            } else if (MDiff.isMatchHungry(target)) {
            } else if (MPartialdiff.isMatchHungry(target)) {
            } else if (MSum.isMatchHungry(target)) {
            } else if (MProduct.isMatchHungry(target)) {
            } else if (MLimit.isMatchHungry(target)) {
            } else if (MMoment.isMatchHungry(target)) {
            } else if (MExists.isMatchHungry(target)) {
            } else if (MForall.isMatchHungry(target)) {
            } else if (MNeq.isMatchHungry(target)) {
            } else if (MIn.isMatchHungry(target)) {
            } else if (MNotin.isMatchHungry(target)) {
            } else if (MNotsubset.isMatchHungry(target)) {
            } else if (MNotprsubset.isMatchHungry(target)) {
            } else if (MTendsto.isMatchHungry(target)) {
            } else if (MEq.isMatchHungry(target)) {
            } else if (MLeq.isMatchHungry(target)) {
            } else if (MLt.isMatchHungry(target)) {
            } else if (MGeq.isMatchHungry(target)) {
            } else if (MGt.isMatchHungry(target)) {
            } else if (MSubset.isMatchHungry(target)) {
            } else if (MPrsubset.isMatchHungry(target)) {
            } else if (MMi.isMatchHungry(target)) {
            } else if (MMn.isMatchHungry(target)) {
            } else if (MMo.isMatchHungry(target)) {
            } else if (MMtext.isMatchHungry(target)) {
            } else if (MMs.isMatchHungry(target)) {
            } else if (MMspace.isMatchHungry(target)) {
            } else if (MMrow.isMatchHungry(target)) {
            } else if (MMfrac.isMatchHungry(target)) {
            } else if (MMsqrt.isMatchHungry(target)) {
            } else if (MMroot.isMatchHungry(target)) {
            } else if (MMstyle.isMatchHungry(target)) {
            } else if (MMerror.isMatchHungry(target)) {
            } else if (MMpadded.isMatchHungry(target)) {
            } else if (MMphantom.isMatchHungry(target)) {
            } else if (MMfenced.isMatchHungry(target)) {
            } else if (MMsub.isMatchHungry(target)) {
            } else if (MMsup.isMatchHungry(target)) {
            } else if (MMsubsup.isMatchHungry(target)) {
            } else if (MMunder.isMatchHungry(target)) {
            } else if (MMover.isMatchHungry(target)) {
            } else if (MMunderover.isMatchHungry(target)) {
            } else if (MMmultiscripts.isMatchHungry(target)) {
            } else if (MMtable.isMatchHungry(target)) {
            } else if (MMtr.isMatchHungry(target)) {
            } else if (MMtd.isMatchHungry(target)) {
            } else if (MMaligngroup.isMatchHungry(target)) {
            } else if (MMalignmark.isMatchHungry(target)) {
            } else if (MMaction.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MInterval</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>MInterval</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
