/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2002  ASAMI, Tomoharu (asami@AsamiOffice.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.UElement;
import jp.gr.java_conf.jaba2.datatype.IXMLDatatype;
import jp.gr.java_conf.jaba2.datatype.XMLFacet;

/**
 * Datatype
 *
 * @since   Feb. 23, 2000
 * @version Jul. 14, 2002
 * @author  ASAMI, Tomoharu (asami@AsamiOffice.com)
 */
public abstract class Datatype implements IXMLDatatype, Cloneable {
    private boolean isList_ = false;
    private List facets_ = new ArrayList();
    private Object property_ = null;

    public void addFacets(Element element) {
	Element[] facets = UElement.getElements(element);
	for (int i = 0;i < facets.length;i++) {
	    String localName = facets[i].getLocalName();
	    if ("length".equals(localName) ||
		"minLength".equals(localName) ||
		"maxLength".equals(localName) ||
		"pattern".equals(localName) ||
		"enumeration".equals(localName) ||
		"whiteSpace".equals(localName) ||
		"maxInclusive".equals(localName) ||
		"maxExclusive".equals(localName) ||
		"minInclusive".equals(localName) ||
		"minExclusive".equals(localName) ||
		"totalDigits".equals(localName) ||
		"fractionDigits".equals(localName)) {

		facets_.add(
		    new XMLFacet(localName, facets[i].getAttribute("value"))
		);
	    }
	}
    }

    public void addFacets(XMLFacet[] facets) {
	for (int i = 0;i < facets.length;i++) {
	    addFacet(facets[i]);
	}
    }

    public void addFacet(XMLFacet facet) {
	    facets_.add(facet);
    }

    public XMLFacet[] getFacets() {
	if (facets_.size() == 0) {
	    return (null);
	} else {
	    XMLFacet[] result = new XMLFacet[facets_.size()];
	    return ((XMLFacet[])facets_.toArray(result));
	}
    }

    public abstract String getName();

    public String makeCDATA(Object object) {
	return (object.toString());
    }

    public abstract Object makeObject(String cdata);

    public final boolean isList() {
	return (isList_);
    }

    public final void setList(boolean isList) {
	isList_ = isList;
    }

    public final Object getProperty() {
	return (property_);
    }

    public final void setProperty(Object property) {
	if (property == null) {
	    throw (new InternalError());
	}	    
	if (property instanceof jp.gr.java_conf.jaba2.xml.relax.expanded.EMixedNode) {
	    throw (new InternalError());
	}
	property_ = property;
    }

    public Object clone() {
	try {
	    return (super.clone());
	} catch (CloneNotSupportedException e) {
	    throw (new InternalError());
	}
    }
}

