/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (asami@zeomtech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml.datatype;

import java.util.*;
import org.w3c.dom.*;
import jp.gr.java_conf.jaba2.xml.*;

/**
 * DQName
 *
 * @since   Dec. 13, 2000
 * @version Dec. 13, 2000
 * @author  ASAMI, Tomoharu (asami@zeomtech.com)
 */
public class DQName extends Datatype {
    // facets : XXX
    private Integer length_;
    private Integer minlength_;
    private Integer maxlength_;
    private Integer maxInclusive_;
    private Integer maxExclusive_;
    private Integer minInclusive_;
    private Integer minExclusive_;
    private String pattern_;
    private String[] enumeration_;

    public DQName() {
    }

    public DQName(Element element) {
	SmartElement sm = new SmartElement(element);
	length_
	    = sm.getAttributeOfOnlyElementAsInteger("length", "value");
	minlength_
	    = sm.getAttributeOfOnlyElementAsInteger("minlength", "value");
	maxlength_
	    = sm.getAttributeOfOnlyElementAsInteger("maxlength", "value");
	maxInclusive_
	    = sm.getAttributeOfOnlyElementAsInteger("maxInclusive", "value");
	maxExclusive_
	    = sm.getAttributeOfOnlyElementAsInteger("maxExclusive", "value");
	minInclusive_
	    = sm.getAttributeOfOnlyElementAsInteger("minInclusive", "value");
	minExclusive_
	    = sm.getAttributeOfOnlyElementAsInteger("minExclusive", "value");
	pattern_
	    = sm.getAttributeOfOnlyElementAsString("pattern", "value");
	// XXX : enumeration_
    }

    public String getName() {
	return ("QName");
    }

    public final Integer getMinLength() {
	return (minlength_);
    }

    public final Integer getMaxLength() {
	return (maxlength_);
    }

    public final Integer getMaxInclusive() {
	return (maxInclusive_);
    }

    public final Integer getMaxExclusive() {
	return (maxExclusive_);
    }

    public final Integer getMinInclusive() {
	return (minInclusive_);
    }

    public final Integer getMinExclusive() {
	return (minExclusive_);
    }

    public final String getPattern() {
	return (pattern_);
    }

    public final String[] getEnumeration() {
	return (enumeration_);
    }

    public final Integer getLength() {
	return (length_);
    }

    public Object makeObject(String cdata) {
	return (cdata);
    }
}
