/*
 * The JabaJaba class library
 *  Copyright (C) 1997-2000  ASAMI, Tomoharu (tasami@ibm.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package jp.gr.java_conf.jaba2.xml;

import org.w3c.dom.*;

/**
 * DOMVisitorBase
 *
 * @since   Feb.  4, 2000
 * @version Feb. 12, 2000
 * @author  ASAMI, Tomoharu (tasami@ibm.net)
 */
public abstract class DOMVisitorBase implements IDOMVisitor {
    public void enter(Element element) {
	_enter(element);
    }

    public void enter(Attr attr) {
	_enter(attr);
    }

    public void enter(Text text) {
	_enter(text);
    }

    public void enter(CDATASection cdata) {
	_enter(cdata);
    }

    public void enter(EntityReference entityRef) {
	_enter(entityRef);
    }

    public void enter(Entity entity) {
	_enter(entity);
    }

    public void enter(ProcessingInstruction pi) {
	_enter(pi);
    }

    public void enter(Comment comment) {
	_enter(comment);
    }

    public void enter(Document doc) {
	_enter(doc);
    }

    public void enter(DocumentType doctype) {
	_enter(doctype);
    }

    public void enter(DocumentFragment docfrag) {
	_enter(docfrag);
    }

    public void enter(Notation notation) {
	_enter(notation);
    }

    public void enter(Node node) {
	throw (new InternalError());
    }

    protected void _enter(Node node) {
    }

    public void visit(Element element) {
	_visit(element);
    }

    public void visit(Attr attr) {
	_visit(attr);
    }

    public void visit(Text text) {
	_visit(text);
    }

    public void visit(CDATASection cdata) {
	_visit(cdata);
    }

    public void visit(EntityReference entityRef) {
	_visit(entityRef);
    }

    public void visit(Entity entity) {
	_visit(entity);
    }

    public void visit(ProcessingInstruction pi) {
	_visit(pi);
    }

    public void visit(Comment comment) {
	_visit(comment);
    }

    public void visit(Document doc) {
	_visit(doc);
    }

    public void visit(DocumentType doctype) {
	_visit(doctype);
    }

    public void visit(DocumentFragment docfrag) {
	_visit(docfrag);
    }

    public void visit(Notation notation) {
	_visit(notation);
    }

    public void visit(Node node) {
	throw (new InternalError());
    }

    protected void _visit(Node node) {
    }

    public void leave(Element element) {
	_leave(element);
    }

    public void leave(Attr attr) {
	_leave(attr);
    }

    public void leave(Text text) {
	_leave(text);
    }

    public void leave(CDATASection cdata) {
	_leave(cdata);
    }

    public void leave(EntityReference entityRef) {
	_leave(entityRef);
    }

    public void leave(Entity entity) {
	_leave(entity);
    }

    public void leave(ProcessingInstruction pi) {
	_leave(pi);
    }

    public void leave(Comment comment) {
	_leave(comment);
    }

    public void leave(Document doc) {
	_leave(doc);
    }

    public void leave(DocumentType doctype) {
	_leave(doctype);
    }

    public void leave(DocumentFragment docfrag) {
	_leave(docfrag);
    }

    public void leave(Notation notation) {
	_leave(notation);
    }

    public void leave(Node node) {
	throw (new InternalError());
    }

    protected void _leave(Node node) {
    }
}
